/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart;

import com.stimulsoft.base.system.geometry.StiPoint;

public class StiPointHelper {
    private static PointClassify GetPointClassify(StiPoint basePoint, StiPoint point1, StiPoint point2) {
        StiPoint a = new StiPoint(point2.x - point1.x, point2.y - point1.y);
        StiPoint b = new StiPoint(basePoint.x - point1.x, basePoint.y - point1.y);
        double sa = a.x * b.y - b.x * a.y;
        if (sa > 0.0) {
            return PointClassify.Left;
        }
        if (sa < 0.0) {
            return PointClassify.Right;
        }
        if (a.x * b.x < 0.0 || a.y * b.y < 0.0) {
            return PointClassify.Behind;
        }
        if (Math.sqrt(a.x * a.x + a.y * a.y) < Math.sqrt(b.x * b.x + b.y * b.y)) {
            return PointClassify.Beyond;
        }
        if (point1.equals((Object)basePoint)) {
            return PointClassify.Origin;
        }
        if (point2.equals((Object)basePoint)) {
            return PointClassify.Destination;
        }
        return PointClassify.Between;
    }

    public static boolean IsPointInTriangle(StiPoint p, StiPoint a, StiPoint b, StiPoint c) {
        return StiPointHelper.GetPointClassify(p, a, b) != PointClassify.Left && StiPointHelper.GetPointClassify(p, b, c) != PointClassify.Left && StiPointHelper.GetPointClassify(p, c, a) != PointClassify.Left;
    }

    public static boolean IsPointInPolygon(StiPoint p, StiPoint[] points) {
        for (int index = 0; index < points.length; ++index) {
            if (StiPointHelper.GetPointClassify(p, points[index], index + 1 < points.length ? points[index + 1] : points[0]) != PointClassify.Left) continue;
            return false;
        }
        return true;
    }

    public static StiPoint[] GetLineOffsetRectangle(StiPoint point1, StiPoint point2, double offset) {
        double angle = Math.atan2(point2.y - point1.y, point2.x - point1.x);
        double halfDist = offset / 2.0;
        StiPoint[] points = new StiPoint[]{new StiPoint((double)((float)(point1.x + halfDist * Math.cos(angle + 1.5707963267948966))), (double)((float)(point1.y + halfDist * Math.sin(angle + 1.5707963267948966)))), new StiPoint((double)((float)(point2.x + halfDist * Math.cos(angle + 1.5707963267948966))), (double)((float)(point2.y + halfDist * Math.sin(angle + 1.5707963267948966)))), new StiPoint((double)((float)(point2.x + halfDist * Math.cos(angle + 4.71238898038469))), (double)((float)(point2.y + halfDist * Math.sin(angle + 4.71238898038469)))), new StiPoint((double)((float)(point1.x + halfDist * Math.cos(angle + 4.71238898038469))), (double)((float)(point1.y + halfDist * Math.sin(angle + 4.71238898038469))))};
        return points;
    }

    public static boolean IsLineContainsPoint(StiPoint startPoint, StiPoint endPoint, float offset, StiPoint point) {
        StiPoint[] points = StiPointHelper.GetLineOffsetRectangle(startPoint, endPoint, offset);
        return StiPointHelper.IsPointInPolygon(point, points);
    }

    private static enum PointClassify {
        Left,
        Right,
        Beyond,
        Behind,
        Between,
        Origin,
        Destination;


        public int getValue() {
            return this.ordinal();
        }

        public static PointClassify forValue(int value) {
            return PointClassify.values()[value];
        }
    }
}

