/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart;

import com.stimulsoft.report.chart.StiSeriesPoint;
import com.stimulsoft.report.chart.view.series.StiSeries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StiSeriesPointCollection
extends ArrayList<StiSeriesPoint> {
    private static final long serialVersionUID = -6315499512128181209L;
    private static final Comparator<StiSeriesPoint> COMPARATOR_BY_INDEX = new Comparator<StiSeriesPoint>(){

        @Override
        public int compare(StiSeriesPoint o1, StiSeriesPoint o2) {
            return Double.compare(o1.index, o2.index);
        }
    };
    private static final Comparator<StiSeriesPoint> COMPARATOR_BY_VALUE = new Comparator<StiSeriesPoint>(){

        @Override
        public int compare(StiSeriesPoint o1, StiSeriesPoint o2) {
            return Double.compare(o1.value, o2.value);
        }
    };
    private static final Comparator<StiSeriesPoint> COMPARATOR_BY_VALUE_REVERSE = new Comparator<StiSeriesPoint>(){

        @Override
        public int compare(StiSeriesPoint o1, StiSeriesPoint o2) {
            return -1 * Double.compare(o1.value, o2.value);
        }
    };

    public StiSeriesPointCollection() {
    }

    public StiSeriesPointCollection(List<StiSeriesPoint> subList) {
        super(subList);
    }

    public StiSeriesPointCollection(int initialCapacity) {
        super(initialCapacity);
    }

    public static StiSeriesPointCollection create(StiSeries series) {
        StiSeriesPointCollection seriesPoints = new StiSeriesPointCollection();
        for (int i = 0; i < series.getValues().length; ++i) {
            Double value = series.getValues()[i];
            Object argument = series.getArguments()[i];
            seriesPoints.add(new StiSeriesPoint(i, value, argument));
        }
        return seriesPoints;
    }

    public void sortByValues() {
        Collections.sort(this, COMPARATOR_BY_VALUE);
    }

    public void sortByValuesReverse() {
        Collections.sort(this, COMPARATOR_BY_VALUE_REVERSE);
    }

    public void sortByIndex() {
        Collections.sort(this, COMPARATOR_BY_INDEX);
    }

    public StiSeriesPointCollection subList(int fromIndex, int toIndex) {
        return new StiSeriesPointCollection(super.subList(fromIndex, toIndex));
    }

    public void setValuesAndArgumentsInSeries(StiSeries series) {
        Double[] values = new Double[this.size()];
        Object[] arguments = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            StiSeriesPoint seriesPoint = (StiSeriesPoint)this.get(i);
            values[i] = seriesPoint.value;
            arguments[i] = seriesPoint.argument;
        }
        series.setValues(values);
        series.setArguments(arguments);
    }

    public double getSummValue(int beginIndex, int endIndex) {
        double result = 0.0;
        for (int i = beginIndex; i < endIndex; ++i) {
            result += ((StiSeriesPoint)this.get((int)i)).value;
        }
        return result;
    }
}

