/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.enums.StiChartSeriesOrientation;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class StiAreaCoreXF
implements Cloneable,
IStiApplyStyle {
    private IStiArea area;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void applyStyle(IStiChartStyle style) {
        if (this.getArea().getAllowApplyStyle()) {
            StiBrush tempVar = style.getCore().getChartAreaBrush();
            this.getArea().setBrush((StiBrush)(tempVar instanceof StiBrush ? tempVar : null));
            this.getArea().setBorderColor(style.getCore().getChartAreaBorderColor());
            this.getArea().setShowShadow(style.getCore().getChartAreaShowShadow());
        }
    }

    public abstract StiCellGeom Render(StiContext var1, StiRectangle var2);

    protected abstract void PrepareInfo(StiRectangle var1);

    public final boolean CheckInLabelsTypes(Class typeForCheck) {
        Class[] types;
        for (Class type : types = this.area.GetSeriesLabelsTypes()) {
            if (!type.toString().equals(typeForCheck.toString())) continue;
            return true;
        }
        return false;
    }

    public final ArrayList<IStiSeries> GetSeries() {
        Class[] types;
        Hashtable<Class, Class> cachedSeriesTypes = new Hashtable<Class, Class>();
        for (Class type : types = this.getArea().GetSeriesTypes()) {
            cachedSeriesTypes.put(type, type);
        }
        ArrayList<IStiSeries> newSeries = new ArrayList<IStiSeries>();
        for (IStiSeries series : this.getArea().getChart().getSeries()) {
            if (cachedSeriesTypes.get(series.getClass()) == null) continue;
            newSeries.add(series);
        }
        return newSeries;
    }

    public final boolean IsAcceptableSeries(Class seriesType) {
        Class[] types;
        for (Class type : types = this.getArea().GetSeriesTypes()) {
            if (type != seriesType) continue;
            return true;
        }
        return false;
    }

    public final boolean IsAcceptableSeriesLabels(Class seriesLabelsType) {
        Class[] types;
        for (Class type : types = this.getArea().GetSeriesLabelsTypes()) {
            if (type != seriesLabelsType) continue;
            return true;
        }
        return false;
    }

    public final IStiArea getArea() {
        return this.area;
    }

    public final void setArea(IStiArea value) {
        this.area = value;
    }

    public abstract String getLocalizedName();

    public StiChartSeriesOrientation getSeriesOrientation() {
        return StiChartSeriesOrientation.Vertical;
    }

    public abstract int getPosition();

    public StiAreaCoreXF(IStiArea area) {
        this.area = area;
    }
}

