/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.legend;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.chart.core.area.doughnut.StiDoughnutAreaCoreXF;
import com.stimulsoft.report.chart.core.legend.StiLegendItemCoreXF;
import com.stimulsoft.report.chart.enums.StiLegendDirection;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.legend.StiLegendGeom;
import com.stimulsoft.report.chart.geoms.legend.StiLegendItemGeom;
import com.stimulsoft.report.chart.geoms.legend.StiLegendTitleGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.areas.doughnut.IStiDoughnutArea;
import com.stimulsoft.report.chart.interfaces.legend.IStiLegend;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPieSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import java.util.ArrayList;

public class StiLegendCoreXF
implements Cloneable,
IStiApplyStyle {
    private IStiLegend legend;

    @Override
    public void applyStyle(IStiChartStyle style) {
        if (this.getLegend().getAllowApplyStyle()) {
            Object tempVar = style.getCore().getLegendBrush().clone();
            this.getLegend().setBrush((StiBrush)(tempVar instanceof StiBrush ? tempVar : null));
            this.getLegend().setLabelsColor(style.getCore().getLegendLabelsColor());
            this.getLegend().setTitleColor(style.getCore().getLegendTitleColor());
            this.getLegend().setBorderColor(style.getCore().getLegendBorderColor());
        }
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final StiCellGeom Render(StiContext context, StiRectangle rect) {
        StiRectangle legendRect;
        StiRefObject realCountItems = new StiRefObject((Object)0);
        ArrayList seriesItems = this.GetLegendItems((StiRefObject<Integer>)realCountItems);
        if (!this.legend.getVisible() || seriesItems.isEmpty()) {
            return null;
        }
        StiSize legendSize = this.GetLegendSize(context);
        StiRectangle legendClientRect = legendRect = new StiRectangle(rect.x, rect.y, legendSize.width, legendSize.height);
        legendClientRect.setLocation(new StiPoint(0.0, 0.0));
        StiLegendTitleGeom titleGeom = null;
        if (!StiValidationUtil.isNullOrEmpty((String)this.legend.getTitle())) {
            StiSize titleSize = this.GetTitleSize(context);
            StiRectangle titleRect = legendRect;
            titleRect.setLocation(new StiPoint(0.0, 0.0));
            titleRect.height = (float)titleSize.height;
            titleGeom = new StiLegendTitleGeom(this.legend, titleRect);
            legendClientRect.y += titleRect.height;
            legendClientRect.height -= titleRect.height;
        }
        StiLegendGeom legendGeom = new StiLegendGeom(this.legend, legendRect, seriesItems);
        if (titleGeom != null) {
            legendGeom.CreateChildGeoms();
            legendGeom.getChildGeoms().add(titleGeom);
            legendGeom.setLegendTitleGeom(titleGeom);
        }
        float scaledHorSpacing = this.legend.getHorSpacing() * context.Options.zoom;
        float scaledVertSpacing = this.legend.getVertSpacing() * context.Options.zoom;
        if (legendRect.width > 0.0 && legendRect.height > 0.0) {
            double startX = 0.0;
            double startY = 0.0;
            StiSize itemSize = this.GetItemSize(context, seriesItems, 0);
            if (this.legend.getDirection() == StiLegendDirection.LeftToRight || this.legend.getDirection() == StiLegendDirection.TopToBottom) {
                startX = (double)scaledHorSpacing + legendClientRect.x;
                startY = (double)scaledVertSpacing + legendClientRect.y;
            } else if (this.legend.getDirection() == StiLegendDirection.RightToLeft) {
                startX = (float)(legendClientRect.getRight() - (double)scaledHorSpacing - itemSize.width);
                startY = (double)scaledVertSpacing + legendClientRect.y;
            } else if (this.legend.getDirection() == StiLegendDirection.BottomToTop) {
                startX = (double)scaledHorSpacing + legendClientRect.x;
                startY = (float)(legendClientRect.getBottom() - (double)scaledVertSpacing - itemSize.height);
            }
            double posX = startX;
            double posY = startY;
            int columnIndex = 0;
            int colorIndex = 0;
            for (StiLegendItemCoreXF seriesItem : seriesItems) {
                itemSize = this.GetItemSize(context, (ArrayList<StiLegendItemCoreXF>)seriesItems, seriesItem);
                StiRectangle itemRect = new StiRectangle(posX, posY, itemSize.width, itemSize.height);
                StiLegendItemGeom itemGeom = new StiLegendItemGeom(this.legend, seriesItem, itemRect, seriesItem.getColorIndex(), (Integer)realCountItems.argvalue);
                legendGeom.CreateChildGeoms();
                legendGeom.getChildGeoms().add(itemGeom);
                ++columnIndex;
                if (this.legend.getDirection() == StiLegendDirection.TopToBottom) {
                    posY += (double)scaledVertSpacing + itemRect.height;
                    if (columnIndex == this.legend.getColumns()) {
                        posY = startY;
                        posX += itemSize.width + (double)scaledHorSpacing;
                        columnIndex = 0;
                    }
                } else if (this.legend.getDirection() == StiLegendDirection.LeftToRight) {
                    posX += (double)scaledHorSpacing + itemRect.width;
                    if (columnIndex == this.legend.getColumns()) {
                        posX = startX;
                        posY += itemSize.height + (double)scaledVertSpacing;
                        columnIndex = 0;
                    }
                } else if (this.legend.getDirection() == StiLegendDirection.RightToLeft) {
                    itemSize = this.GetItemSize(context, seriesItems, colorIndex + 1);
                    posX -= (double)scaledHorSpacing + itemSize.width;
                    if (columnIndex == this.legend.getColumns()) {
                        posX = startX;
                        posY += itemSize.height + (double)scaledVertSpacing;
                        columnIndex = 0;
                    }
                } else if (this.legend.getDirection() == StiLegendDirection.BottomToTop) {
                    posY -= (double)scaledVertSpacing + itemRect.height;
                    if (columnIndex == this.legend.getColumns()) {
                        posY = startY;
                        posX += itemSize.width + (double)scaledHorSpacing;
                        columnIndex = 0;
                    }
                }
                ++colorIndex;
            }
        }
        return legendGeom;
    }

    public final String GetArgumentText(IStiSeries series, int index) {
        if (series.getArguments().length > index && series.getArguments()[index] != null) {
            return series.getArguments()[index].toString();
        }
        return "";
    }

    public final int GetLegendItemColumn(ArrayList<StiLegendItemCoreXF> seriesItems, StiLegendItemCoreXF seriesItem) {
        int seriesIndex = 0;
        int columnIndex = 0;
        for (StiLegendItemCoreXF item : seriesItems) {
            if (item == seriesItem) break;
            if (++seriesIndex < this.legend.getColumns()) continue;
            seriesIndex = 0;
            ++columnIndex;
        }
        if (this.legend.getDirection() == StiLegendDirection.TopToBottom || this.legend.getDirection() == StiLegendDirection.BottomToTop) {
            return columnIndex;
        }
        return seriesIndex;
    }

    public final StiSize GetTitleSize(StiContext context) {
        if (StiValidationUtil.isNullOrEmpty((String)this.legend.getTitle())) {
            return new StiSize(0, 0);
        }
        StiFontGeom newFont = StiFontGeom.ChangeFontSize((StiFont)this.legend.getTitleFont(), (double)(this.legend.getTitleFont().size * (double)context.Options.zoom));
        StiStringFormatGeom sf = context.GetDefaultStringFormat();
        sf.setFormatFlags(StiEnumSet.of((Enum)StiStringFormatFlags.None));
        StiSize size = context.MeasureString(this.legend.getTitle(), newFont, 1000000000, sf);
        size.width += 1.0;
        return size;
    }

    public final StiSize GetItemSize(StiContext context, ArrayList seriesItems, int seriesIndex) {
        if (seriesIndex >= 0 && seriesIndex < seriesItems.size()) {
            StiLegendItemCoreXF seriesItem = seriesItems.get(seriesIndex) instanceof StiLegendItemCoreXF ? seriesItems.get(seriesIndex) : null;
            return this.GetItemSize(context, (ArrayList<StiLegendItemCoreXF>)seriesItems, seriesItem);
        }
        return new StiSize();
    }

    public final StiSize GetItemSize(StiContext context, ArrayList<StiLegendItemCoreXF> seriesItems, StiLegendItemCoreXF seriesItem) {
        double itemWidth = 0.0;
        double itemHeight = 0.0;
        int seriesItemColumn = this.GetLegendItemColumn(seriesItems, seriesItem);
        StiFontGeom newFont = StiFontGeom.ChangeFontSize((StiFont)this.legend.getFont(), (double)(this.legend.getFont().size * (double)context.Options.zoom));
        for (StiLegendItemCoreXF item : seriesItems) {
            if (this.GetLegendItemColumn(seriesItems, item) != seriesItemColumn) continue;
            StiSize sizeStr = context.MeasureString(item.getText(), newFont);
            itemWidth = (float)Math.max(sizeStr.width, itemWidth);
            itemHeight = (float)Math.max(sizeStr.height, itemHeight);
        }
        if (this.legend.getMarkerVisible()) {
            itemWidth = Math.max(this.legend.getMarkerSize().width * (double)context.Options.zoom, itemWidth) + this.legend.getMarkerSize().width * (double)context.Options.zoom;
            itemHeight = Math.max(this.legend.getMarkerSize().height * (double)context.Options.zoom, itemHeight);
        }
        return new StiSize(itemWidth, itemHeight);
    }

    public final StiSize GetItemsSize(StiContext context, ArrayList<StiLegendItemCoreXF> seriesItems) {
        float scaledHorSpacing = this.legend.getHorSpacing() * context.Options.zoom;
        float itemWidth = 0.0f;
        float itemHeight = 0.0f;
        int columnsCount = this.legend.getColumns();
        if (this.legend.getDirection() == StiLegendDirection.TopToBottom || this.legend.getDirection() == StiLegendDirection.BottomToTop) {
            columnsCount = (seriesItems.size() - 1) / this.legend.getColumns() + 1;
        }
        block0: for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
            for (StiLegendItemCoreXF item : seriesItems) {
                if (this.GetLegendItemColumn(seriesItems, item) != columnIndex) continue;
                StiSize itemSize = this.GetItemSize(context, seriesItems, item);
                itemWidth = (float)((double)itemWidth + (itemSize.width + (double)scaledHorSpacing));
                itemHeight = (float)Math.max(itemSize.height, (double)itemHeight);
                continue block0;
            }
        }
        return new StiSize((double)itemWidth, (double)itemHeight);
    }

    public final StiSize GetSeriesSize(StiContext context) {
        float scaledHorSpacing = this.legend.getHorSpacing() * context.Options.zoom;
        float scaledVertSpacing = this.legend.getVertSpacing() * context.Options.zoom;
        ArrayList<IStiSeries> seriesCollection = this.legend.getChart().getArea().getCore().GetSeries();
        StiRefObject realItemsCount = new StiRefObject((Object)0);
        ArrayList seriesItems = this.GetLegendItems((StiRefObject<Integer>)realItemsCount);
        StiSize itemSize = this.GetItemsSize(context, seriesItems);
        float width = 0.0f;
        float height = 0.0f;
        switch (this.legend.getDirection()) {
            case TopToBottom: 
            case BottomToTop: {
                width = (float)(itemSize.width + (double)scaledHorSpacing);
                int columnsCount = this.legend.getColumns();
                if (columnsCount > (Integer)realItemsCount.argvalue) {
                    columnsCount = (Integer)realItemsCount.argvalue;
                }
                height = (float)((itemSize.height + (double)scaledVertSpacing) * (double)columnsCount + (double)scaledVertSpacing);
                break;
            }
            case LeftToRight: 
            case RightToLeft: {
                int count = (Integer)realItemsCount.argvalue / this.legend.getColumns();
                if (count * this.legend.getColumns() < (Integer)realItemsCount.argvalue) {
                    ++count;
                }
                width = (float)(itemSize.width + (double)scaledHorSpacing);
                height = (float)((itemSize.height + (double)scaledVertSpacing) * (double)count + (double)scaledVertSpacing);
            }
        }
        return new StiSize((double)width, (double)height);
    }

    public final StiSize GetLegendSize(StiContext context) {
        StiSize titleSize = this.GetTitleSize(context);
        StiSize seriesSize = this.GetSeriesSize(context);
        StiSize size = new StiSize(Math.max(titleSize.width, seriesSize.width), titleSize.height + seriesSize.height);
        float width = 0.0f;
        float height = 0.0f;
        if (this.legend.getChart() != null) {
            width = (float)this.legend.getChart().ConvertToHInches(this.legend.getSize().width * (double)context.Options.zoom);
            height = (float)this.legend.getChart().ConvertToHInches(this.legend.getSize().height * (double)context.Options.zoom);
        } else {
            width = (float)(this.legend.getSize().width * (double)context.Options.zoom);
            height = (float)(this.legend.getSize().height * (double)context.Options.zoom);
        }
        if (width != 0.0f) {
            size.width = width;
        }
        if (height != 0.0f) {
            size.height = height;
        }
        size.width = (int)Math.round(size.width);
        size.height = (int)Math.round(size.height);
        return size;
    }

    public final ArrayList GetLegendItems(StiRefObject<Integer> count) {
        count.argvalue = 0;
        ArrayList<IStiSeries> seriesCollection = this.legend.getChart().getArea().getCore().GetSeries();
        IStiArea tempVar = this.legend.getChart().getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        ArrayList<StiLegendItemCoreXF> list = new ArrayList<StiLegendItemCoreXF>();
        if (this.legend.getChart().getArea().getColorEach()) {
            int valuesCount = 0;
            int colorCount = 0;
            for (IStiSeries series : seriesCollection) {
                colorCount += series.getValues().length;
                valuesCount = Math.max(series.getValues().length, valuesCount);
            }
            int colorIndex = 0;
            for (int pointIndex = 0; pointIndex < valuesCount; ++pointIndex) {
                for (IStiSeries series : seriesCollection) {
                    if (!this.legend.getChart().getArea().getCore().IsAcceptableSeries(series.getClass())) continue;
                    if (series.getShowInLegend() && series.getValues() != null) {
                        boolean revert;
                        boolean bl = revert = axisArea != null ? axisArea.getReverseHor() : false;
                        if (pointIndex < series.getValues().length) {
                            Double value;
                            Double d = value = revert ? series.getValues()[series.getValues().length - pointIndex - 1] : series.getValues()[pointIndex];
                            if (!(series instanceof IStiPieSeries) || value == null || value != 0.0) {
                                list.add(new StiLegendItemCoreXF(this.legend.getChart().getSeriesLabels().getCore().GetLabelText(series, value, this.GetArgumentText(series, pointIndex), series.getCore().GetTag(pointIndex), series.getCoreTitle(), true), series, pointIndex, colorIndex));
                            }
                        }
                    }
                    StiRefObject<Integer> revert = count;
                    Object object = revert.argvalue;
                    revert.argvalue = (Integer)revert.argvalue + 1;
                    Integer n = revert.argvalue;
                    ++colorIndex;
                }
            }
        } else if (this.legend.getChart().getArea() instanceof IStiDoughnutArea) {
            for (IStiSeries series : seriesCollection) {
                if (!this.legend.getChart().getArea().getCore().IsAcceptableSeries(series.getClass()) || series.getValues().length != ((StiDoughnutAreaCoreXF)this.legend.getChart().getArea().getCore()).ValuesCount) continue;
                int index = 0;
                for (Object obj : series.getArguments()) {
                    if (obj != null) {
                        list.add(new StiLegendItemCoreXF(obj.toString(), series, index, index));
                    }
                    StiRefObject<Integer> stiRefObject = count;
                    Object object = stiRefObject.argvalue;
                    stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                    Integer n = stiRefObject.argvalue;
                    ++index;
                }
                break;
            }
        } else {
            for (IStiSeries series : seriesCollection) {
                if (!this.legend.getChart().getArea().getCore().IsAcceptableSeries(series.getClass()) || !series.getShowInLegend() || this.legend.getHideSeriesWithEmptyTitle() && StiValidationUtil.isNullOrEmpty((String)series.getCoreTitle()) && !this.legend.getChart().getIsDesigning()) continue;
                list.add(new StiLegendItemCoreXF(series.getCoreTitle(), series, -1, 0));
                StiRefObject<Integer> stiRefObject = count;
                Object object = stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                Integer n = stiRefObject.argvalue;
            }
        }
        return list;
    }

    public final IStiLegend getLegend() {
        return this.legend;
    }

    public final void setLegend(IStiLegend value) {
        this.legend = value;
    }

    public StiLegendCoreXF(IStiLegend legend) {
        this.legend = legend;
    }
}

