/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiLabelAnimation;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.marker.StiMarkerGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyleSeries;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiAreaSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiBaseLineSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiSplineAreaSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiSteppedAreaSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import java.util.ArrayList;

public abstract class StiBaseLineSeriesCoreXF
extends StiSeriesCoreXF
implements IStiApplyStyleSeries {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiBaseLineSeries columnSeries = (IStiBaseLineSeries)(tempVar instanceof IStiBaseLineSeries ? tempVar : null);
        if (columnSeries.getAllowApplyStyle()) {
            columnSeries.setLineColor(color);
            if (columnSeries.getMarker() != null) {
                columnSeries.getMarker().setBrush((StiBrush)new StiSolidBrush(StiColorUtils.light((StiColor)color, (int)100)));
                columnSeries.getMarker().setBorderColor(StiColorUtils.dark((StiColor)color, (int)100));
            }
            if (columnSeries.getLineMarker() != null) {
                columnSeries.getLineMarker().setBrush((StiBrush)new StiSolidBrush(StiColorUtils.light((StiColor)color, (int)50)));
                columnSeries.getLineMarker().setBorderColor(StiColorUtils.dark((StiColor)color, (int)150));
            }
        }
    }

    protected final StiPoint[] ClipLinePoints(StiContext context, StiAreaGeom geom, StiPoint[] points, StiRefObject<Integer> startIndex, StiRefObject<Integer> endIndex) {
        int newCount;
        if (((IStiAxisArea)this.getSeries().getChart().getArea()).getXAxis().getRange().getAuto()) {
            startIndex.argvalue = 0;
            endIndex.argvalue = ((StiRefObject<Integer>)points).length;
            return points;
        }
        startIndex.argvalue = -1;
        endIndex.argvalue = -1;
        StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
        clipRect.x = 0.0;
        clipRect.y = 0.0;
        int pointIndex = 0;
        for (StiRefObject<Integer> point : points) {
            if (point != null) {
                StiPoint valuePoint = point.getValue();
                valuePoint.x += geom.getClientRectangle().x;
                valuePoint.y += geom.getClientRectangle().y;
                if (clipRect.x <= valuePoint.x && valuePoint.x < clipRect.getRight() && (Integer)startIndex.argvalue == -1) {
                    startIndex.argvalue = pointIndex;
                }
                if (!(clipRect.x <= valuePoint.x && valuePoint.x < clipRect.getRight() || (Integer)startIndex.argvalue == -1)) {
                    endIndex.argvalue = pointIndex;
                    break;
                }
            }
            ++pointIndex;
        }
        if ((Integer)endIndex.argvalue == -1) {
            endIndex.argvalue = ((StiRefObject<Integer>)points).length - 1;
        }
        StiRefObject<Integer> arr$ = startIndex;
        Object len$ = arr$.argvalue;
        arr$.argvalue = (Integer)arr$.argvalue - 1;
        Integer i$ = arr$.argvalue;
        arr$ = endIndex;
        len$ = arr$.argvalue;
        arr$.argvalue = (Integer)arr$.argvalue + 1;
        i$ = arr$.argvalue;
        if ((Integer)startIndex.argvalue < 0) {
            startIndex.argvalue = 0;
        }
        if ((Integer)endIndex.argvalue >= ((StiRefObject<Integer>)points).length) {
            endIndex.argvalue = ((StiRefObject<Integer>)points).length - 1;
        }
        if ((newCount = (Integer)endIndex.argvalue - (Integer)startIndex.argvalue + 1) == ((StiRefObject<Integer>)points).length) {
            return points;
        }
        StiPoint[] newPoints = new StiPoint[newCount];
        for (int i = 0; i < newCount; ++i) {
            newPoints[i] = points[i].clone();
        }
        return newPoints;
    }

    protected void RenderMarkers(StiContext context, StiAreaGeom geom, StiPoint[] points) {
        IStiArea tempVar = geom.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        IStiSeries tempVar2 = this.getSeries();
        IStiBaseLineSeries lineSeries = (IStiBaseLineSeries)(tempVar2 instanceof IStiBaseLineSeries ? tempVar2 : null);
        if (points.length == 0) {
            return;
        }
        if (lineSeries.getMarker() != null && lineSeries.getMarker().getVisible()) {
            int index = 0;
            for (StiPoint point : points) {
                if (point != null) {
                    StiMarkerGeom markerGeom;
                    Double value;
                    Double d = value = axisArea.getReverseHor() ? lineSeries.getValues()[lineSeries.getValues().length - index - 1] : lineSeries.getValues()[index];
                    if (value == null && lineSeries.getShowNulls()) {
                        value = 0.0;
                    }
                    StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
                    clipRect.x = 0.0;
                    clipRect.y = 0.0;
                    clipRect.inflate(10, 10);
                    StiPoint valuePoint = point.getValue();
                    valuePoint.x += geom.getClientRectangle().x;
                    valuePoint.y += geom.getClientRectangle().y;
                    if (clipRect.contains(valuePoint) && (markerGeom = new StiMarkerGeom(this.getSeries(), index, value == null ? 0.0 : value, point.getValue(), lineSeries.getMarker(), lineSeries.getShowShadow(), context.Options.zoom)) != null) {
                        if (lineSeries.getCore().getInteraction() != null) {
                            StiSeriesInteractionData data = new StiSeriesInteractionData();
                            data.Fill(axisArea, lineSeries, index);
                            markerGeom.setInteraction(data);
                        }
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(markerGeom);
                    }
                }
                ++index;
            }
        }
    }

    protected final ArrayList<StiSeriesInteractionData> GetInteractions(StiContext context, StiAreaGeom geom, StiPoint[] points) {
        ArrayList<StiSeriesInteractionData> interactions = new ArrayList<StiSeriesInteractionData>();
        for (int index = 0; index < points.length; ++index) {
            StiSeriesInteractionData data = new StiSeriesInteractionData();
            IStiArea tempVar = geom.getArea();
            data.Fill(tempVar instanceof IStiAxisArea ? tempVar : null, this.getSeries(), index);
            data.setPoint(points[index]);
            interactions.add(data);
        }
        return interactions;
    }

    protected void RenderLines(StiContext context, StiAreaGeom geom, StiPoint[] pointsFrom, StiPoint[] points) {
    }

    protected void RenderAreas(StiContext context, StiAreaGeom geom, StiPoint[] pointsFrom, StiPoint[] points) {
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        IStiArea area = geom.getArea();
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        boolean isAnimationChangingValues = ((StiChart)this.getSeries().getChart()).isAnimationChangingValues();
        IStiAxisArea axisArea = (IStiAxisArea)(area instanceof IStiAxisArea ? area : null);
        rect.width += (double)0.001f;
        double posY = 0.0;
        ArrayList<StiPoint[]> pointLists = new ArrayList<StiPoint[]>();
        ArrayList<StiPoint[]> pointFromLists = isAnimationChangingValues ? new ArrayList<StiPoint[]>() : null;
        for (int seriesIndex = 0; seriesIndex < series.length; ++seriesIndex) {
            IStiBaseLineSeries currentSeries = (IStiBaseLineSeries)(series[seriesIndex] instanceof IStiBaseLineSeries ? series[seriesIndex] : null);
            int pointsCount = currentSeries.getValues().length;
            StiPoint[] points = new StiPoint[pointsCount];
            StiPoint[] pointsFrom = isAnimationChangingValues ? new StiPoint[pointsCount] : null;
            for (int pointIndex = 0; pointIndex < pointsCount; ++pointIndex) {
                double posX = axisArea.getXAxis().getCore().GetStartFromZero() ? axisArea.getXAxis().getInfo().StripPositions[pointIndex + 1] : axisArea.getXAxis().getInfo().StripPositions[pointIndex];
                Double value = axisArea.getReverseHor() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex];
                points[pointIndex] = this.GetPointValue(value, currentSeries, axisArea, posX);
                if (!isAnimationChangingValues) continue;
                Double valueFrom = 0.0;
                if (currentSeries.getValuesStart().length > pointIndex) {
                    valueFrom = axisArea.getReverseHor() ? currentSeries.getValuesStart()[currentSeries.getValuesStart().length - pointIndex - 1] : currentSeries.getValuesStart()[pointIndex];
                }
                pointsFrom[pointIndex] = this.GetPointValue(valueFrom, currentSeries, axisArea, posX);
            }
            if (points.length > 0) {
                int startIndex = 0;
                int endIndex = 0;
                StiRefObject tempRef_startIndex = new StiRefObject((Object)startIndex);
                StiRefObject tempRef_endIndex = new StiRefObject((Object)endIndex);
                StiPoint[] newPointList = this.ClipLinePoints(context, geom, points, (StiRefObject<Integer>)tempRef_startIndex, (StiRefObject<Integer>)tempRef_endIndex);
                startIndex = (Integer)tempRef_startIndex.argvalue;
                endIndex = (Integer)tempRef_endIndex.argvalue;
                StiPoint[] newPointFromList = isAnimationChangingValues ? this.ClipLinePoints(context, geom, pointsFrom, (StiRefObject<Integer>)tempRef_startIndex, (StiRefObject<Integer>)tempRef_endIndex) : null;
                ((StiBaseLineSeriesCoreXF)currentSeries.getCore()).RenderAreas(context, geom, newPointFromList, newPointList);
                if (!this.IsTopmostLine(currentSeries)) {
                    ((StiBaseLineSeriesCoreXF)currentSeries.getCore()).RenderLines(context, geom, newPointFromList, newPointList);
                }
            }
            pointLists.add(points);
            if (!isAnimationChangingValues) continue;
            pointFromLists.add(pointsFrom);
        }
        int index = 0;
        for (StiPoint[] pointList : pointLists) {
            IStiAxisSeriesLabels labels;
            IStiTrendLine trendLine;
            int startIndex = 0;
            int endIndex = 0;
            StiRefObject tempRef_startIndex2 = new StiRefObject((Object)startIndex);
            StiRefObject tempRef_endIndex2 = new StiRefObject((Object)endIndex);
            StiPoint[] newPointList = this.ClipLinePoints(context, geom, pointList, (StiRefObject<Integer>)tempRef_startIndex2, (StiRefObject<Integer>)tempRef_endIndex2);
            StiPoint[] newPointFromList = isAnimationChangingValues ? this.ClipLinePoints(context, geom, (StiPoint[])pointFromLists.get(index), (StiRefObject<Integer>)tempRef_startIndex2, (StiRefObject<Integer>)tempRef_endIndex2) : null;
            startIndex = (Integer)tempRef_startIndex2.argvalue;
            endIndex = (Integer)tempRef_endIndex2.argvalue;
            IStiBaseLineSeries currentSeries = (IStiBaseLineSeries)(series[index] instanceof IStiBaseLineSeries ? series[index] : null);
            if (this.IsTopmostLine(series[index])) {
                ((StiBaseLineSeriesCoreXF)currentSeries.getCore()).RenderLines(context, geom, newPointFromList, newPointList);
            }
            if ((trendLine = ((StiSeries)((Object)currentSeries)).getTrendLine()) != null) {
                trendLine.getCore().RenderTrendLine(geom, newPointList, axisArea.getAxisCore().GetDividerY());
            }
            if ((labels = currentSeries.getCore().GetSeriesLabels()) != null && labels.getVisible()) {
                for (int pointIndex = startIndex; pointIndex <= endIndex; ++pointIndex) {
                    StiSeriesLabelsGeom seriesLabelsGeom;
                    if (currentSeries.getValues().length <= pointIndex) continue;
                    Double value = currentSeries.getValues()[pointIndex];
                    if (value == null && currentSeries.getShowNulls()) {
                        value = 0.0;
                    }
                    Double seriesValue = value;
                    if (axisArea.getReverseVert() && value != null) {
                        seriesValue = -seriesValue.doubleValue();
                    }
                    posY = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? axisArea.getAxisCore().GetDividerY() : axisArea.getAxisCore().GetDividerRightY();
                    StiPoint endPoint = pointList[pointIndex];
                    if (endPoint == null) continue;
                    Double valueFrom = 0.0;
                    if (currentSeries.getValuesStart() != null && currentSeries.getValuesStart().length > pointIndex) {
                        valueFrom = currentSeries.getValuesStart()[pointIndex];
                    }
                    StiPoint startPoint = new StiPoint(endPoint.getValue().x, posY);
                    StiLabelAnimation animation = null;
                    if (isAnimationChangingValues) {
                        StiPoint endPointFrom = ((StiPoint[])pointFromLists.get(index)).length > pointIndex ? ((StiPoint[])pointFromLists.get(index))[pointIndex] : null;
                        animation = new StiLabelAnimation(valueFrom, value, endPointFrom != null ? endPointFrom : StiPoint.getEmpty(), endPoint != null ? endPoint : StiPoint.getEmpty(), StiChartHelper.GlobalBeginTimeElement, Integer.valueOf(0));
                    }
                    if (labels.getStep() != 0 && pointIndex % labels.getStep() != 0 || (seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, this.CorrectPoint(endPoint.getValue(), rect, currentSeries.getLabelsOffset() * context.Options.zoom), this.CorrectPoint(startPoint, rect, currentSeries.getLabelsOffset() * context.Options.zoom), pointIndex, seriesValue, value, axisArea.getAxisCore().GetArgumentLabel((StiStripLineXF)axisArea.getXAxis().getInfo().StripLines.get(pointIndex), currentSeries), this.GetTag(pointIndex), 0, 1, rect, (StiAnimation)animation)) == null) continue;
                    geom.CreateChildGeoms();
                    geom.getChildGeoms().add(seriesLabelsGeom);
                    seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect(labels, geom, seriesLabelsGeom.getClientRectangle()));
                }
            }
            ++index;
        }
        if (geom.getArea().getChart().getSeriesLabels().getPreventIntersection()) {
            this.CheckIntersectionLabels(geom);
        }
    }

    private boolean IsTopmostLine(IStiSeries series) {
        if (series instanceof IStiSplineAreaSeries) {
            return ((IStiSplineAreaSeries)series).getTopmostLine();
        }
        if (series instanceof IStiSteppedAreaSeries) {
            return ((IStiSteppedAreaSeries)series).getTopmostLine();
        }
        if (series instanceof IStiAreaSeries) {
            return ((IStiAreaSeries)series).getTopmostLine();
        }
        return true;
    }

    protected final StiPoint CorrectPoint(StiPoint point, StiRectangle rect, float correctY) {
        if (point.y + (double)correctY < 0.0) {
            return new StiPoint(point.x, 0.0);
        }
        if (point.y + (double)correctY > rect.height) {
            return new StiPoint(point.x, rect.height);
        }
        return new StiPoint(point.x, point.y + (double)correctY);
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiBaseLineSeries lineSeries = (IStiBaseLineSeries)(tempVar instanceof IStiBaseLineSeries ? tempVar : null);
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return new StiSolidBrush(StiColorUtils.dark((StiColor)lineSeries.getLineColor(), (int)20));
        }
        return brush;
    }

    @Override
    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiBaseLineSeries lineSeries = (IStiBaseLineSeries)(tempVar instanceof IStiBaseLineSeries ? tempVar : null);
        Object color = super.GetSeriesBorderColor(colorIndex, colorCount);
        if (color == null) {
            return lineSeries.getLineColor();
        }
        return color;
    }

    private StiPoint GetPointValue(Double value, IStiBaseLineSeries currentSeries, IStiAxisArea axisArea, double posX) {
        if (value == null && !currentSeries.getShowNulls()) {
            return null;
        }
        if (value == null && currentSeries.getShowNulls()) {
            value = 0.0;
        }
        if (axisArea.getReverseVert() && value != null) {
            value = -value.doubleValue();
        }
        double srY = 0.0;
        srY = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? -(value == null ? 0.0 : value) * (double)((float)axisArea.getYAxis().getInfo().Dpi) + axisArea.getAxisCore().GetDividerY() : -(value == null ? 0.0 : value) * (double)((float)axisArea.getYRightAxis().getInfo().Dpi) + axisArea.getAxisCore().GetDividerRightY();
        return new StiPoint(posX, (double)((float)srY));
    }

    public StiBaseLineSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

