/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.core.series.clusteredColumn.StiSteppedLineSeriesCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiSteppedAreaSeriesGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiSteppedAreaSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiSteppedLineSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;

public class StiSteppedAreaSeriesCoreXF
extends StiSteppedLineSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiSteppedAreaSeries areaSeries = (IStiSteppedAreaSeries)(tempVar instanceof IStiSteppedAreaSeries ? tempVar : null);
        if (areaSeries.getAllowApplyStyle()) {
            areaSeries.setBrush(style.getCore().GetAreaBrush(color));
        }
    }

    @Override
    protected void RenderAreas(StiContext context, StiAreaGeom geom, StiPoint[] pointsFrom, StiPoint[] points) {
        IStiSteppedLineSeries lineSeries;
        IStiSteppedLineSeries iStiSteppedLineSeries = lineSeries = this.getSeries() instanceof IStiSteppedLineSeries ? (IStiSteppedLineSeries)this.getSeries() : null;
        if (points == null || points.length == 0 || points.length == 1 && !lineSeries.getPointAtCenter()) {
            return;
        }
        StiSteppedAreaSeriesGeom seriesGeom = new StiSteppedAreaSeriesGeom(geom, pointsFrom, points, this.getSeries());
        if (seriesGeom != null) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesGeom);
        }
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiSteppedAreaSeries areaSeries = (IStiSteppedAreaSeries)(tempVar instanceof IStiSteppedAreaSeries ? tempVar : null);
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return areaSeries.getBrush();
        }
        return brush;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"SteppedArea");
    }

    public StiSteppedAreaSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

