/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.radar;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.core.series.radar.StiRadarSeriesCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiLineSeriesGeom;
import com.stimulsoft.report.chart.geoms.series.radar.StiRadarAreaSeriesGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarAreaSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import java.util.ArrayList;
import java.util.List;

public class StiRadarAreaSeriesCoreXF
extends StiRadarSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiRadarAreaSeries radarSeries = (IStiRadarAreaSeries)(tempVar instanceof IStiRadarAreaSeries ? tempVar : null);
        if (radarSeries.getAllowApplyStyle()) {
            radarSeries.setBrush(style.getCore().GetAreaBrush(color));
            radarSeries.setLineColor(color);
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"RadarArea");
    }

    @Override
    public void RenderLines(StiContext context, IStiRadarSeries series, List<StiPoint> pointsFrom, ArrayList<StiPoint> points, StiAreaGeom geom) {
        StiPoint[] pointsStartArray = pointsFrom != null ? pointsFrom.toArray(new StiPoint[pointsFrom.size()]) : null;
        StiLineSeriesGeom radarGeom = new StiLineSeriesGeom(geom, pointsStartArray, points.toArray(new StiPoint[points.size()]), series);
        if (geom != null) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(radarGeom);
        }
    }

    @Override
    public void RenderAreas(StiContext context, IStiRadarSeries series, List<StiPoint> pointsFrom, ArrayList<StiPoint> points, StiAreaGeom geom) {
        StiPoint[] pointsStartArray = pointsFrom != null ? pointsFrom.toArray(new StiPoint[pointsFrom.size()]) : null;
        StiRadarAreaSeriesGeom radarGeom = new StiRadarAreaSeriesGeom(series, pointsStartArray, points.toArray(new StiPoint[points.size()]), new StiPoint(geom.getClientRectangle().getWidth() / 2.0, geom.getClientRectangle().getHeight() / 2.0));
        if (geom != null) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(radarGeom);
        }
    }

    public StiRadarAreaSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

