/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.stock;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.financial.StiStockSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.stock.IStiStockArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.stock.IStiStockSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;

public class StiStockSeriesCoreXF
extends StiSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        if (this.getSeries().getAllowApplyStyle()) {
            ((IStiStockSeries)this.getSeries()).setLineColor(color);
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        IStiArea tempVar = geom.getArea();
        IStiStockArea stockArea = (IStiStockArea)(tempVar instanceof IStiStockArea ? tempVar : null);
        double posY = stockArea.getAxisCore().GetDividerY();
        Integer time = StiChartHelper.GlobalBeginTimeElement;
        for (IStiSeries serie : series) {
            IStiStockSeries currentSeries = (IStiStockSeries)serie;
            Double[] valuesOpen = currentSeries.getValuesOpen();
            Double[] valuesClose = currentSeries.getValuesClose();
            Double[] valuesHigh = currentSeries.getValuesHigh();
            Double[] valuesLow = currentSeries.getValuesLow();
            int valueCount = Math.min(Math.min(valuesOpen.length, valuesClose.length), Math.min(valuesHigh.length, valuesLow.length));
            int argumentCount = currentSeries.getArguments().length;
            int count = Math.min(valueCount, argumentCount);
            for (int index = 0; index < count; ++index) {
                StiRectangle clientRect;
                StiStockSeriesElementGeom stockGeom;
                Double valueOpen = valuesOpen[index];
                Double valueClose = valuesClose[index];
                Double valueHigh = valuesHigh[index];
                Double valueLow = valuesLow[index];
                int argumentIndex = 0;
                for (StiStripLineXF line : stockArea.getXAxis().getInfo().StripLines) {
                    if (currentSeries.getArguments()[index].toString().equals(line.getValueObject().toString())) break;
                    ++argumentIndex;
                }
                double singleX = stockArea.getXAxis().getInfo().Dpi;
                StiColor color = currentSeries.getLineColor();
                if (currentSeries.getAllowApplyColorNegative() && valueOpen < valueClose) {
                    color = currentSeries.getLineColorNegative();
                }
                if (valueOpen == null || valueClose == null || valueHigh == null || valueLow == null) continue;
                double singleY = (float)stockArea.getYAxis().getInfo().Dpi;
                double open = Math.abs(posY - valueOpen * singleY);
                double close = Math.abs(posY - valueClose * singleY);
                double high = Math.abs(posY - valueHigh * singleY);
                double low = Math.abs(posY - valueLow * singleY);
                double positionX = (double)argumentIndex * singleX;
                if (stockArea.getReverseHor()) {
                    double temp = open;
                    open = close;
                    close = temp;
                }
                if ((stockGeom = new StiStockSeriesElementGeom(geom, currentSeries, clientRect = new StiRectangle(positionX - singleX / 3.0, Math.min(high, low), singleX * 2.0 / 3.0, Math.abs(low - high)), open, close, high, low, positionX, argumentIndex - 1, color, time / valueCount * index)) != null && currentSeries.getCore().getInteraction() != null) {
                    StiSeriesInteractionData data = new StiSeriesInteractionData();
                    data.Fill(geom.getArea(), currentSeries, index);
                    stockGeom.setInteraction(data);
                }
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(stockGeom);
            }
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Stock");
    }

    public StiStockSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

