/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.trendLines;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.core.trendLines.StiTrendLineCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.trendLines.StiTrendCurveGeom;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;

public class StiTrendLineExponentialCoreXF
extends StiTrendLineCoreXF {
    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"PropertyMain", (String)"Exponential");
    }

    @Override
    public void RenderTrendLine(StiAreaGeom geom, StiPoint[] points, double posY) {
        if (points.length > 0) {
            double[] valuesX = new double[points.length];
            double[] valuesY = new double[points.length];
            double maxValue = points[0].getValue().x;
            double minValue = points[0].getValue().x;
            for (int pointIndex = 0; pointIndex < points.length; ++pointIndex) {
                valuesX[pointIndex] = points[pointIndex].getValue().x;
                valuesY[pointIndex] = posY - points[pointIndex].getValue().y;
                if (maxValue < points[pointIndex].getValue().x) {
                    maxValue = points[pointIndex].getValue().x;
                }
                if (!(minValue > points[pointIndex].getValue().x)) continue;
                minValue = points[pointIndex].getValue().x;
            }
            int countPoints = points.length;
            float sumX = this.Sum(valuesX);
            float sumX2 = this.SumSqr(valuesX);
            float sumXLnY = this.SumProductionsXLogY(valuesX, valuesY);
            float sumLnY = this.SumLn(valuesY);
            float a2 = ((float)countPoints * sumXLnY - sumX * sumLnY) / ((float)countPoints * sumX2 - sumX * sumX);
            float c = (sumX2 * sumLnY - sumX * sumXLnY) / ((float)countPoints * sumX2 - sumX * sumX);
            float a1 = (float)Math.exp(c);
            StiPoint[] pointTemp = new StiPoint[31];
            for (int index = 0; index < 31; ++index) {
                double x = minValue + (maxValue - minValue) / 30.0 * (double)index;
                float y = a1 * (float)Math.exp((double)a2 * x);
                pointTemp[index] = new StiPoint(x, posY - (double)y);
            }
            StiTrendCurveGeom curve = new StiTrendCurveGeom(pointTemp, this.getTrendLine());
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(curve);
        }
    }

    public StiTrendLineExponentialCoreXF(IStiTrendLine trendLine) {
        super(trendLine);
    }
}

