/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.areas;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaViewGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.gridLines.axis.IStiGridLinesHor;
import com.stimulsoft.report.chart.interfaces.gridLines.axis.IStiGridLinesVert;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import java.util.ArrayList;

public class StiAxisAreaGeom
extends StiAreaGeom {
    private final StiAxisAreaViewGeom view;
    private final float minWidth = 6.0f;

    public final StiAxisAreaViewGeom getView() {
        return this.view;
    }

    private void DrawInterlacingHor(StiContext context, StiRectangle rect) {
        rect.x = 0.0;
        rect.width = this.view.getClientRectangle().width;
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (!axisArea.getInterlacingHor().getVisible()) {
            return;
        }
        ArrayList<Double> positionsTemp = new ArrayList<Double>();
        int count = axisArea.getYAxis().getInfo().StripPositions.length;
        double[] positions = new double[count];
        for (int indexReorder = 0; indexReorder < count; ++indexReorder) {
            positions[count - 1 - indexReorder] = axisArea.getYAxis().getInfo().StripPositions[indexReorder];
        }
        double firstPosition = 0.0;
        boolean first = true;
        int indexTemp = 0;
        for (double pos : positions) {
            ++indexTemp;
            if (first) {
                firstPosition = pos;
                positionsTemp.add(pos);
                first = false;
                continue;
            }
            double step = firstPosition - pos;
            if (step < 6.0 && indexTemp != positions.length) continue;
            firstPosition = pos;
            positionsTemp.add(pos);
        }
        Double[] positionsNew = new Double[positionsTemp.size()];
        positionsNew = positionsTemp.toArray(positionsNew);
        int index = 0;
        int areaIndex = 0;
        if (axisArea.getReverseVert()) {
            areaIndex = 1;
        }
        Double[] arr$ = positionsNew;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StiRectangle stripRect;
            double posY = arr$[i$];
            double posY2 = positionsNew[index + 1];
            if ((areaIndex & 1) > 0 && (stripRect = new StiRectangle(rect.x, posY + rect.y, rect.width, posY - posY2)).getBottom() >= 0.0 && stripRect.y < this.view.getClientRectangle().height) {
                context.FillRectangle((Object)axisArea.getInterlacingHor().getInterlacedBrush(), stripRect.x, stripRect.y, stripRect.width, stripRect.height);
            }
            ++areaIndex;
            if (++index == positionsNew.length - 1) break;
        }
    }

    private void DrawInterlacingVer(StiContext context, StiRectangle rect) {
        rect.y = 0.0;
        rect.height = this.view.getClientRectangle().height;
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (!axisArea.getInterlacingVert().getVisible()) {
            return;
        }
        int index = 0;
        int areaIndex = 0;
        if (axisArea.getReverseHor()) {
            areaIndex = 1;
        }
        ArrayList<Double> positionsTemp = new ArrayList<Double>();
        double[] positions = axisArea.getXAxis().getInfo().StripPositions;
        double firstPosition = 0.0;
        boolean first = true;
        int indexTemp = 0;
        for (double pos : positions) {
            ++indexTemp;
            if (first) {
                firstPosition = pos;
                positionsTemp.add(pos);
                first = false;
                continue;
            }
            double step = pos - firstPosition;
            if (step < 6.0 && indexTemp != positions.length) continue;
            firstPosition = pos;
            positionsTemp.add(pos);
        }
        Double[] positionsNew = new Double[positionsTemp.size()];
        Double[] arr$ = positionsNew = positionsTemp.toArray(positionsNew);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StiRectangle stripRect;
            double posX = arr$[i$];
            double posX2 = positionsNew[index + 1];
            if ((areaIndex & 1) > 0 && (stripRect = new StiRectangle(posX + rect.x, rect.y, posX2 - posX, rect.height)).getRight() >= 0.0 && stripRect.x < this.view.getClientRectangle().width) {
                context.FillRectangle((Object)axisArea.getInterlacingHor().getInterlacedBrush(), stripRect.x, stripRect.y, stripRect.width, stripRect.height);
            }
            ++areaIndex;
            if (++index == positionsNew.length - 1) break;
        }
    }

    private void DrawGridLinesHor(StiContext context, StiRectangle rect, IStiGridLinesHor gridLinesHor, boolean isLeftAxis) {
        rect.x = 0.0;
        rect.width = this.view.getClientRectangle().width;
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        double[] positions = isLeftAxis ? axisArea.getYAxis().getInfo().StripPositions : axisArea.getYRightAxis().getInfo().StripPositions;
        int count = positions.length;
        double[] positionsTemp = new double[count];
        for (int indexTemp = 0; indexTemp < count; ++indexTemp) {
            positionsTemp[count - indexTemp - 1] = positions[indexTemp];
        }
        positions = positionsTemp;
        double firstPosition = positions.length > 0 ? positions[0] : 0.0;
        int index = 0;
        for (double posY : positions) {
            double step = firstPosition - posY;
            if (step < 6.0 && step > 0.0) continue;
            firstPosition = posY;
            float scaledLineWidth = 1.0f;
            if (gridLinesHor.getVisible() && gridLinesHor.getStyle() != StiPenStyle.None) {
                StiPenGeom penGridLine = new StiPenGeom((Object)gridLinesHor.getColor(), scaledLineWidth);
                penGridLine.setPenStyle(gridLinesHor.getStyle());
                double pointY = posY + rect.y;
                if (pointY >= 0.0 && pointY <= this.getClientRectangle().height) {
                    context.DrawLine(penGridLine, rect.x, pointY, rect.getRight(), pointY);
                }
            }
            if (gridLinesHor.getMinorVisible() && gridLinesHor.getMinorStyle() != StiPenStyle.None && index != positions.length - 1) {
                double posY2 = positions[index + 1];
                if (posY - posY2 < 6.0) continue;
                StiPenGeom penMinorGridLine = new StiPenGeom((Object)gridLinesHor.getMinorColor(), scaledLineWidth);
                penMinorGridLine.setPenStyle(gridLinesHor.getMinorStyle());
                int minorCount = gridLinesHor.getMinorCount() == 0 ? axisArea.getYAxis().getTicks().getMinorCount() : gridLinesHor.getMinorCount();
                double posMinorY = posY;
                double minorStep = (posY2 - posY) / (double)(minorCount + 1);
                for (int minorIndex = 1; minorIndex <= minorCount; ++minorIndex) {
                    posMinorY = posY + minorStep * (double)minorIndex;
                    double pointMinorY = posMinorY + rect.y;
                    if (!(pointMinorY >= 0.0) || !(pointMinorY <= this.getClientRectangle().height)) continue;
                    context.DrawLine(penMinorGridLine, rect.x, pointMinorY, rect.getRight(), pointMinorY);
                }
            }
            ++index;
        }
    }

    private void DrawGridLinesVer(StiContext context, StiRectangle rect, IStiGridLinesVert gridLinesVert, boolean isBottomAxis) {
        rect.y = 0.0;
        rect.height = this.view.getClientRectangle().height;
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        double[] positions = isBottomAxis ? axisArea.getXAxis().getInfo().StripPositions : axisArea.getXTopAxis().getInfo().StripPositions;
        double firstPosition = 0.0;
        int index = 0;
        for (double posX : positions) {
            double step = posX - firstPosition;
            if (step < 6.0 && step > 0.0) continue;
            firstPosition = posX;
            float scaledLineWidth = 1.0f;
            if (gridLinesVert.getVisible() && gridLinesVert.getStyle() != StiPenStyle.None) {
                StiPenGeom penGridLine = new StiPenGeom((Object)gridLinesVert.getColor(), scaledLineWidth);
                penGridLine.setPenStyle(gridLinesVert.getStyle());
                double pointX = posX + rect.x;
                if (pointX >= 0.0 && pointX <= this.getClientRectangle().width) {
                    context.DrawLine(penGridLine, pointX, rect.y, pointX, rect.getBottom());
                }
            }
            if (gridLinesVert.getMinorVisible() && gridLinesVert.getMinorStyle() != StiPenStyle.None && index != positions.length - 1) {
                double posX2 = positions[index + 1];
                if (posX2 - posX < 6.0) continue;
                StiPenGeom penMinorGridLine = new StiPenGeom((Object)gridLinesVert.getMinorColor(), scaledLineWidth);
                penMinorGridLine.setPenStyle(gridLinesVert.getMinorStyle());
                int minorCount = gridLinesVert.getMinorCount() == 0 ? axisArea.getYAxis().getTicks().getMinorCount() : gridLinesVert.getMinorCount();
                double posMinorX = posX;
                double minorStep = (posX2 - posX) / (double)((float)minorCount + 1.0f);
                for (int minorIndex = 1; minorIndex <= minorCount; ++minorIndex) {
                    posMinorX = posX + minorStep * (double)minorIndex;
                    double pointMinorX = posMinorX + rect.x;
                    if (!(pointMinorX >= 0.0) || !(pointMinorX <= this.getClientRectangle().width)) continue;
                    context.DrawLine(penMinorGridLine, pointMinorX, rect.y, pointMinorX, rect.getBottom());
                }
            }
            ++index;
        }
    }

    @Override
    protected boolean AllowChildDrawing(StiCellGeom cellGeom) {
        return cellGeom != null && this.IsChildVisibleInView(cellGeom);
    }

    public final boolean IsChildVisibleInView(StiCellGeom cellGeom) {
        StiRectangle clipRect = this.getView().getClientRectangle();
        clipRect.x = 0.0;
        clipRect.y = 0.0;
        StiRectangle cellRect = cellGeom.getClientRectangle();
        cellRect.x -= (double)((float)((StiAxisAreaCoreXF)this.getArea().getCore()).getScrollDistanceX());
        cellRect.y -= (double)((float)((StiAxisAreaCoreXF)this.getArea().getCore()).getScrollDistanceY());
        return cellGeom != null && clipRect.intersectsWith(cellRect) != false;
    }

    @Override
    public void Draw(StiContext context) {
        super.Draw(context);
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        StiRectangle rect = this.getClientRectangle();
        if (rect.isEmpty().booleanValue()) {
            return;
        }
        ArrayList<IStiSeries> seriesCollection = axisArea.getAxisCore().GetSeries();
        if (seriesCollection.size() > 0) {
            this.DrawInterlacingHor(context, rect);
            this.DrawInterlacingVer(context, rect);
        }
        if (seriesCollection.size() > 0) {
            this.DrawGridLinesHor(context, rect, axisArea.getGridLinesHor(), true);
            this.DrawGridLinesHor(context, rect, axisArea.getGridLinesHorRight(), false);
            this.DrawGridLinesVer(context, rect, axisArea.getGridLinesVert(), true);
        }
    }

    public StiAxisAreaGeom(StiAxisAreaViewGeom view, IStiArea area, StiRectangle clientRectangle) {
        super(area, clientRectangle);
        this.view = view;
    }
}

