/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.axis.scrollBars;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiXAxis;

public class StiHorzScrollBarGeom
extends StiCellGeom {
    private final IStiXAxis axis;

    @Override
    public void InvokeMouseDown(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        StiAreaCoreXF tempVar = this.getAxis().getArea().getCore();
        StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar instanceof StiAxisAreaCoreXF ? tempVar : null);
        axisCore.setBlockScrollValueX(true);
        double buttonSize = this.getClientRectangle().height;
        double mousePointX = options.getMousePoint().x - buttonSize;
        double width = this.getClientRectangle().width - buttonSize * 2.0;
        axisCore.setScrollValueX(mousePointX / width * axisCore.getScrollRangeX());
        if (axisCore.getScrollValueX() < 0.0) {
            axisCore.setScrollValueX(0.0);
        }
        if (axisCore.getScrollValueX() >= axisCore.getScrollRangeX() - axisCore.getScrollViewX()) {
            axisCore.setScrollValueX(axisCore.getScrollRangeX() - axisCore.getScrollViewX());
        }
        options.setUpdateContext(true);
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        StiPenGeom penLine = new StiPenGeom((Object)this.getAxis().getLineColor());
        context.DrawRectangle(penLine, rect.x, rect.y, rect.width, rect.height);
    }

    public final IStiXAxis getAxis() {
        return this.axis;
    }

    public StiHorzScrollBarGeom(IStiXAxis axis, StiRectangle clientRectangle) {
        super(clientRectangle);
        this.axis = axis;
    }
}

