/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.legend;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.enums.StiShadowSides;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.legend.StiLegendTitleGeom;
import com.stimulsoft.report.chart.interfaces.legend.IStiLegend;
import java.util.ArrayList;

public class StiLegendGeom
extends StiCellGeom {
    private final IStiLegend legend;
    private final ArrayList seriesItems;
    private StiLegendTitleGeom legendTitleGeom;

    public final IStiLegend getLegend() {
        return this.legend;
    }

    public final ArrayList getSeriesItems() {
        return this.seriesItems;
    }

    public final StiLegendTitleGeom getLegendTitleGeom() {
        return this.legendTitleGeom;
    }

    public final void setLegendTitleGeom(StiLegendTitleGeom value) {
        this.legendTitleGeom = value;
    }

    @Override
    public void Draw(StiContext context) {
        if (!this.legend.getVisible() || this.seriesItems.isEmpty()) {
            return;
        }
        StiRectangle rect = this.getClientRectangle();
        if (this.getLegendTitleGeom() != null) {
            rect.y += this.getLegendTitleGeom().getClientRectangle().height;
            rect.height -= this.getLegendTitleGeom().getClientRectangle().height;
        }
        if (rect.width > 0.0 && rect.height > 0.0) {
            if (this.legend.getShowShadow()) {
                if (((StiChart)this.getLegend().getChart()).isAnimation) {
                    StiOpacityAnimation animation = new StiOpacityAnimation(Integer.valueOf(0), Integer.valueOf(0));
                    context.DrawShadowRect(rect, 6, (StiAnimation)animation);
                } else {
                    context.drawCachedShadow(rect, new StiEnumSet((Enum)StiShadowSides.All), context.Options.isPrinting);
                }
            }
            context.FillRectangle((Object)this.legend.getBrush(), rect.x, rect.y, rect.width, rect.height);
            StiPenGeom pen = new StiPenGeom((Object)this.legend.getBorderColor());
            context.DrawRectangle(pen, rect.x, rect.y, rect.width, rect.height);
        }
    }

    public StiLegendGeom(IStiLegend legend, StiRectangle clientRectangle, ArrayList seriesItems) {
        super(clientRectangle);
        this.legend = legend;
        this.seriesItems = seriesItems;
    }
}

