/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.marker;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiInteractionDataGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.core.marker.StiMarkerCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.interfaces.IStiSeriesElement;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.marker.IStiMarker;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredBar.IStiClusteredBarSeries;
import com.stimulsoft.report.chart.interfaces.series.fullStackedBar.IStiFullStackedBarSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedBar.IStiStackedBarSeries;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;

public class StiMarkerGeom
extends StiCellGeom
implements IStiSeriesElement {
    private StiSeriesInteractionData interaction;
    private final int index;
    private final StiPoint point;
    private final IStiMarker marker;
    private final double value;
    private final boolean showShadow;
    private final IStiSeries series;
    private String elementIndex;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (!this.getIsMouseOver()) {
            this.setIsMouseOver(true);
            options.setUpdateContext(true);
        }
        int valueIndex = this.GetValueIndex();
        options.setInteractionToolTip(this.GetToolTip(valueIndex));
        options.setInteractionHyperlink(this.GetHyperlink(valueIndex));
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (this.getIsMouseOver()) {
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeClick(StiInteractionOptions options) {
        int valueIndex = this.GetValueIndex();
        if (this.getSeries().getHyperlinks() != null && valueIndex < this.getSeries().getHyperlinks().length) {
            options.setInteractionHyperlink(this.series.getHyperlinks()[valueIndex]);
        }
        if (this.getSeries().getInteraction().getDrillDownEnabled()) {
            options.setSeriesInteractionData(this.getInteraction());
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
        }
    }

    private int GetValueIndex() {
        int valueIndex = this.getIndex();
        if (this.getSeries() instanceof IStiClusteredBarSeries || this.getSeries() instanceof IStiStackedBarSeries || this.getSeries() instanceof IStiFullStackedBarSeries) {
            if (this.getSeries().getChart().getArea() instanceof IStiAxisArea && !((IStiAxisArea)this.series.getChart().getArea()).getReverseVert()) {
                valueIndex = this.getSeries().getValues().length - valueIndex - 1;
            }
        } else if (this.getSeries().getChart().getArea() instanceof IStiAxisArea && ((IStiAxisArea)this.series.getChart().getArea()).getReverseHor()) {
            valueIndex = this.getSeries().getValues().length - valueIndex - 1;
        }
        return valueIndex;
    }

    private String GetHyperlink(int valueIndex) {
        if (this.getSeries().getHyperlinks() != null && valueIndex < this.getSeries().getHyperlinks().length) {
            return this.series.getHyperlinks()[valueIndex];
        }
        return null;
    }

    public String GetToolTip() {
        return this.GetToolTip(this.GetValueIndex());
    }

    private String GetToolTip(int valueIndex) {
        if (this.getSeries().getToolTips() != null && valueIndex < this.getSeries().getToolTips().length) {
            return this.series.getToolTips()[valueIndex];
        }
        return null;
    }

    public boolean getAllowMouseOver() {
        int index = this.GetValueIndex();
        return this.GetHyperlink(this.GetValueIndex()) != null || this.getSeries().getToolTips() != null && index < this.getSeries().getToolTips().length || this.getSeries().getInteraction().getDrillDownEnabled() && this.getSeries().getInteraction().getAllowSeriesElements();
    }

    public boolean getIsMouseOver() {
        if (this.getSeries() == null) {
            return false;
        }
        return this.getSeries().getCore().GetIsMouseOverSeriesElement(this.getIndex());
    }

    public void setIsMouseOver(boolean value) {
        if (this.getSeries() != null) {
            this.getSeries().getCore().SetIsMouseOverSeriesElement(this.getIndex(), value);
        }
    }

    public final StiSeriesInteractionData getInteraction() {
        return this.interaction;
    }

    public final void setInteraction(StiSeriesInteractionData value) {
        this.interaction = value;
    }

    public final int getIndex() {
        return this.index;
    }

    public final StiPoint getPoint() {
        return this.point;
    }

    public final IStiMarker getMarker() {
        return this.marker;
    }

    public final double getValue() {
        return this.value;
    }

    public final boolean getShowShadow() {
        return this.showShadow;
    }

    public final IStiSeries getSeries() {
        return this.series;
    }

    @Override
    public String getElementIndex() {
        return this.elementIndex;
    }

    @Override
    public void setElementIndex(String elementIndex) {
        this.elementIndex = elementIndex;
    }

    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        return this.GetMouseOverRect().contains(x, y);
    }

    public final StiRectangle GetMouseOverRect() {
        StiRectangle rect = this.getClientRectangle();
        rect.inflate(Double.valueOf(rect.width / 2.0), Double.valueOf(rect.height / 2.0));
        return rect;
    }

    @Override
    public void Draw(StiContext context) {
        context.PushSmoothingModeToAntiAlias();
        float chartZoom = context.Options.zoom;
        if (this.getIsMouseOver()) {
            context.FillEllipse((Object)StiMouseOverHelper.GetLineMouseOverColor(), this.GetMouseOverRect());
        }
        StiSolidBrush shadowBrush = new StiSolidBrush(StiColor.FromArgb((int)55, (StiColor)StiColor.Black));
        StiPenGeom pen = new StiPenGeom((Object)this.getMarker().getBorderColor());
        StiChart chart = (StiChart)this.getSeries().getChart();
        IStiMarker markerClone = (IStiMarker)this.getMarker().clone();
        markerClone.setBrush(this.series.ProcessSeriesBrushes(this.index, this.getMarker().getBrush()));
        StiInteractionDataGeom interaction = new StiInteractionDataGeom(chart.getName(), String.valueOf(chart.getPage().getComponents().indexOf(chart)), ((StiSeries)this.getSeries()).getDrillDownPageGuid(), String.valueOf(chart.getPage().getReport().getRenderedPages().indexOf(chart.getPage())), this.elementIndex);
        this.getMarker().getCore().Draw(context, markerClone, this.getPoint(), chartZoom, this.showShadow, this.getIsMouseOver() || this.series.getCore().getIsMouseOver(), chart.isAnimation, this.GetToolTip(), this, interaction);
        context.PopSmoothingMode();
    }

    public StiMarkerGeom(IStiSeries series, int index, double value, StiPoint point, IStiMarker marker, boolean showShadow, float zoom) {
        super(StiMarkerCoreXF.GetMarkerRect(point, marker.getSize(), zoom));
        this.series = series;
        this.index = index;
        this.value = value;
        this.point = point;
        this.marker = marker;
        this.showShadow = showShadow;
    }
}

