/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.animation.StiPointsAnimation;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.StiPointHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiAreaSeries;
import java.util.ArrayList;

public class StiAreaSeriesGeom
extends StiLineSeriesGeom {
    @Override
    public boolean Contains(double x, double y) {
        IStiArea tempVar = this.getSeries().getChart().getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        double posY = axisArea.getAxisCore().GetDividerY();
        if (this.getInvisible()) {
            return false;
        }
        for (int pointIndex = 0; pointIndex < this.getPoints().length - 1; ++pointIndex) {
            StiPoint point1 = this.getPoints()[pointIndex];
            StiPoint point2 = this.getPoints()[pointIndex + 1];
            if (point1 == null || point2 == null) continue;
            StiPoint point3 = new StiPoint(point2.getValue().x, posY);
            StiPoint point4 = new StiPoint(point1.getValue().x, posY);
            boolean result = StiPointHelper.IsPointInPolygon(new StiPoint(x, y), new StiPoint[]{point1.getValue(), point4, point3, point2.getValue()});
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        ArrayList<StiPoint[]> listFrom;
        StiRectangle rect = this.getClientRectangle();
        IStiSeries tempVar = this.getSeries();
        IStiAreaSeries areaSeries = (IStiAreaSeries)(tempVar instanceof IStiAreaSeries ? tempVar : null);
        StiChart chart = (StiChart)this.getSeries().getChart();
        IStiArea tempVar2 = this.getSeries().getChart().getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar2 instanceof IStiAxisArea ? tempVar2 : null);
        double posY = axisArea.getAxisCore().GetDividerY();
        ArrayList<StiPoint[]> list = StiNullableDrawing.GetPointsList(this.getPoints());
        ArrayList<StiPoint[]> arrayList = listFrom = this.getPointsFrom() != null ? StiNullableDrawing.GetPointsList(this.getPointsFrom()) : null;
        if (chart.isAnimation) {
            for (int index = 0; index < list.size(); ++index) {
                StiPoint[] newPoints = list.get(index);
                ArrayList<Object> path = new ArrayList<Object>();
                StiLineSegmentGeom lineSegment1 = new StiLineSegmentGeom(new StiPoint(newPoints[0].x, posY), newPoints[0]);
                StiLinesSegmentGeom lineSegments = new StiLinesSegmentGeom(newPoints);
                StiLineSegmentGeom lineSegment2 = new StiLineSegmentGeom(newPoints[newPoints.length - 1], new StiPoint(newPoints[newPoints.length - 1].x, posY));
                path.add(lineSegment1);
                path.add(lineSegments);
                path.add(lineSegment2);
                if (chart.isAnimationChangingValues()) {
                    StiPoint[] newPointsFrom = listFrom.get(index);
                    lineSegment1.setAnimation((StiAnimation)new StiPointsAnimation(new StiPoint[]{new StiPoint(newPointsFrom[0].x, posY), newPointsFrom[0]}, StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement));
                    lineSegments.setAnimation((StiAnimation)new StiPointsAnimation(newPointsFrom, StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement));
                    lineSegment2.setAnimation((StiAnimation)new StiPointsAnimation(new StiPoint[]{newPointsFrom[newPointsFrom.length - 1], new StiPoint(newPointsFrom[newPointsFrom.length - 1].x, posY)}, StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement));
                    context.FillDrawAnimationPath((Object)areaSeries.getBrush(), null, path, StiPathGeom.GetBoundsState, null, null, null);
                } else if (areaSeries.getBrush() != null) {
                    StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
                    context.FillDrawAnimationPath((Object)areaSeries.getBrush(), null, path, StiPathGeom.GetBoundsState, null, (StiAnimation)animation, null);
                }
                ++index;
            }
        } else {
            for (StiPoint[] newPoints : list) {
                ArrayList<Object> path = new ArrayList<Object>();
                path.add(new StiLineSegmentGeom(new StiPoint(newPoints[0].x, posY), newPoints[0]));
                path.add(new StiLinesSegmentGeom(newPoints));
                path.add(new StiLineSegmentGeom(newPoints[newPoints.length - 1], new StiPoint(newPoints[newPoints.length - 1].x, posY)));
                if (areaSeries.getBrush() != null) {
                    context.FillPath((Object)areaSeries.getBrush(), path, StiPathGeom.GetBoundsState);
                }
                if (areaSeries.getAllowApplyBrushNegative() && areaSeries.getBrushNegative() != null) {
                    double width = (float)(axisArea.getAxisCore().getScrollRangeX() * axisArea.getAxisCore().getScrollDpiX());
                    double height = (float)(axisArea.getAxisCore().getScrollRangeY() * axisArea.getAxisCore().getScrollDpiY() - posY);
                    StiRectangle clipRect = new StiRectangle(0.0, posY, width, height);
                    context.PushClip(clipRect);
                    context.FillPath((Object)areaSeries.getBrushNegative(), path, StiPathGeom.GetBoundsState);
                    context.PopClip();
                }
                if (!this.getIsMouseOver() && !this.getSeries().getCore().getIsMouseOver()) continue;
                context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), path, StiPathGeom.GetBoundsState);
            }
        }
    }

    public StiAreaSeriesGeom(StiAreaGeom areaGeom, StiPoint[] pointsFrom, StiPoint[] points, IStiSeries series) {
        super(areaGeom, pointsFrom, points, series);
    }
}

