/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiPenLineCap;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiBaseLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiSteppedLineSeries;
import java.util.ArrayList;

public class StiSteppedLineSeriesGeom
extends StiBaseLineSeriesGeom {
    protected final ArrayList<StiPoint> GetConvertedPoints(StiPoint[] points) {
        IStiSeries tempVar = this.getSeries();
        IStiSteppedLineSeries lineSeries = (IStiSteppedLineSeries)(tempVar instanceof IStiSteppedLineSeries ? tempVar : null);
        ArrayList<StiPoint> list = new ArrayList<StiPoint>();
        float distX = (float)((IStiAxisArea)lineSeries.getChart().getArea()).getXAxis().getInfo().Dpi / 2.0f;
        for (int index = 0; index < points.length - 1; ++index) {
            StiPoint point = points[index];
            StiPoint nextPoint = points[index + 1];
            if (point != null && nextPoint != null) {
                if (lineSeries.getPointAtCenter()) {
                    point = new StiPoint(point.getValue().x - (double)distX, point.getValue().y);
                    nextPoint = new StiPoint(nextPoint.getValue().x - (double)distX, nextPoint.getValue().y);
                }
                list.add(point);
                list.add(new StiPoint(nextPoint.getValue().x, point.getValue().y));
                continue;
            }
            list.add(null);
            list.add(null);
        }
        StiPoint pos = points[points.length - 1];
        if (pos != null) {
            if (lineSeries.getPointAtCenter()) {
                pos = new StiPoint(pos.getValue().x - (double)distX, pos.getValue().y);
                list.add(pos);
                pos = new StiPoint(pos.getValue().x + (double)(distX * 2.0f), pos.getValue().y);
                list.add(pos);
            } else {
                list.add(pos);
            }
        } else {
            list.add(null);
        }
        return (ArrayList)list.clone();
    }

    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        ArrayList<StiPoint> newPoints = this.GetConvertedPoints(this.getPoints());
        int pointIndex = 0;
        for (StiPoint point : newPoints) {
            StiPoint nextPoint = newPoints.get(pointIndex + 1);
            if (point == null || nextPoint == null) continue;
            StiRectangle pointRect = StiRectangle.getEmpty();
            if (nextPoint.getValue().x > point.getValue().x) {
                pointRect = new StiRectangle(point.getValue().x, point.getValue().y, nextPoint.getValue().x - point.getValue().x, 1.0);
                pointRect.inflate(0, 5);
            } else if (nextPoint.getValue().y > point.getValue().y) {
                pointRect = new StiRectangle(point.getValue().x, point.getValue().y, 1.0, nextPoint.getValue().y - point.getValue().y);
                pointRect.inflate(5, 0);
            } else {
                pointRect = new StiRectangle(nextPoint.getValue().x, nextPoint.getValue().y, 1.0, point.getValue().y - nextPoint.getValue().y);
                pointRect.inflate(5, 0);
            }
            if (pointRect.contains(x, y)) {
                return true;
            }
            if (++pointIndex != newPoints.size() - 1) continue;
            break;
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        IStiSeries tempVar = this.getSeries();
        IStiSteppedLineSeries lineSeries = (IStiSteppedLineSeries)(tempVar instanceof IStiSteppedLineSeries ? tempVar : null);
        context.PushSmoothingModeToAntiAlias();
        StiPenStyle dashStyle = lineSeries.getLineStyle();
        float scaledLineWidth = lineSeries.getLineWidth();
        StiPenGeom pen = new StiPenGeom((Object)lineSeries.getLineColor(), scaledLineWidth);
        pen.setPenStyle(dashStyle);
        ArrayList<StiPoint[]> list = StiNullableDrawing.GetNullablePointsList(this.getPoints());
        StiChart chart = (StiChart)this.getSeries().getChart();
        for (StiPoint[] newPoints2 : list) {
            IStiArea tempVar2;
            ArrayList<StiPoint> newPoints = this.GetConvertedPoints(newPoints2);
            if (lineSeries.getShowShadow()) {
                StiPenGeom penShadow = new StiPenGeom((Object)StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), scaledLineWidth + 0.5f);
                penShadow.setPenStyle(dashStyle);
                context.PushTranslateTransform((double)scaledLineWidth, (double)scaledLineWidth);
                StiNullableDrawing.DrawLines(context, penShadow, newPoints.toArray(new StiPoint[newPoints.size()]), chart.isAnimation);
                if (lineSeries.getLineMarker().getVisible()) {
                    StiSolidBrush brushShadow = new StiSolidBrush(StiColor.fromArgb((int)50, (int)0, (int)0, (int)0));
                    lineSeries.getLineMarker().getCore().DrawLines(context, newPoints.toArray(new StiPoint[0]), context.Options.zoom, brushShadow, null, lineSeries.getLineMarker().getType(), (float)lineSeries.getLineMarker().getStep(), lineSeries.getLineMarker().getSize(), lineSeries.getLineMarker().getAngle());
                }
                context.PopTransform();
            }
            if (this.getSeries().getCore().getIsMouseOver()) {
                float lineWidth = lineSeries.getLineWidth();
                double zoom = context.Options.zoom;
                float pointSize = 11.0f + lineWidth;
                for (StiPoint point : this.getPoints()) {
                    if (point == null) continue;
                    StiRectangle pointRect = new StiRectangle(point.getValue().x - (double)(pointSize / 2.0f) * zoom, point.getValue().y - (double)(pointSize / 2.0f) * zoom, (double)pointSize * zoom, (double)pointSize * zoom);
                    context.FillEllipse((Object)StiMouseOverHelper.GetLineMouseOverColor(), pointRect);
                }
                StiPenGeom penMouseOver = new StiPenGeom((Object)StiMouseOverHelper.GetLineMouseOverColor(), (4.0f + lineWidth) * (float)context.Options.zoom);
                penMouseOver.setStartCap(StiPenLineCap.Round);
                penMouseOver.setEndCap(StiPenLineCap.Round);
                StiNullableDrawing.DrawLines(context, penMouseOver, newPoints.toArray(new StiPoint[newPoints.size()]), chart.isAnimation);
            }
            IStiAxisArea axisArea = (IStiAxisArea)((tempVar2 = this.getSeries().getChart().getArea()) instanceof IStiAxisArea ? tempVar2 : null);
            double posY = axisArea.getAxisCore().GetDividerY();
            if (lineSeries.getAllowApplyColorNegative()) {
                StiPenGeom penNegative = new StiPenGeom((Object)lineSeries.getLineColorNegative(), scaledLineWidth);
                penNegative.setPenStyle(dashStyle);
                ArrayList<StiPoint> pointsNegative = new ArrayList<StiPoint>();
                ArrayList<StiPoint> pointsPositive = new ArrayList<StiPoint>();
                for (int index = 0; index < newPoints.size(); ++index) {
                    StiPenGeom penLight;
                    float step;
                    ArrayList points;
                    StiPoint pointNext;
                    StiPoint point = newPoints.get(index);
                    StiPoint stiPoint = pointNext = index != newPoints.size() - 1 ? newPoints.get(index + 1) : null;
                    if (point.getValue().y > posY) {
                        pointsNegative.add(point);
                        if (pointNext != null && !(pointNext.getValue().y <= posY)) continue;
                        this.IntersectionAxis(point, pointNext, pointsNegative, pointsPositive, posY);
                        points = new ArrayList();
                        points = (ArrayList)pointsNegative.clone();
                        StiNullableDrawing.DrawLines(context, penNegative, points.toArray(new StiPoint[points.size()]), chart.isAnimation);
                        if (scaledLineWidth >= 2.0f && lineSeries.getLighting()) {
                            step = 0.5f * (float)context.Options.zoom;
                            context.PushTranslateTransform((double)(-step), (double)(-step));
                            penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)lineSeries.getLineColorNegative(), (int)70), scaledLineWidth);
                            penLight.setPenStyle(dashStyle);
                            StiNullableDrawing.DrawLines(context, penLight, points.toArray(new StiPoint[points.size()]), chart.isAnimation);
                            context.PopTransform();
                        }
                        pointsNegative.clear();
                        continue;
                    }
                    pointsPositive.add(point);
                    if (pointNext != null && !(pointNext.getValue().y > posY)) continue;
                    this.IntersectionAxis(point, pointNext, pointsPositive, pointsNegative, posY);
                    points = new ArrayList();
                    points = (ArrayList)pointsPositive.clone();
                    StiNullableDrawing.DrawLines(context, pen, points.toArray(new StiPoint[points.size()]), chart.isAnimation);
                    if (scaledLineWidth >= 2.0f && lineSeries.getLighting()) {
                        step = 0.5f * (float)context.Options.zoom;
                        context.PushTranslateTransform((double)(-step), (double)(-step));
                        penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)lineSeries.getLineColor(), (int)70), scaledLineWidth);
                        penLight.setPenStyle(dashStyle);
                        StiNullableDrawing.DrawLines(context, penLight, points.toArray(new StiPoint[points.size()]), chart.isAnimation);
                        context.PopTransform();
                    }
                    pointsPositive.clear();
                }
            } else {
                if (list.size() == 1) {
                    ArrayList<StiPoint> newPointsStart = this.getPointsFrom() != null ? this.GetConvertedPoints(this.getPointsFrom()) : null;
                    StiNullableDrawing.DrawLines(context, pen, newPointsStart != null ? newPointsStart.toArray(new StiPoint[newPointsStart.size()]) : null, newPoints.toArray(new StiPoint[newPoints.size()]), chart.isAnimation);
                } else {
                    StiNullableDrawing.DrawLines(context, pen, newPoints.toArray(new StiPoint[newPoints.size()]), chart.isAnimation);
                }
                if (scaledLineWidth >= 2.0f && lineSeries.getLighting()) {
                    float step = 0.5f * (float)context.Options.zoom;
                    context.PushTranslateTransform((double)(-step), (double)(-step));
                    StiPenGeom penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)lineSeries.getLineColor(), (int)70), 1.0f);
                    penLight.setPenStyle(dashStyle);
                    StiNullableDrawing.DrawLines(context, penLight, newPoints.toArray(new StiPoint[newPoints.size()]), chart.isAnimation);
                    context.PopTransform();
                }
            }
            if (!lineSeries.getLineMarker().getVisible()) continue;
            StiPenGeom borderPen = new StiPenGeom((Object)lineSeries.getLineMarker().getBorderColor());
            lineSeries.getLineMarker().getCore().DrawLines(context, newPoints.toArray(new StiPoint[0]), context.Options.zoom, lineSeries.getLineMarker().getBrush(), borderPen, lineSeries.getLineMarker().getType(), (float)lineSeries.getLineMarker().getStep(), lineSeries.getLineMarker().getSize(), lineSeries.getLineMarker().getAngle());
        }
        context.PopSmoothingMode();
    }

    private void IntersectionAxis(StiPoint point, StiPoint pointNext, ArrayList<StiPoint> points, ArrayList<StiPoint> pointsNext, double posY) {
        if (pointNext != null) {
            StiPoint pointCross = new StiPoint(point.getValue().x, posY);
            points.add(pointCross);
            pointsNext.add(pointCross);
        }
    }

    public StiSteppedLineSeriesGeom(StiAreaGeom areaGeom, StiPoint[] pointsStart, StiPoint[] points, IStiSeries series) {
        super(areaGeom, pointsStart, points, series);
    }
}

