/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.financial;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiCloseFigureSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.financial.StiFinancialSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.candlestick.IStiCandlestickArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.candlestick.IStiCandlestickSeries;
import java.util.ArrayList;

public class StiCandlestickSeriesElementGeom
extends StiFinancialSeriesElementGeom {
    private final StiBrush brush;
    private Integer beginTime;
    private StiColor borderColor;

    public final StiBrush getBrush() {
        return this.brush;
    }

    public Integer getBeginTime() {
        return this.beginTime;
    }

    public StiColor getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void Draw(StiContext context) {
        IStiArea tempVar = this.getAreaGeom().getArea();
        IStiCandlestickArea candlestickArea = (IStiCandlestickArea)(tempVar instanceof IStiCandlestickArea ? tempVar : null);
        IStiSeries tempVar2 = this.getSeries();
        IStiCandlestickSeries candlestickSeries = (IStiCandlestickSeries)(tempVar2 instanceof IStiCandlestickSeries ? tempVar2 : null);
        float borderWidht = candlestickSeries.getBorderWidth() * (float)context.Options.zoom;
        float width = (float)candlestickArea.getXAxis().getInfo().Dpi / 2.0f;
        double open = this.getOpen();
        double close = this.getClose();
        double high = this.getHigh();
        double low = this.getLow();
        double positionX = this.getPositionX();
        StiPenGeom pen = new StiPenGeom((Object)this.borderColor, borderWidht);
        if (close == open) {
            open -= 1.0;
        }
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            Integer duration = StiChartHelper.GlobalDurationElement;
            StiPoint[] pointsOpen = new StiPoint[]{new StiPoint(positionX, high), new StiPoint(positionX, open)};
            StiPoint[] pointsClose = new StiPoint[]{new StiPoint(positionX, close), new StiPoint(positionX, low)};
            ArrayList<Object> path = new ArrayList<Object>();
            double x1 = positionX - (double)(width / 2.0f);
            double y1 = open;
            double x2 = x1 + (double)width;
            double y2 = y1 + close - open;
            path.add(new StiLineSegmentGeom(x1, y1, x2, y1));
            path.add(new StiLineSegmentGeom(x2, y1, x2, y2));
            path.add(new StiLineSegmentGeom(x2, y2, x1, y2));
            path.add(new StiLineSegmentGeom(x1, y2, x1, y1));
            path.add(new StiCloseFigureSegmentGeom());
            StiOpacityAnimation animation = new StiOpacityAnimation(duration, this.beginTime);
            if (candlestickSeries.getShowShadow()) {
                float borderWidhtShadow = borderWidht + 0.5f * (float)context.Options.zoom;
                StiPenGeom penShadow = new StiPenGeom((Object)StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), borderWidhtShadow);
                StiPoint[] pointsOpenShadow = new StiPoint[]{new StiPoint(positionX + (double)(borderWidhtShadow / 2.0f), high + (double)(borderWidhtShadow / 2.0f)), new StiPoint(positionX + (double)(borderWidhtShadow / 2.0f), open + (double)(borderWidhtShadow / 2.0f))};
                StiPoint[] pointsCloseShadow = new StiPoint[]{new StiPoint(positionX + (double)(borderWidhtShadow / 2.0f), close + (double)(borderWidhtShadow / 2.0f)), new StiPoint(positionX + (double)(borderWidhtShadow / 2.0f), low + (double)(borderWidhtShadow / 2.0f))};
                context.DrawAnimationLines(penShadow, pointsOpenShadow, (StiAnimation)animation);
                context.DrawAnimationLines(penShadow, pointsCloseShadow, (StiAnimation)animation);
                ArrayList<Object> pathShadow = new ArrayList<Object>();
                pathShadow.add(new StiLineSegmentGeom(x1 + (double)(borderWidhtShadow / 2.0f), y1 + (double)(borderWidhtShadow / 2.0f), x2 + (double)(borderWidhtShadow / 2.0f), y1 + (double)(borderWidhtShadow / 2.0f)));
                pathShadow.add(new StiLineSegmentGeom(x2 + (double)(borderWidhtShadow / 2.0f), y1 + (double)(borderWidhtShadow / 2.0f), x2 + (double)(borderWidhtShadow / 2.0f), y2 + (double)(borderWidhtShadow / 2.0f)));
                pathShadow.add(new StiLineSegmentGeom(x2 + (double)(borderWidhtShadow / 2.0f), y2 + (double)(borderWidhtShadow / 2.0f), x1 + (double)(borderWidhtShadow / 2.0f), y2 + (double)(borderWidhtShadow / 2.0f)));
                pathShadow.add(new StiLineSegmentGeom(x1 + (double)(borderWidhtShadow / 2.0f), y2 + (double)(borderWidhtShadow / 2.0f), x1 + (double)(borderWidhtShadow / 2.0f), y1 + (double)(borderWidhtShadow / 2.0f)));
                pathShadow.add(new StiCloseFigureSegmentGeom());
                context.FillDrawAnimationPath(null, penShadow, pathShadow, (Object)new StiRectangle(x1 + (double)(borderWidhtShadow / 2.0f), y1 + (double)(borderWidhtShadow / 2.0f), (double)width, close - open), null, (StiAnimation)animation, null);
            }
            context.DrawAnimationLines(pen, pointsOpen, (StiAnimation)animation);
            context.DrawAnimationLines(pen, pointsClose, (StiAnimation)animation);
            context.FillDrawAnimationPath((Object)this.brush, pen, path, (Object)new StiRectangle(x1, y1, (double)width, close - open), (Object)this, (StiAnimation)animation, null);
        } else {
            if (candlestickSeries.getShowShadow()) {
                float borderWidhtShadow = borderWidht + 0.5f * (float)context.Options.zoom;
                StiPenGeom penShadow = new StiPenGeom((Object)StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), borderWidhtShadow);
                context.PushTranslateTransform((double)borderWidht, (double)borderWidht);
                context.DrawLine(penShadow, positionX, close + (double)(borderWidhtShadow / 2.0f), positionX, low + (double)(borderWidhtShadow / 2.0f));
                context.DrawLine(penShadow, positionX, high, positionX, open - (double)(borderWidhtShadow / 2.0f));
                context.DrawRectangle(penShadow, positionX - (double)(width / 2.0f), open, (double)width, close - open);
                context.PopTransform();
            }
            context.DrawLine(pen, positionX, high, positionX, open);
            context.DrawLine(pen, positionX, close, positionX, low);
            context.FillRectangle((Object)this.brush, positionX - (double)(width / 2.0f), open, (double)width, close - open);
            context.DrawRectangle(pen, positionX - (double)(width / 2.0f), open, (double)width, close - open);
        }
    }

    public StiCandlestickSeriesElementGeom(StiAreaGeom areaGeom, IStiSeries series, StiRectangle clientRectangle, double bodyStart, double bodyEnd, double high, double low, double positionX, int index, StiBrush brush, StiColor borderColor, Integer beginTime) {
        super(areaGeom, series, clientRectangle, bodyStart, bodyEnd, high, low, positionX, index);
        this.brush = brush;
        this.borderColor = borderColor;
        this.beginTime = beginTime;
    }
}

