/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.radar;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiInteractionDataGeom;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.core.marker.StiMarkerCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredBar.IStiClusteredBarSeries;
import com.stimulsoft.report.chart.interfaces.series.fullStackedBar.IStiFullStackedBarSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedBar.IStiStackedBarSeries;
import com.stimulsoft.report.chart.view.series.StiSeries;

public class StiRadarPointSeriesElementGeom
extends StiSeriesElementGeom {
    private final StiPoint point;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (!this.getIsMouseOver()) {
            this.setIsMouseOver(true);
            options.setUpdateContext(true);
        }
        int valueIndex = this.GetValueIndex();
        options.setInteractionToolTip(this.GetToolTip(valueIndex));
        options.setInteractionHyperlink(this.GetHyperlink(valueIndex));
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (this.getIsMouseOver()) {
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeClick(StiInteractionOptions options) {
        int valueIndex = this.GetValueIndex();
        if (this.getSeries().getHyperlinks() != null && valueIndex < this.getSeries().getHyperlinks().length) {
            options.setInteractionHyperlink(this.getSeries().getHyperlinks()[valueIndex]);
        }
        if (this.getSeries().getInteraction().getDrillDownEnabled()) {
            options.setSeriesInteractionData(this.getInteraction());
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
        }
    }

    private int GetValueIndex() {
        int valueIndex = this.getIndex();
        if (this.getSeries() instanceof IStiClusteredBarSeries || this.getSeries() instanceof IStiStackedBarSeries || this.getSeries() instanceof IStiFullStackedBarSeries) {
            if (this.getSeries().getChart().getArea() instanceof IStiAxisArea && !((IStiAxisArea)this.getSeries().getChart().getArea()).getReverseVert()) {
                valueIndex = this.getSeries().getValues().length - valueIndex - 1;
            }
        } else if (this.getSeries().getChart().getArea() instanceof IStiAxisArea && ((IStiAxisArea)this.getSeries().getChart().getArea()).getReverseHor()) {
            valueIndex = this.getSeries().getValues().length - valueIndex - 1;
        }
        return valueIndex;
    }

    private String GetHyperlink(int valueIndex) {
        if (this.getSeries().getHyperlinks() != null && valueIndex < this.getSeries().getHyperlinks().length) {
            return this.getSeries().getHyperlinks()[valueIndex];
        }
        return null;
    }

    private String GetToolTip(int valueIndex) {
        if (this.getSeries().getToolTips() != null && valueIndex < this.getSeries().getToolTips().length) {
            return this.getSeries().getToolTips()[valueIndex];
        }
        return null;
    }

    public final StiPoint getPoint() {
        return this.point;
    }

    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        return this.GetMouseOverRect().contains(x, y);
    }

    public final StiRectangle GetMouseOverRect() {
        StiRectangle rect = this.getClientRectangle();
        rect.inflate(Double.valueOf(rect.width / 2.0), Double.valueOf(rect.height / 2.0));
        return rect;
    }

    @Override
    public void Draw(StiContext context) {
        IStiSeries tempVar = this.getSeries();
        IStiRadarSeries radarSeries = (IStiRadarSeries)(tempVar instanceof IStiRadarSeries ? tempVar : null);
        if (radarSeries.getMarker() != null && radarSeries.getMarker().getVisible()) {
            context.PushSmoothingModeToAntiAlias();
            float chartZoom = context.Options.zoom;
            if (this.getIsMouseOver()) {
                context.FillEllipse((Object)StiMouseOverHelper.GetLineMouseOverColor(), this.GetMouseOverRect());
            }
            StiChart chart = (StiChart)this.getSeries().getChart();
            StiInteractionDataGeom interaction = new StiInteractionDataGeom(chart.getName(), String.valueOf(chart.getPage().getComponents().indexOf(chart)), ((StiSeries)this.getSeries()).getDrillDownPageGuid(), String.valueOf(chart.getPage().getReport().getRenderedPages().indexOf(chart.getPage())), this.getElementIndex());
            radarSeries.getMarker().getCore().Draw(context, radarSeries.getMarker(), this.getPoint(), chartZoom, radarSeries.getShowShadow(), this.getIsMouseOver(), chart.isAnimation, this.GetToolTip(), this, interaction);
            context.PopSmoothingMode();
        }
    }

    public StiRadarPointSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, IStiRadarSeries series, StiPoint point, float zoom) {
        super(areaGeom, value, index, series, StiMarkerCoreXF.GetMarkerRect(point, series.getMarker().getSize(), zoom));
        this.point = point.clone();
    }
}

