/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.range;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiCurveSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiSplineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiSplineRangeSeries;
import java.util.ArrayList;

public class StiSplineRangeSeriesGeom
extends StiSplineSeriesGeom {
    private StiPoint[] pointsEnd;

    public final StiPoint[] getPointsEnd() {
        return this.pointsEnd;
    }

    public final void setPointsEnd(StiPoint[] value) {
        this.pointsEnd = value;
    }

    @Override
    public void Draw(StiContext context) {
        ArrayList<StiPoint[]> list = StiNullableDrawing.GetPointsList(this.getPoints());
        ArrayList<StiPoint[]> listEnd = StiNullableDrawing.GetPointsList(this.getPointsEnd());
        if (list.size() < 1 || listEnd.size() < 1) {
            return;
        }
        StiPoint[] points = list.get(0);
        StiPoint[] pointsEnd = listEnd.get(0);
        int count = Math.min(points.length, pointsEnd.length);
        this.FillPath(context, points, pointsEnd);
    }

    private void FillPath(StiContext context, StiPoint[] points, StiPoint[] pointsEnd) {
        IStiSeries tempVar = this.getSeries();
        IStiSplineRangeSeries areaSeries = (IStiSplineRangeSeries)(tempVar instanceof IStiSplineRangeSeries ? tempVar : null);
        StiBrush brush = areaSeries.getBrush();
        ArrayList<Object> path = new ArrayList<Object>();
        StiPoint[] pointsEndBack = new StiPoint[pointsEnd.length];
        int count = pointsEnd.length;
        for (int index = 0; index < count; ++index) {
            pointsEndBack[index] = pointsEnd[count - index - 1];
        }
        path.add(new StiLineSegmentGeom(pointsEnd[0], points[0]));
        path.add(new StiCurveSegmentGeom(points, areaSeries.getTension()));
        path.add(new StiLineSegmentGeom(points[points.length - 1], pointsEnd[pointsEnd.length - 1]));
        path.add(new StiCurveSegmentGeom(pointsEndBack, areaSeries.getTension()));
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
            context.FillDrawAnimationPath((Object)brush, null, path, StiPathGeom.GetBoundsState, null, (StiAnimation)animation, null);
        } else {
            context.FillPath((Object)brush, path, StiPathGeom.GetBoundsState);
        }
        if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
            context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), path, StiPathGeom.GetBoundsState);
        }
    }

    public StiSplineRangeSeriesGeom(StiAreaGeom areaGeom, StiPoint[] points, StiPoint[] pointsEnd, IStiSeries series) {
        super(areaGeom, null, points, series);
        this.pointsEnd = pointsEnd;
    }
}

