/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.trendLines;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiBaseLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;

public class StiTrendCurveGeom
extends StiCellGeom {
    private final StiPoint[] points;
    private final IStiTrendLine trendLine;

    public StiTrendCurveGeom(StiPoint[] points, IStiTrendLine trendLine) {
        super(StiBaseLineSeriesGeom.GetClientRectangle(points));
        this.points = points;
        this.trendLine = trendLine;
    }

    @Override
    public void Draw(StiContext context) {
        StiPoint[] pointsNull = new StiPoint[this.points.length];
        for (int index = 0; index < this.points.length; ++index) {
            pointsNull[index] = this.points[index].getValue();
        }
        StiColor lineColor = this.trendLine.getLineColor();
        float lineWidth = this.trendLine.getLineWidth();
        StiPenStyle style = this.trendLine.getLineStyle();
        boolean showShadow = this.trendLine.getShowShadow();
        float scaledLineWidth = lineWidth * (float)context.Options.zoom;
        context.PushSmoothingModeToAntiAlias();
        if (showShadow) {
            StiPenGeom penShadow = new StiPenGeom((Object)StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), scaledLineWidth + 0.5f * (float)context.Options.zoom);
            penShadow.setPenStyle(style);
            context.PushTranslateTransform((double)scaledLineWidth, (double)scaledLineWidth);
            StiNullableDrawing.DrawCurve(context, penShadow, this.points, 0.0f);
            context.PopTransform();
        }
        StiPenGeom pen = new StiPenGeom((Object)lineColor, lineWidth * (float)context.Options.zoom);
        pen.setPenStyle(style);
        context.DrawCurve(pen, pointsNull, 0.0f);
        context.PopSmoothingMode();
    }
}

