/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.filter;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.report.chart.interfaces.filters.IStiChartFilter;
import com.stimulsoft.report.chart.view.filter.StiChartFiltersCollection;
import com.stimulsoft.report.components.enums.StiFilterCondition;
import com.stimulsoft.report.components.enums.StiFilterDataType;
import com.stimulsoft.report.components.enums.StiFilterItem;
import java.text.MessageFormat;

public class StiChartFilter
implements Cloneable,
IStiChartFilter,
IStiSerializableToString,
IStiJsonReportObject {
    private StiFilterCondition condition = StiFilterCondition.EqualTo;
    private StiFilterDataType dataType = StiFilterDataType.String;
    private StiFilterItem item = StiFilterItem.Argument;
    private String valueObj = "";
    public StiChartFiltersCollection Filters = null;

    public StiChartFilter() {
        this(StiFilterItem.Argument, StiFilterDataType.String, StiFilterCondition.EqualTo, "");
    }

    public StiChartFilter(StiFilterItem item, StiFilterDataType dataType, StiFilterCondition condition, String value) {
        this.item = item;
        this.dataType = dataType;
        this.condition = condition;
        this.valueObj = value;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final int getIndex() {
        if (this.Filters == null) {
            return -1;
        }
        int index = this.Filters.indexOf(this);
        return index;
    }

    @Override
    @StiDefaulValue(value="EqualTo")
    public final StiFilterCondition getCondition() {
        return this.condition;
    }

    @Override
    public final void setCondition(StiFilterCondition value) {
        this.condition = value;
    }

    @Override
    @StiDefaulValue(value="String")
    public final StiFilterDataType getDataType() {
        return this.dataType;
    }

    @Override
    public final void setDataType(StiFilterDataType value) {
        this.dataType = value;
    }

    @Override
    @StiDefaulValue(value="Argument")
    public final StiFilterItem getItem() {
        return this.item;
    }

    @Override
    public final void setItem(StiFilterItem value) {
        this.item = value;
    }

    @Override
    @StiDefaulValue(value="")
    public final String getValue() {
        return this.valueObj;
    }

    @Override
    public final void setValue(String value) {
        this.valueObj = value;
    }

    public String toString() {
        String sign = "";
        switch (this.getCondition()) {
            case EqualTo: {
                sign = "=";
                break;
            }
            case NotEqualTo: {
                sign = "<>";
                break;
            }
            case GreaterThan: {
                sign = ">";
                break;
            }
            case GreaterThanOrEqualTo: {
                sign = ">=";
                break;
            }
            case LessThan: {
                sign = "<";
                break;
            }
            case LessThanOrEqualTo: {
                sign = "=<";
            }
        }
        String item = StiLocalization.Get((String)"PropertyMain", (String)"Argument");
        if (this.getItem() == StiFilterItem.Value) {
            item = StiLocalization.Get((String)"PropertyMain", (String)"Value");
        }
        return String.format("%1$s %2$s %3$s", item, sign, this.getValue());
    }

    public String serialize() {
        return MessageFormat.format("{0},{1},{2},{3}", new Object[]{this.item, this.dataType, this.condition, StiXMLConvert.encodeName((String)this.valueObj)});
    }

    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.item = StiFilterItem.valueOf(values[0]);
        this.dataType = StiFilterDataType.valueOf(values[1]);
        this.condition = StiFilterCondition.valueOf(values[2]);
        this.valueObj = StiXMLConvert.decodeName((String)values[3]);
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyEnum("Condition", (Enum)this.getCondition(), (Enum)StiFilterCondition.EqualTo);
        jObject.AddPropertyEnum("DataType", (Enum)this.getDataType(), (Enum)StiFilterDataType.String);
        jObject.AddPropertyEnum("Item", (Enum)this.getItem(), (Enum)StiFilterItem.Argument);
        jObject.AddPropertyStringNullOfEmpty("Value", this.getValue());
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Condition")) {
                this.condition = StiFilterCondition.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("DataType")) {
                this.dataType = StiFilterDataType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Item")) {
                this.item = StiFilterItem.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("Value")) continue;
            this.valueObj = (String)property.Value;
        }
    }
}

