/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.clusteredColumn;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.chart.enums.StiMarkerType;
import com.stimulsoft.report.chart.interfaces.marker.IStiLineMarker;
import com.stimulsoft.report.chart.interfaces.marker.IStiMarker;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiBaseLineSeries;
import com.stimulsoft.report.chart.view.conditions.StiChartConditionsCollection;
import com.stimulsoft.report.chart.view.marker.StiLineMarker;
import com.stimulsoft.report.chart.view.marker.StiMarker;
import com.stimulsoft.report.chart.view.series.StiSeries;

public abstract class StiBaseLineSeries
extends StiSeries
implements IStiBaseLineSeries {
    private boolean showNulls = true;
    private IStiMarker marker = new StiMarker();
    private IStiLineMarker lineMarker = new StiLineMarker();
    private StiColor lineColor = StiColor.Black;
    private StiPenStyle lineStyle = StiPenStyle.Solid;
    private boolean lighting = true;
    private float lineWidth = 2.0f;
    private int labelsOffset = 0;
    private StiColor lineColorNegative = StiColor.Firebrick;
    private boolean allowApplyColorNegative = false;

    @Override
    public IStiBaseLineSeries clone() {
        IStiSeries tempVar = super.clone();
        IStiBaseLineSeries series = (IStiBaseLineSeries)(tempVar instanceof IStiBaseLineSeries ? tempVar : null);
        series.setLineStyle(this.getLineStyle());
        return series;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="true")
    public boolean getShowNulls() {
        return this.showNulls;
    }

    @Override
    public void setShowNulls(boolean value) {
        this.showNulls = value;
    }

    @Deprecated
    public final boolean getShowMarker() {
        return this.getMarker().getVisible();
    }

    @Deprecated
    public final void setShowMarker(boolean value) {
        this.getMarker().setVisible(value);
    }

    @Deprecated
    public final StiColor getMarkerColor() {
        return StiBrush.ToColor((StiBrush)this.getMarker().getBrush());
    }

    @Deprecated
    public final void setMarkerColor(StiColor value) {
        this.getMarker().setBrush((StiBrush)new StiSolidBrush(value));
        this.getMarker().setBorderColor(StiColorUtils.dark((StiColor)value, (int)50));
    }

    @Deprecated
    public final float getMarkerSize() {
        return this.getMarker().getSize();
    }

    @Deprecated
    public final void setMarkerSize(float value) {
        this.getMarker().setSize(value);
    }

    @Deprecated
    public final StiMarkerType getMarkerType() {
        return ((StiMarker)this.marker).getType();
    }

    @Deprecated
    public final void setMarkerType(StiMarkerType value) {
        ((StiMarker)this.marker).setType(value);
    }

    @Override
    @StiSerializable
    public IStiMarker getMarker() {
        return this.marker;
    }

    @Override
    public void setMarker(IStiMarker value) {
        this.marker = value;
    }

    @Override
    @StiSerializable
    public IStiLineMarker getLineMarker() {
        return this.lineMarker;
    }

    @Override
    public void setLineMarker(IStiLineMarker value) {
        this.lineMarker = value;
    }

    @Override
    @StiSerializable(need=false)
    public StiChartConditionsCollection getConditions() {
        return super.getConditions();
    }

    @Override
    public void setConditions(StiChartConditionsCollection value) {
        super.setConditions(value);
    }

    @Override
    @StiSerializable
    public StiColor getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(StiColor value) {
        this.lineColor = value;
    }

    @Override
    @StiDefaulValue(value="Solid")
    @StiSerializable
    public StiPenStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(StiPenStyle value) {
        this.lineStyle = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getLighting() {
        return this.lighting;
    }

    @Override
    public void setLighting(boolean value) {
        this.lighting = value;
    }

    @Override
    @StiDefaulValue(value="2.0")
    @StiSerializable
    public float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(float value) {
        if (value > 0.0f) {
            this.lineWidth = value;
        }
    }

    @Override
    @StiDefaulValue(value="0")
    @StiSerializable
    public final int getLabelsOffset() {
        return this.labelsOffset;
    }

    @Override
    public final void setLabelsOffset(int value) {
        this.labelsOffset = value;
    }

    @Override
    @StiSerializable
    public StiColor getLineColorNegative() {
        return this.lineColorNegative;
    }

    @Override
    public void setLineColorNegative(StiColor value) {
        this.lineColorNegative = value;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getAllowApplyColorNegative() {
        return this.allowApplyColorNegative;
    }

    @Override
    public void setAllowApplyColorNegative(boolean value) {
        this.allowApplyColorNegative = value;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("Conditions");
        jObject.AddPropertyBool("ShowNulls", this.getShowNulls(), true);
        jObject.AddPropertyJObject("Marker", this.getMarker().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("LineMarker", this.getLineMarker().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("LineColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.lineColor, (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyEnum("LineStyle", (Enum)this.getLineStyle(), (Enum)StiPenStyle.Solid);
        jObject.AddPropertyBool("Lighting", this.getLighting(), true);
        jObject.AddPropertyFloat("LineWidth", (double)this.getLineWidth(), 2.0);
        jObject.AddPropertyInt("LabelsOffset", this.getLabelsOffset());
        jObject.AddPropertyStringNullOfEmpty("LineColorNegative", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.lineColorNegative, (StiColorEnum)StiColorEnum.Firebrick));
        jObject.AddPropertyBool("AllowApplyColorNegative", this.getAllowApplyColorNegative());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ShowNulls")) {
                this.setShowNulls((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Marker")) {
                this.getMarker().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("LineMarker")) {
                this.getLineMarker().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("LineColor")) {
                this.setLineColor(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
                continue;
            }
            if (property.Name.equals("LineStyle")) {
                this.setLineStyle(StiPenStyle.valueOf((String)((String)property.Value)));
                continue;
            }
            if (property.Name.equals("Lighting")) {
                this.setLighting((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("LineWidth")) {
                this.setLineWidth(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("LabelsOffset")) {
                this.setLabelsOffset((Integer)property.Value);
                continue;
            }
            if (property.Name.equals("LineColorNegative")) {
                this.setLineColorNegative(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
                continue;
            }
            if (!property.Name.equals("AllowApplyColorNegative")) continue;
            this.setAllowApplyColorNegative((Boolean)property.Value);
        }
    }
}

