/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.radar;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.chart.core.series.radar.StiRadarAreaSeriesCoreXF;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarAreaSeries;
import com.stimulsoft.report.chart.view.areas.radar.StiRadarAreaArea;
import com.stimulsoft.report.chart.view.series.radar.StiRadarSeries;

public class StiRadarAreaSeries
extends StiRadarSeries
implements IStiRadarAreaSeries {
    private StiColor lineColor = StiColor.Black;
    private StiPenStyle lineStyle = StiPenStyle.Solid;
    private boolean lighting = true;
    private float lineWidth = 2.0f;
    private StiBrush brush = new StiSolidBrush(StiColor.Gainsboro);

    @Override
    @StiSerializable
    public StiColor getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(StiColor value) {
        this.lineColor = value;
    }

    @Override
    @StiDefaulValue(value="Solid")
    @StiSerializable
    public StiPenStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(StiPenStyle value) {
        this.lineStyle = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getLighting() {
        return this.lighting;
    }

    @Override
    public void setLighting(boolean value) {
        this.lighting = value;
    }

    @Override
    @StiDefaulValue(value="2.0")
    @StiSerializable
    public float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(float value) {
        if (value > 0.0f) {
            this.lineWidth = value;
        }
    }

    @Override
    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    public Class GetDefaultAreaType() {
        return StiRadarAreaArea.class;
    }

    public StiRadarAreaSeries() {
        this.setCore(new StiRadarAreaSeriesCoreXF(this));
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("LineColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getLineColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyEnum("LineStyle", (Enum)this.getLineStyle(), (Enum)StiPenStyle.Solid);
        jObject.AddPropertyBool("Lighting", this.getLighting(), true);
        jObject.AddPropertyFloat("LineWidth", (double)this.getLineWidth(), 2.0);
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("LineColor")) {
                this.setLineColor(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
                continue;
            }
            if (property.Name.equals("LineStyle")) {
                this.setLineStyle(StiPenStyle.valueOf((String)((String)property.Value)));
                continue;
            }
            if (property.Name.equals("Lighting")) {
                this.setLighting((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("LineWidth")) {
                this.setLineWidth(property.floatValue().floatValue());
                continue;
            }
            if (!property.Name.equals("Brush")) continue;
            this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
        }
    }
}

