/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheck;
import com.stimulsoft.report.check.StiCheckEngine;
import com.stimulsoft.report.check.report.StiReportRenderingMessageCheck;
import java.util.ArrayList;
import java.util.List;

public class StiCheckHelper {
    private int errorsCount = 0;
    private int warningsCount = 0;
    private int informationMessagesCount = 0;
    private int reportRenderingMessagesCount = 0;
    private List<StiCheck> checks;
    private List<StiCheck> reportRenderingMessagesChecks;

    public int getErrorsCount() {
        return this.errorsCount;
    }

    public int getWarningsCount() {
        return this.warningsCount;
    }

    public int getInformationMessagesCount() {
        return this.informationMessagesCount;
    }

    public int getReportRenderingMessagesCount() {
        return this.reportRenderingMessagesCount;
    }

    public List<StiCheck> getChecks() {
        return this.checks;
    }

    public List<StiCheck> getReportRenderingMessagesChecks() {
        return this.reportRenderingMessagesChecks;
    }

    public boolean isMessagesPresent() {
        return this.getErrorsCount() > 0 || this.getInformationMessagesCount() > 0 || this.getReportRenderingMessagesCount() > 0 || this.getWarningsCount() > 0;
    }

    public void buildChecks(StiReport report) throws StiException {
        StiCheckEngine engine = new StiCheckEngine();
        this.checks = engine.checkReport(report);
        this.errorsCount = 0;
        this.warningsCount = 0;
        this.informationMessagesCount = 0;
        for (StiCheck check : this.checks) {
            switch (check.getStatus()) {
                case Error: {
                    ++this.errorsCount;
                    break;
                }
                case Warning: {
                    ++this.warningsCount;
                    break;
                }
                case Information: {
                    ++this.informationMessagesCount;
                }
            }
        }
    }

    public void buildReportRenderingMessages(StiReport report) {
        this.reportRenderingMessagesCount = 0;
        this.reportRenderingMessagesChecks = new ArrayList<StiCheck>();
        StiReport stiReport = report = report.getCompiledReport() != null ? report.getCompiledReport() : report;
        if (report.getReportRenderingMessages() != null && report.getReportRenderingMessages().size() > 0) {
            for (String message : report.getReportRenderingMessages()) {
                StiReportRenderingMessageCheck check = new StiReportRenderingMessageCheck();
                check.SetMessage(message);
                this.checks.add(check);
                this.reportRenderingMessagesChecks.add(check);
            }
            this.reportRenderingMessagesCount = report.getReportRenderingMessages().size();
        }
    }
}

