/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.component;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.component.StiComponentCheck;
import com.stimulsoft.report.components.simplecomponents.StiImage;

public class StiDataSourcesForImageCheck
extends StiComponentCheck {
    @Override
    public boolean getPreviewVisible() {
        return true;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.Get((String)"CheckComponent", (String)"StiDataSourcesForImageCheckShort");
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiDataSourcesForImageCheckLong", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Information;
    }

    private boolean check() {
        StiImage image;
        StiImage stiImage = image = this.getElement() instanceof StiImage ? (StiImage)this.getElement() : null;
        if (image != null) {
            int count = 0;
            if (image.getImageBytes() != null) {
                ++count;
            }
            if (!StiValidationUtil.isNullOrEmpty((String)image.getDataColumn())) {
                ++count;
            }
            if (image.getImageData() != null && !"".equals(image.getImageData().getValue())) {
                ++count;
            }
            if (image.getImageURL() != null && !"".equals(image.getImageURL().getValue())) {
                ++count;
            }
            if (!"".equals(image.getFile())) {
                ++count;
            }
            if (count > 1) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        try {
            boolean failed = this.check();
            if (failed) {
                StiDataSourcesForImageCheck check = new StiDataSourcesForImageCheck();
                check.setElement(obj);
                StiDataSourcesForImageCheck stiDataSourcesForImageCheck = check;
                return stiDataSourcesForImageCheck;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.setElement(null);
        }
    }
}

