/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.datarelation;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.datarelation.StiDataRelationCheck;
import com.stimulsoft.report.dictionary.StiDataRelation;

public class StiKeysTypesMismatchDataRelationCheck
extends StiDataRelationCheck {
    private String columns;

    @Override
    public boolean getPreviewVisible() {
        return true;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.format((String)"CheckDataRelation", (String)"StiKeysTypesMismatchDataRelationCheckShort", (Object[])new Object[]{this.getElementName(), this.getColumns()});
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckDataRelation", (String)"StiKeysTypesMismatchDataRelationCheckLong", (Object[])new Object[]{this.getElementName(), this.getColumns()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Error;
    }

    private boolean isColumnsExist(StiDataRelation relation) {
        for (String column : relation.getParentColumns()) {
            if (relation.getParentSource().getColumns().contains(column)) continue;
            return false;
        }
        for (String column : relation.getChildColumns()) {
            if (relation.getChildSource().getColumns().contains(column)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object processCheck(StiReport report, Object obj) {
        StiDataRelation relation;
        this.setElement(obj);
        StiDataRelation stiDataRelation = relation = obj instanceof StiDataRelation ? (StiDataRelation)obj : null;
        if (relation != null && relation.getParentSource() != null && relation.getChildSource() != null && relation.getParentColumns().size() == relation.getChildColumns().size() && this.isColumnsExist(relation)) {
            boolean finded = false;
            String columns = "";
            for (int index = 0; index < relation.getParentColumns().size(); ++index) {
                Class<?> childType;
                String parentColumn = relation.getParentColumns().get(index);
                String childColumn = relation.getChildColumns().get(index);
                Class<?> parentType = relation.getParentSource().getColumns().get(parentColumn).getClass();
                if (parentType.equals(childType = relation.getChildSource().getColumns().get(childColumn).getClass())) continue;
                columns = columns.length() == 0 ? parentColumn + "-" + childColumn : columns + "; " + parentColumn + "-" + childColumn;
                finded = true;
            }
            if (finded) {
                StiKeysTypesMismatchDataRelationCheck check = new StiKeysTypesMismatchDataRelationCheck();
                check.columns = columns;
                check.setElement(obj);
                return check;
            }
        }
        return null;
    }
}

