/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.page;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.page.StiPrintHeadersFootersFromPreviousPageAction;
import com.stimulsoft.report.check.page.StiPageCheck;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.dialogs.IStiForm;

public class StiPrintHeadersAndFootersFromPreviousPageCheck
extends StiPageCheck {
    @Override
    public String getShortMessage() {
        return StiLocalizationExt.Get((String)"CheckComponent", (String)"StiPrintHeadersAndFootersFromPreviousPageShort");
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiPrintHeadersAndFootersFromPreviousPageLong", (Object[])new Object[]{this.getElement()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Information;
    }

    private int getPageCount(StiReport report) {
        int count = 0;
        for (StiPage page : report.getPages()) {
            if (page instanceof IStiForm) continue;
            ++count;
        }
        return count;
    }

    private boolean check() {
        StiPage page = this.getElement() instanceof StiPage ? (StiPage)this.getElement() : null;
        StiReport report = page.getReport();
        return page != null && page.getPrintHeadersFootersFromPreviousPage() && (this.getPageCount(report) == 1 || report.getPages().indexOf(page) == 0);
    }

    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        boolean failed = this.check();
        if (failed) {
            StiPrintHeadersAndFootersFromPreviousPageCheck check = new StiPrintHeadersAndFootersFromPreviousPageCheck();
            check.setElement(obj);
            check.getActions().add(new StiPrintHeadersFootersFromPreviousPageAction());
            return check;
        }
        return null;
    }
}

