/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiDockStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StiComponentsCollection
extends ArrayList<StiComponent>
implements IStiJsonReportObject {
    private static final long serialVersionUID = 5906967239100537210L;
    private static final Comparator<StiComponent> BY_SELECTION_TICK = new Comparator<StiComponent>(){

        @Override
        public int compare(StiComponent comp1, StiComponent comp2) {
            Integer val1 = comp1.getSelectionTick();
            Integer val2 = comp2.getSelectionTick();
            return val1.compareTo(val2);
        }
    };
    private static final Comparator<StiComponent> BY_PRIORITY = new Comparator<StiComponent>(){

        @Override
        public int compare(StiComponent comp1, StiComponent comp2) {
            Integer val1 = comp1.getPriority();
            Integer val2 = comp2.getPriority();
            return val1.compareTo(val2);
        }
    };
    private static final Comparator<StiComponent> BY_TOP = new Comparator<StiComponent>(){

        @Override
        public int compare(StiComponent comp1, StiComponent comp2) {
            Double val1 = comp1.getTop();
            Double val2 = comp2.getTop();
            return val1.compareTo(val2);
        }
    };
    private static final Comparator<StiComponent> BY_BOTTOM = new Comparator<StiComponent>(){

        @Override
        public int compare(StiComponent comp1, StiComponent comp2) {
            Double val1 = comp1.getBottom();
            Double val2 = comp2.getBottom();
            return val1.compareTo(val2);
        }
    };
    private static final Comparator<StiComponent> BY_LEFT = new Comparator<StiComponent>(){

        @Override
        public int compare(StiComponent comp1, StiComponent comp2) {
            Double val1 = comp1.getLeft();
            Double val2 = comp2.getLeft();
            return val1.compareTo(val2);
        }
    };
    private static final Comparator<StiComponent> BY_RIGHT = new Comparator<StiComponent>(){

        @Override
        public int compare(StiComponent comp1, StiComponent comp2) {
            Double val1 = comp1.getRight();
            Double val2 = comp2.getRight();
            return val1.compareTo(val2);
        }
    };
    private StiContainer parent;

    public StiComponentsCollection(StiContainer parent) {
        this.parent = parent;
    }

    public StiComponentsCollection() {
        this.parent = null;
    }

    public StiComponentsCollection(int size) {
        super(size);
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiComponent component : this) {
            jObject.AddPropertyJObject(index.toString(), component.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            JSONObject propJObject = (JSONObject)property.Value;
            String ident = propJObject.Properties().FirstOrDefault((String)"Ident").Value.toString();
            Class<?> clazz = null;
            List<Class<?>> classes = StiOptions.Services.getComponents();
            for (Class<?> claz : classes) {
                String name = claz.getName();
                if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
                clazz = claz;
            }
            if (clazz == null) {
                throw new RuntimeException("Type " + ident + " is not found!");
            }
            StiComponent component = null;
            try {
                component = (StiComponent)clazz.newInstance();
            }
            catch (Exception e) {
                new RuntimeException("Type " + ident + " is not found!");
            }
            this.add(component);
            component.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    @Override
    public boolean add(StiComponent component) {
        this.AddCore(component);
        return super.add(component);
    }

    @Override
    public void add(int index, StiComponent component) {
        this.AddCore(component);
        super.add(index, component);
    }

    private void AddCore(StiComponent component) {
        if (this.parent != null) {
            component.setParent(this.parent);
            if (this.parent.getPage() != null) {
                component.setPage(this.parent.getPage());
                if (component.getName() == null || component.getName().length() == 0) {
                    if (component.getReport() != null && component.getReport().getIsDesigning()) {
                        component.setName(StiNameCreation.createName(this.parent.getReport(), StiNameCreation.generateName(component)));
                    } else {
                        component.setName(StiNameCreation.createSimpleName(this.parent.getReport(), StiNameCreation.generateName(component)));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SaveState(String stateName) {
        StiComponentsCollection stiComponentsCollection = this;
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : this) {
                comp.saveState(stateName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RestoreState(String stateName) {
        StiComponentsCollection stiComponentsCollection = this;
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : this) {
                comp.RestoreState(stateName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void ClearAllStates() {
        StiComponentsCollection stiComponentsCollection = this;
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : this) {
                comp.ClearAllStates();
            }
        }
    }

    public final void SortBySelectionTick() {
        Collections.sort(this, BY_SELECTION_TICK);
    }

    public final void SortByPriority() {
        Collections.sort(this, BY_PRIORITY);
    }

    public final void SortByTopPosition() {
        Collections.sort(this, BY_TOP);
    }

    public final void SortByBottomPosition() {
        Collections.sort(this, BY_BOTTOM);
    }

    public final void SortByLeftPosition() {
        Collections.sort(this, BY_LEFT);
    }

    public final void SortByRightPosition() {
        Collections.sort(this, BY_RIGHT);
    }

    public void sortBandsByLeftPosition() {
        if (this.size() > 1) {
            int pos = 1;
            while (pos < this.size()) {
                if (this.get(pos - 1) instanceof StiBand && this.get(pos) instanceof StiBand && ((StiComponent)this.get(pos - 1)).getLeft() > ((StiComponent)this.get(pos)).getLeft()) {
                    StiComponent swapComp = (StiComponent)this.get(pos - 1);
                    this.set(pos - 1, this.get(pos));
                    this.set(pos, swapComp);
                    if (pos == 1) continue;
                    --pos;
                    continue;
                }
                ++pos;
            }
        }
    }

    public void sortBandsByTopPosition() {
        if (this.size() > 1) {
            int pos = 1;
            while (pos < this.size()) {
                if (this.get(pos - 1) instanceof StiBand && this.get(pos) instanceof StiBand && ((StiComponent)this.get(pos - 1)).getDockStyle() == ((StiComponent)this.get(pos)).getDockStyle() && (((StiComponent)this.get(pos - 1)).getDockStyle() == StiDockStyle.Top && ((StiComponent)this.get(pos - 1)).getTop() > ((StiComponent)this.get(pos)).getTop() || ((StiComponent)this.get(pos - 1)).getDockStyle() == StiDockStyle.Bottom && ((StiComponent)this.get(pos - 1)).getTop() < ((StiComponent)this.get(pos)).getTop())) {
                    StiComponent swapComp = (StiComponent)this.get(pos - 1);
                    this.set(pos - 1, this.get(pos));
                    this.set(pos, swapComp);
                    if (pos == 1) continue;
                    --pos;
                    continue;
                }
                ++pos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StiComponent GetComponentByName(String componentName, StiContainer container) {
        if (componentName == null) {
            return null;
        }
        StiComponentsCollection stiComponentsCollection = container.getComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent component : container.getComponents()) {
                StiComponent comp;
                if (componentName.equals(component.getName())) {
                    return component;
                }
                StiContainer cont = (StiContainer)(component instanceof StiContainer ? component : null);
                if (cont == null || (comp = this.GetComponentByName(componentName, cont)) == null) continue;
                return comp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StiPage GetPageByAlias(String alias) {
        StiComponentsCollection stiComponentsCollection = this;
        synchronized (stiComponentsCollection) {
            for (StiComponent page : this) {
                if (!alias.equals(page.getAlias())) continue;
                return (StiPage)page;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void SetParent(StiContainer parent) {
        this.parent = parent;
        StiComponentsCollection stiComponentsCollection = this;
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : this) {
                comp.setParent(parent);
                StiContainer cont = (StiContainer)(comp instanceof StiContainer ? comp : null);
                if (cont == null) continue;
                cont.getComponents().SetParent(cont);
            }
        }
    }

    public StiComponent get(String name) {
        for (StiComponent element : this) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public void fillPage(StiPage page) {
        for (StiComponent component : this) {
            component.setPage(page);
        }
    }

    @Override
    public Object clone() {
        StiComponentsCollection result = new StiComponentsCollection();
        for (StiComponent component : this) {
            result.add((StiComponent)component.clone());
        }
        return result;
    }

    public void AddRange(StiComponentsCollection components) {
        this.addAll(components);
    }

    public void Clear() {
        this.clear();
    }
}

