/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.dialogs.StiForm;
import java.util.ArrayList;

public class StiPagesCollection
extends ArrayList<StiPage>
implements IStiJsonReportObject {
    private static final long serialVersionUID = 4550198464665112953L;
    private StiReport report;
    public boolean cacheMode;
    public boolean canUseCacheMode;
    public StiPagesCollection NotCachedPages;

    public StiPagesCollection() {
    }

    public StiPagesCollection(StiReport report) {
        this.report = report;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiPage page : this) {
            jObject.AddPropertyJObject(index.toString(), page.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            StiPage page = null;
            JSONObject propJObject = (JSONObject)property.Value;
            String ident = propJObject.Properties().FirstOrDefault((String)"Ident").Value.toString();
            if (ident.equals("StiPage")) {
                page = new StiPage();
            } else if (ident.equals("StiForm")) {
                page = new StiForm();
            }
            this.add(page);
            page.LoadFromJsonObject(propJObject);
        }
    }

    public boolean addPage(StiPage page) {
        if (this.report != null) {
            // empty if block
        }
        if (this.report != null && this.report.getIsDesigning() && StiValidationUtil.isNullOrEmpty((String)page.getName())) {
            page.setName(StiNameCreation.createName(this.report, StiNameCreation.generateName(page)));
        }
        if (StiValidationUtil.isNullOrEmpty((String)page.getName())) {
            if (this.report != null && this.report.getIsDesigning()) {
                page.setName(StiNameCreation.createName(this.report, StiNameCreation.generateName(page)));
            } else {
                page.setName(StiNameCreation.createSimpleName(this.report, StiNameCreation.generateName(page)));
            }
        }
        if (page.getReport() == null) {
            page.setReport(this.report);
        }
        return super.add(page);
    }

    @Override
    public boolean add(StiPage page) {
        if (page.getReport() == null) {
            page.setReport(this.report);
        }
        return super.add(page);
    }

    public void fillReport(StiReport report) {
        this.report = report;
        for (StiPage page : this) {
            page.setReport(report);
        }
    }

    public void fillPageInChildren() {
        for (StiPage page : this) {
            page.getComponents().fillPage(page);
        }
    }

    public boolean getCacheMode() {
        return this.cacheMode;
    }

    public Object NotCachedPages() {
        return null;
    }

    public void AddRange(StiPagesCollection pagesStore) {
        this.addAll(pagesStore);
    }

    public void addAll(StiPagesCollection pagesStore) {
        super.addAll(pagesStore);
    }

    public void GetPage(StiPage page) {
        if (this.report != null && !this.getCacheMode()) {
            return;
        }
        if (page.getComponents().size() != 0) {
            return;
        }
    }

    public StiPage get(String pageName) {
        for (StiPage page : this) {
            if (!page.getName().equals(pageName)) continue;
            return page;
        }
        return null;
    }

    public boolean IsNotSavedPage(StiPage page) {
        return false;
    }

    public void SavePage(StiPage page) {
    }

    public StiComponent GetComponentByName(String componentName) {
        for (StiPage page : this) {
            StiComponent comp = page.getComponents().GetComponentByName(componentName, page);
            if (comp == null) continue;
            return comp;
        }
        return null;
    }

    public StiReport getReport() {
        return this.report;
    }

    public void setCacheMode(boolean cacheMode) {
        this.cacheMode = cacheMode;
    }

    public void setReport(StiReport report) {
        this.report = report;
    }
}

