/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.StiAlignValue;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.bands.StiBandInfoV2;
import com.stimulsoft.report.components.bands.StiChildBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiEmptyBand;
import com.stimulsoft.report.components.bands.StiFooterBand;
import com.stimulsoft.report.components.bands.StiGroupFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.bands.StiOverlayBand;
import com.stimulsoft.report.components.bands.StiPageFooterBand;
import com.stimulsoft.report.components.bands.StiPageHeaderBand;
import com.stimulsoft.report.components.bands.StiReportSummaryBand;
import com.stimulsoft.report.components.bands.StiReportTitleBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiShiftMode;
import com.stimulsoft.report.components.interfaces.IStiResetPageNumber;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.dialogs.IStiReportControl;
import com.stimulsoft.report.engine.engineV2.builders.StiFooterBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiGroupFooterBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiGroupHeaderBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiHeaderBandV2Builder;

public abstract class StiBand
extends StiContainer
implements IStiResetPageNumber {
    private boolean resetPageNumber;
    private StiBandInfoV2 bandInfoV2;
    private StiRectangle rectangleMoveComponent = null;

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getResetPageNumber() {
        return this.resetPageNumber;
    }

    @Override
    public void setResetPageNumber(boolean value) {
        this.resetPageNumber = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
        super.setCanGrow(value);
    }

    @Override
    public String getQuickInfo() {
        switch (this.getReport().getInfo().getQuickInfoType()) {
            case ShowComponentsNames: {
                return "";
            }
        }
        return super.getQuickInfo();
    }

    @Override
    @StiSerializable(need=false)
    public boolean getGrowToHeight() {
        return super.getGrowToHeight();
    }

    @Override
    public void setGrowToHeight(boolean value) {
    }

    @Override
    @StiSerializable(need=false)
    public StiEnumSet<StiShiftMode> getShiftMode() {
        return StiEnumSet.of((Enum)StiShiftMode.None);
    }

    @Override
    public void setShiftMode(StiEnumSet<StiShiftMode> value) {
    }

    @Override
    public boolean canContainIn(StiComponent component) {
        if (component instanceof IStiReportControl) {
            return false;
        }
        if (this.getIsCross() && component instanceof StiBand) {
            return true;
        }
        if (this instanceof StiTable && component instanceof StiBand) {
            return true;
        }
        if (component instanceof StiBand) {
            return false;
        }
        boolean result = super.canContainIn(component);
        return result;
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.get((String)"Report", (String)"Bands");
    }

    @Override
    public StiComponentType getComponentType() {
        return StiComponentType.Master;
    }

    public final StiBandInfoV2 getBandInfoV2() {
        if (this.bandInfoV2 == null) {
            this.bandInfoV2 = new StiBandInfoV2();
        }
        return this.bandInfoV2;
    }

    @Override
    @StiSerializable(need=false)
    public boolean getPrintable() {
        return true;
    }

    @Override
    public void setPrintable(boolean value) {
    }

    @Override
    @StiSerializable(need=false)
    public StiDockStyle getDockStyle() {
        if (StiOptions.Engine.isDockPageFooterToBottom() && this instanceof StiPageFooterBand) {
            return StiDockStyle.Bottom;
        }
        return StiDockStyle.Top;
    }

    @Override
    public void setDockStyle(StiDockStyle value) {
    }

    @Override
    public boolean isAutomaticDock() {
        return true;
    }

    @Override
    @StiSerializable(need=false)
    public StiSize getMinSize() {
        return super.getMinSize();
    }

    @Override
    public void setMinSize(StiSize value) {
        super.setMinSize(value);
    }

    @Override
    @StiSerializable(need=false)
    public StiSize getMaxSize() {
        return super.getMaxSize();
    }

    @Override
    public void setMaxSize(StiSize value) {
        super.setMaxSize(value);
    }

    @StiDefaulValue(value="0.0")
    @StiSerializable
    public double getMinHeight() {
        return super.getMinSize().height;
    }

    public void setMinHeight(double value) {
        if (super.getMinSize().height != value) {
            super.setMinSize(new StiSize(0.0, value));
        }
    }

    @StiDefaulValue(value="0.0")
    @StiSerializable
    public double getMaxHeight() {
        return super.getMaxSize().height;
    }

    public void setMaxHeight(double value) {
        if (super.getMaxSize().height != value) {
            super.setMaxSize(new StiSize(0.0, value));
        }
    }

    @Override
    public double getLeft() {
        return super.getLeft();
    }

    @Override
    public void setLeft(double value) {
        super.setLeft(value);
    }

    @Override
    public double getTop() {
        return super.getTop();
    }

    @Override
    public void setTop(double value) {
        super.setTop(value);
    }

    @Override
    public double getWidth() {
        return super.getWidth();
    }

    @Override
    public void setWidth(double value) {
        super.setWidth(value);
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 300L, 30L);
    }

    @Override
    public StiRectangle getDisplayRectangle() {
        if (this.getReport() != null && this.getReport().getIsRendering()) {
            return new StiRectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        }
        double headerSize = this.getPage().getUnit().ConvertFromHInches(this.getHeaderSize());
        double footerSize = this.getPage().getUnit().ConvertFromHInches(this.getFooterSize());
        if (this.getReport() != null && !this.getReport().getInfo().getShowHeaders()) {
            headerSize = 0.0;
            footerSize = 0.0;
        }
        return new StiRectangle(this.getLeft(), this.getTop() - headerSize, this.getWidth(), this.getHeight() + headerSize + footerSize);
    }

    @Override
    public void setDisplayRectangle(StiRectangle value) {
        if (this.getReport() != null && this.getReport().getIsRendering()) {
            this.setLeft(value.getLeft());
            this.setTop(value.getTop());
            this.setWidth(value.getWidth());
            this.setHeight(value.getHeight());
        } else {
            double headerSize = this.getPage().getUnit().ConvertFromHInches(this.getHeaderSize());
            double footerSize = this.getPage().getUnit().ConvertFromHInches(this.getFooterSize());
            if (this.getReport() != null && !this.getReport().getInfo().getShowHeaders()) {
                headerSize = 0.0;
                footerSize = 0.0;
            }
            this.setLeft(value.getLeft());
            this.setTop(value.getTop() + headerSize);
            this.setWidth(value.getWidth());
            this.setHeight(value.getHeight() - headerSize - footerSize);
        }
    }

    @Override
    public void setDirectDisplayRectangle(StiRectangle rect) {
        this.setDisplayRectangle(rect);
    }

    @Override
    public StiRectangle getSelectRectangle() {
        double headerSize = this.getPage().getUnit().ConvertFromHInches(this.getHeaderSize());
        if (this.getDockStyle() == StiDockStyle.Left || this.getDockStyle() == StiDockStyle.Right) {
            return new StiRectangle(this.getLeft() - headerSize, this.getTop(), this.getWidth() + headerSize, this.getHeight());
        }
        return new StiRectangle(this.getLeft(), this.getTop() - headerSize, this.getWidth(), this.getHeight() + headerSize);
    }

    @Override
    public void setSelectRectangle(StiRectangle value) {
        double headerSize = this.getPage().getUnit().ConvertFromHInches(this.getHeaderSize());
        if (this.getDockStyle() == StiDockStyle.Left || this.getDockStyle() == StiDockStyle.Right) {
            this.setLeft(value.getLeft() + headerSize);
            this.setTop(value.getTop());
            this.setWidth(value.getWidth() - headerSize);
            this.setHeight(value.getHeight());
        } else {
            this.setLeft(value.getLeft());
            this.setTop(value.getTop() + headerSize);
            this.setWidth(value.getWidth());
            this.setHeight(value.getHeight() - headerSize);
        }
    }

    public final StiRectangle getRectangleMoveComponent() {
        return this.rectangleMoveComponent;
    }

    public final void setRectangleMoveComponent(StiRectangle value) {
        this.rectangleMoveComponent = value;
    }

    public String GetHeaderText() {
        return this.toString();
    }

    public abstract StiColor getHeaderStartColor();

    public abstract StiColor getHeaderEndColor();

    public double getHeaderSize() {
        if (this.getReport() != null && this.getReport().getInfo().getShowHeaders()) {
            return StiAlignValue.alignToMaxGrid((double)15.0, (double)this.getPage().getUnit().ConvertToHInches(this.getPage().getGridSize()), (boolean)true);
        }
        return 0.0;
    }

    public double getFooterSize() {
        if (this.getReport() != null && this.getReport().getInfo().getShowHeaders()) {
            return StiAlignValue.alignToMaxGrid((double)15.0, (double)this.getPage().getUnit().ConvertToHInches(this.getPage().getGridSize()), (boolean)true);
        }
        return 0.0;
    }

    public StiBand() {
        this(StiRectangle.empty());
    }

    public int getNestedLevel() {
        StiChildBand childBand;
        StiGroupFooterBand groupFooterBand;
        StiGroupHeaderBand groupHeaderBand;
        StiFooterBand footerBand;
        StiHeaderBand headerBand;
        StiDataBand dataBand;
        StiOverlayBand overlayBand;
        StiEmptyBand emptyBand;
        StiReportSummaryBand reportSummaryBand;
        StiReportTitleBand reportTitleBand;
        StiPageFooterBand pageFooterBand;
        StiPageHeaderBand pageHeaderBand;
        StiPageHeaderBand stiPageHeaderBand = pageHeaderBand = this instanceof StiPageHeaderBand ? (StiPageHeaderBand)this : null;
        if (pageHeaderBand != null) {
            int level = 1;
            for (StiComponent component : this.getPage().getComponents()) {
                if (component == pageHeaderBand) {
                    return level;
                }
                if (!(component instanceof StiPageHeaderBand)) continue;
                ++level;
            }
            return level;
        }
        StiPageFooterBand stiPageFooterBand = pageFooterBand = this instanceof StiPageFooterBand ? (StiPageFooterBand)this : null;
        if (pageFooterBand != null) {
            int level = 1;
            for (StiComponent component : this.getPage().getComponents()) {
                if (component == pageFooterBand) {
                    return level;
                }
                if (!(component instanceof StiPageFooterBand)) continue;
                ++level;
            }
            return level;
        }
        StiReportTitleBand stiReportTitleBand = reportTitleBand = this instanceof StiReportTitleBand ? (StiReportTitleBand)this : null;
        if (reportTitleBand != null) {
            int level = 1;
            for (StiComponent component : this.getPage().getComponents()) {
                if (component == reportTitleBand) {
                    return level;
                }
                if (!(component instanceof StiReportTitleBand)) continue;
                ++level;
            }
            return level;
        }
        StiReportSummaryBand stiReportSummaryBand = reportSummaryBand = this instanceof StiReportSummaryBand ? (StiReportSummaryBand)this : null;
        if (reportSummaryBand != null) {
            int level = 1;
            for (int index = this.getPage().getComponents().size() - 1; index >= 0; --index) {
                StiComponent component = (StiComponent)this.getPage().getComponents().get(index);
                if (component == reportSummaryBand) {
                    return level;
                }
                if (!(component instanceof StiReportSummaryBand)) continue;
                ++level;
            }
            return level;
        }
        StiEmptyBand stiEmptyBand = emptyBand = this instanceof StiEmptyBand ? (StiEmptyBand)this : null;
        if (emptyBand != null) {
            int level = 1;
            for (StiComponent component : this.getPage().getComponents()) {
                if (component == emptyBand) {
                    return level;
                }
                if (!(component instanceof StiEmptyBand)) continue;
                ++level;
            }
            return level;
        }
        StiOverlayBand stiOverlayBand = overlayBand = this instanceof StiOverlayBand ? (StiOverlayBand)this : null;
        if (overlayBand != null) {
            int level = 1;
            for (StiComponent component : this.getPage().getComponents()) {
                if (component == overlayBand) {
                    return level;
                }
                if (!(component instanceof StiOverlayBand)) continue;
                ++level;
            }
            return level;
        }
        StiDataBand stiDataBand = dataBand = this instanceof StiDataBand ? (StiDataBand)this : null;
        if (dataBand != null) {
            StiDataBand master = dataBand.getMasterComponent() instanceof StiDataBand ? (StiDataBand)dataBand.getMasterComponent() : null;
            int level = 1;
            while (master != null) {
                master = master.getMasterComponent() instanceof StiDataBand ? (StiDataBand)master.getMasterComponent() : null;
                ++level;
            }
            return level;
        }
        StiHeaderBand stiHeaderBand = headerBand = this instanceof StiHeaderBand ? (StiHeaderBand)this : null;
        if (headerBand != null) {
            StiDataBand master = StiHeaderBandV2Builder.GetMaster(headerBand);
            if (master == null) {
                return 1;
            }
            return master.getNestedLevel();
        }
        StiFooterBand stiFooterBand = footerBand = this instanceof StiFooterBand ? (StiFooterBand)this : null;
        if (footerBand != null) {
            StiDataBand master = StiFooterBandV2Builder.GetMaster(footerBand);
            if (master == null) {
                return 1;
            }
            return master.getNestedLevel();
        }
        StiGroupHeaderBand stiGroupHeaderBand = groupHeaderBand = this instanceof StiGroupHeaderBand ? (StiGroupHeaderBand)this : null;
        if (groupHeaderBand != null) {
            StiDataBand master = StiGroupHeaderBandV2Builder.getMaster(groupHeaderBand);
            if (master == null) {
                return 1;
            }
            return master.getNestedLevel();
        }
        StiGroupFooterBand stiGroupFooterBand = groupFooterBand = this instanceof StiGroupFooterBand ? (StiGroupFooterBand)this : null;
        if (groupFooterBand != null) {
            StiDataBand master = StiGroupFooterBandV2Builder.getMaster(groupFooterBand);
            if (master == null) {
                return 1;
            }
            return master.getNestedLevel();
        }
        StiChildBand stiChildBand = childBand = this instanceof StiChildBand ? (StiChildBand)this : null;
        if (childBand != null) {
            StiBand band = childBand.GetMaster();
            if (band == null) {
                return 1;
            }
            return band.getNestedLevel();
        }
        return 0;
    }

    public StiBand(StiRectangle rect) {
        super(rect);
        this.setCanGrow(true);
        this.setDockStyle(StiDockStyle.Top);
        this.setPlaceOnToolbox(false);
    }

    @Override
    public Object clone(boolean cloneProperties, boolean cloneComponents) {
        StiBand band = (StiBand)super.clone(cloneProperties, cloneComponents);
        band.bandInfoV2 = this.bandInfoV2 != null ? (StiBandInfoV2)this.bandInfoV2.clone() : null;
        return band;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("CanGrow", this.getCanGrow(), true);
        jObject.RemoveProperty("GrowToHeight");
        jObject.RemoveProperty("ShiftMode");
        jObject.RemoveProperty("Printable");
        jObject.RemoveProperty("DockStyle");
        jObject.RemoveProperty("MinSize");
        jObject.RemoveProperty("MaxSize");
        jObject.AddPropertyBool("ResetPageNumber", this.getResetPageNumber());
        jObject.AddPropertyDouble("MinHeight", this.getMinHeight(), 0.0);
        jObject.AddPropertyDouble("MaxHeight", this.getMaxHeight(), 0.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ResetPageNumber")) {
                this.resetPageNumber = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("MinHeight")) {
                this.setMinHeight(property.doubleValue());
                continue;
            }
            if (!property.Name.equals("MaxHeight")) continue;
            this.setMaxHeight(property.doubleValue());
        }
    }
}

