/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiDynamicBand;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.interfaces.IStiKeepReportSummaryTogether;
import com.stimulsoft.report.components.interfaces.IStiPrintIfEmpty;
import com.stimulsoft.report.dialogs.IStiReportControl;
import com.stimulsoft.report.engine.StiEngineVersion;

public class StiReportSummaryBand
extends StiDynamicBand
implements IStiPrintIfEmpty,
IStiKeepReportSummaryTogether {
    private boolean keepReportSummaryTogether = true;
    private boolean printIfEmpty = true;

    @Override
    public StiPrintOnType getPrintOn() {
        return super.getPrintOn();
    }

    @Override
    public void setPrintOn(StiPrintOnType value) {
        super.setPrintOn(value);
    }

    @Override
    @StiDefaulValue(value="true")
    public boolean getKeepReportSummaryTogether() {
        return this.keepReportSummaryTogether;
    }

    @Override
    public void setKeepReportSummaryTogether(boolean value) {
        if (this.keepReportSummaryTogether != value) {
            this.CheckBlockedException("KeepReportSummaryTogether");
            this.keepReportSummaryTogether = value;
        }
    }

    @Override
    @StiDefaulValue(value="true")
    public boolean getPrintIfEmpty() {
        return this.printIfEmpty;
    }

    @Override
    public void setPrintIfEmpty(boolean value) {
        this.printIfEmpty = value;
    }

    @Override
    public StiColor getHeaderStartColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.LightGreen);
    }

    @Override
    public StiColor getHeaderEndColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.MediumSeaGreen);
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.ReportSummaryBand.getValue();
    }

    @Override
    public boolean canContainIn(StiComponent component) {
        if (component instanceof IStiReportControl) {
            return false;
        }
        return component instanceof StiPage;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiReportSummaryBand");
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.ReportSummaryBand.getValue();
    }

    @Override
    public StiComponentType getComponentType() {
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
            return super.getComponentType();
        }
        return StiComponentType.Master;
    }

    public final StiComponent GetMaster() {
        for (StiComponent component : this.getParent().getComponents()) {
            if (!(component instanceof StiDataBand)) continue;
            return component;
        }
        return null;
    }

    public StiReportSummaryBand() {
        this(StiRectangle.empty());
    }

    public StiReportSummaryBand(StiRectangle rect) {
        super(rect);
        this.setDockStyle(StiDockStyle.Top);
        this.setPlaceOnToolbox(false);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("PrintOn");
        jObject.AddPropertyBool("KeepReportSummaryTogether", this.getKeepReportSummaryTogether(), true);
        jObject.AddPropertyBool("PrintIfEmpty", this.getPrintIfEmpty(), true);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("KeepReportSummaryTogether")) {
                this.keepReportSummaryTogether = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("PrintIfEmpty")) continue;
            this.printIfEmpty = (Boolean)property.Value;
        }
    }
}

