/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.complexcomponents;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiShiftMode;
import com.stimulsoft.report.components.interfaces.IStiAutoWidth;
import com.stimulsoft.report.components.interfaces.IStiHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextHorAlignment;
import com.stimulsoft.report.engine.StiEngineVersion;
import java.util.Hashtable;

public class StiContainerHelper {
    public static void checkSize(StiComponent component) {
        StiContainerHelper.CheckSize(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CheckSize(StiComponent component) {
        StiComponentsCollection compsSorted;
        StiContainer cont = (StiContainer)(component instanceof StiContainer ? component : null);
        if (cont == null) {
            return;
        }
        if (component.getReport() != null && component.getReport().getEngineVersion() == StiEngineVersion.EngineV1) {
            StiComponentsCollection stiComponentsCollection = cont.getComponents();
            synchronized (stiComponentsCollection) {
                for (StiComponent comp : cont.getComponents()) {
                    if (!comp.getIsEnabled()) continue;
                    StiContainerHelper.CheckSize(comp);
                }
            }
        }
        Hashtable<StiComponent, Double> compDist = new Hashtable<StiComponent, Double>();
        Hashtable<StiComponent, StiSize> compSizes = new Hashtable<StiComponent, StiSize>();
        boolean changedHeights = false;
        StiComponentsCollection stiComponentsCollection = cont.getComponents();
        synchronized (stiComponentsCollection) {
            for (IStiJsonReportObject comp : cont.getComponents()) {
                if (comp.getIsEnabled()) {
                    StiSize size;
                    if (comp instanceof StiContainer) {
                        double storedHeight = comp.getHeight();
                        if (StiOptions.Engine.getUseCheckSizeForContinuedContainers()) {
                            StiContainerHelper.CheckSize((StiComponent)comp);
                        }
                        boolean needSecondPass = false;
                        size = ((StiContainer)(comp instanceof StiContainer ? comp : null)).getActualSize(true, needSecondPass);
                        if (needSecondPass) {
                            double oldHeight = comp.getHeight();
                            comp.setHeight(size.height);
                            size = ((StiContainer)(comp instanceof StiContainer ? comp : null)).getActualSize(false, needSecondPass);
                            comp.setHeight(oldHeight);
                        }
                        if (StiOptions.Engine.getUseCheckSizeForContinuedContainers()) {
                            comp.setHeight(storedHeight);
                        }
                    } else {
                        size = comp.getActualSize();
                    }
                    compSizes.put((StiComponent)comp, size);
                    if (size.height == comp.getHeight()) continue;
                    changedHeights = true;
                    continue;
                }
                compSizes.put((StiComponent)comp, new StiSize(0, 0));
            }
        }
        if (changedHeights) {
            IStiJsonReportObject comp;
            compsSorted = new StiComponentsCollection();
            compsSorted.AddRange(cont.getComponents());
            compsSorted.SortByTopPosition();
            int index = 0;
            comp = compsSorted;
            synchronized (comp) {
                for (StiComponent comp2 : compsSorted) {
                    double dist = ((StiSize)compSizes.get((Object)comp2)).height - comp2.getHeight();
                    if (dist != 0.0) {
                        double parentDist = 0.0;
                        if (compDist.get(comp2) != null) {
                            parentDist = (Double)compDist.get(comp2);
                        }
                        for (int pos = index + 1; pos < compsSorted.size(); ++pos) {
                            StiComponent childComp = compsSorted.get(pos) instanceof StiComponent ? (StiComponent)compsSorted.get(pos) : null;
                            Double masterLeft = (double)Math.round(comp2.getLeft() * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
                            Double masterRight = (double)Math.round(comp2.getRight() * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
                            Double masterBottom = (double)Math.round(comp2.getBottom() * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
                            Double childLeft = (double)Math.round(childComp.getLeft() * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
                            Double childTop = (double)Math.round(childComp.top * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
                            if (childComp.getShiftMode().contains((IStiEnum)StiShiftMode.OnlyInWidthOfComponent) && (masterLeft.compareTo(childLeft) > 0 || masterRight.compareTo(childLeft) <= 0) || masterBottom.compareTo(childTop) > 0) continue;
                            double childDist = 0.0;
                            if (compDist.get(childComp) != null) {
                                childDist = (Double)compDist.get(childComp);
                            }
                            if (dist > 0.0 && childComp.getShiftMode().contains((IStiEnum)StiShiftMode.IncreasingSize)) {
                                compDist.put(childComp, Math.max(dist + parentDist, childDist));
                            }
                            if (!(dist < 0.0) || !childComp.getShiftMode().contains((IStiEnum)StiShiftMode.DecreasingSize)) continue;
                            compDist.put(childComp, Math.min(dist + parentDist, childDist));
                        }
                    }
                    ++index;
                }
            }
        }
        compsSorted = cont.getComponents();
        synchronized (compsSorted) {
            for (IStiJsonReportObject comp : cont.getComponents()) {
                StiSize newSize = (StiSize)compSizes.get(comp);
                IStiAutoWidth autoWidth = (IStiAutoWidth)(comp instanceof IStiAutoWidth ? comp : null);
                if (autoWidth != null && autoWidth.getAutoWidth()) {
                    IStiHorAlignment horAlignment;
                    StiHorAlignment align = StiHorAlignment.Left;
                    IStiTextHorAlignment textHorAlignment = (IStiTextHorAlignment)((Object)(autoWidth instanceof IStiTextHorAlignment ? autoWidth : null));
                    if (textHorAlignment != null) {
                        switch (textHorAlignment.getHorAlignment()) {
                            case Left: {
                                align = StiHorAlignment.Left;
                                break;
                            }
                            case Center: 
                            case Width: {
                                align = StiHorAlignment.Center;
                                break;
                            }
                            case Right: {
                                align = StiHorAlignment.Right;
                            }
                        }
                    }
                    if ((horAlignment = (IStiHorAlignment)((Object)(autoWidth instanceof IStiHorAlignment ? autoWidth : null))) != null) {
                        switch (horAlignment.getHorAlignment()) {
                            case Left: {
                                align = StiHorAlignment.Left;
                                break;
                            }
                            case Center: {
                                align = StiHorAlignment.Center;
                                break;
                            }
                            case Right: {
                                align = StiHorAlignment.Right;
                            }
                        }
                    }
                    double storedLeft = comp.getLeft();
                    switch (align) {
                        case Left: {
                            comp.width = newSize.width;
                            break;
                        }
                        case Center: {
                            double compWidth = newSize.width;
                            comp.setLeft(comp.getLeft() + (comp.width - compWidth) / 2.0);
                            comp.width = compWidth;
                            break;
                        }
                        case Right: {
                            double compWidth2 = newSize.width;
                            comp.setLeft(comp.getRight() - compWidth2);
                            comp.width = compWidth2;
                        }
                    }
                    if (storedLeft >= 0.0 && comp.getLeft() < 0.0) {
                        double tempCompWidth = comp.width;
                        comp.setLeft(0.0);
                        comp.width = tempCompWidth;
                    }
                }
                if (comp.getCanGrow()) {
                    comp.setWidth(Math.max(newSize.getWidth(), comp.getWidth()));
                    comp.setHeight(Math.max(newSize.getHeight(), comp.getHeight()));
                }
                if (comp.getCanShrink()) {
                    if (!(comp instanceof StiContainer) || !((StiContainer)comp).ParentComponentIsBand) {
                        comp.width = Math.min(newSize.width, comp.width);
                    }
                    comp.setHeight(Math.min(newSize.height, comp.getHeight()));
                }
                StiContainerHelper.CheckContainerGrowToHeight((StiComponent)comp);
                if (compDist.get(comp) == null) continue;
                comp.top += ((Double)compDist.get(comp)).doubleValue();
            }
        }
        if (StiContainerHelper.ComponentPlacedOnBand(cont) || cont.ParentComponentIsBand) {
            boolean needSecondPass = false;
            StiSize size = cont.getActualSize(true, needSecondPass);
            if (!cont.ParentComponentIsBand || cont.ParentComponentIsCrossBand) {
                cont.width = size.width;
            }
            cont.setHeight(size.height);
            if (needSecondPass) {
                size = cont.getActualSize(false, needSecondPass);
                if (!cont.ParentComponentIsBand || cont.ParentComponentIsCrossBand) {
                    cont.width = size.width;
                }
                cont.setHeight(size.height);
            }
            StiContainerHelper.CheckContainerGrowToHeight(cont);
        }
        if (cont instanceof StiPage && ((StiPage)(cont instanceof StiPage ? cont : null)).getUnlimitedHeight()) {
            StiPage page = (StiPage)(cont instanceof StiPage ? cont : null);
            boolean needSecondPass = false;
            StiSize size = cont.getActualSize(true, needSecondPass);
            while (size.height > page.getHeight()) {
                StiPage stiPage = page;
                Integer n = stiPage.segmentPerHeight;
                Integer n2 = stiPage.segmentPerHeight = Integer.valueOf(stiPage.segmentPerHeight + 1);
            }
        }
    }

    private static boolean ComponentPlacedOnBand(StiComponent component) {
        StiContainer parent = component.getParent();
        while (!(parent instanceof StiBand)) {
            if (parent instanceof StiPage) {
                return false;
            }
            if (parent == null) {
                return false;
            }
            if (parent.ParentComponentIsBand) {
                return true;
            }
            parent = parent.getParent();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CheckContainerGrowToHeight(StiComponent component) {
        StiContainer contGrowToHeight = (StiContainer)(component instanceof StiContainer ? component : null);
        if (contGrowToHeight != null) {
            StiComponentsCollection stiComponentsCollection = contGrowToHeight.getComponents();
            synchronized (stiComponentsCollection) {
                for (StiComponent comp : contGrowToHeight.getComponents()) {
                    if (!comp.getGrowToHeight() || !comp.getIsEnabled()) continue;
                    comp.setHeight(contGrowToHeight.getHeight() - comp.getTop());
                    StiContainerHelper.CheckContainerGrowToHeight(comp);
                }
            }
        }
    }
}

