/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.complexcomponents;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiParameter;
import com.stimulsoft.report.components.StiParametersCollection;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.conditions.StiConditionsCollection;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiShiftMode;
import com.stimulsoft.report.dialogs.IStiReportControl;
import com.stimulsoft.report.dialogs.StiReportControl;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.units.StiUnit;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;

public class StiSubReport
extends StiContainer {
    private static Logger LOG = Logger.getLogger("com.stimulsoft.report.components.complexcomponents.StiSubReport");
    private boolean useExternalReport = false;
    public boolean keepSubReportTogether = false;
    public String subReportPageGuid = null;
    private String subReportUrl;
    private StiParametersCollection parameters = new StiParametersCollection();

    public StiSubReport() {
        this(StiRectangle.empty());
    }

    public StiSubReport(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }

    @Override
    @StiSerializable(need=false)
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public void setCanShrink(boolean value) {
        super.setCanShrink(value);
    }

    @Override
    @StiSerializable(need=false)
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
        super.setCanGrow(value);
    }

    @Override
    public StiEnumSet<StiShiftMode> getShiftMode() {
        return super.getShiftMode();
    }

    @Override
    public void setShiftMode(StiEnumSet<StiShiftMode> value) {
        super.setShiftMode(value);
    }

    @Override
    @StiSerializable(need=false)
    public final StiConditionsCollection getConditions() {
        return super.getConditions();
    }

    @Override
    public final void setConditions(StiConditionsCollection value) {
        super.setConditions(value);
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.SubReport.getValue();
    }

    @Override
    public boolean canContainIn(StiComponent component) {
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV1) {
            if (component instanceof IStiReportControl) {
                return false;
            }
            if (component instanceof StiPage) {
                return true;
            }
            if (component instanceof StiDataBand) {
                return true;
            }
        } else {
            if (component instanceof StiReportControl) {
                return false;
            }
            if (component instanceof StiContainer) {
                return true;
            }
        }
        return false;
    }

    @Override
    public StiComponentType getComponentType() {
        return StiComponentType.Simple;
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Components");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiSubReport");
    }

    @Override
    @StiSerializable(need=false)
    public boolean getGrowToHeight() {
        return super.getGrowToHeight();
    }

    @Override
    public void setGrowToHeight(boolean value) {
    }

    @Override
    public int getPriority() {
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV1) {
            return StiComponentPriority.SubReportsV1.getValue();
        }
        return StiComponentPriority.SubReportsV2.getValue();
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
        this.setLeft(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getLeft())));
        this.setTop(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getTop())));
        super.setWidth(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getWidth())));
        this.setHeight(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getHeight())));
        this.setMinSize(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getMinSize())));
        this.setMaxSize(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getMaxSize())));
    }

    @Override
    public double getWidth() {
        return super.getWidth();
    }

    @Override
    public void setWidth(double value) {
        super.setWidth(value);
        this.UpdateSubReportPageWidth();
    }

    @Override
    public void setClientRectangle(StiRectangle value) {
        super.setClientRectangle(value);
        this.UpdateSubReportPageWidth();
    }

    private void UpdateSubReportPageWidth() {
        if (this.getSubReportPage() != null && this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
            if (this.getPage() != null && this.getSubReportPage().getOrientation() != this.getPage().getOrientation()) {
                double oldHeight = this.getSubReportPage().getPageHeight();
                this.getSubReportPage().setOrientation(this.getPage().getOrientation());
                this.getSubReportPage().setPageHeight(oldHeight);
                this.getSubReportPage().setMargins(new StiMargins(this.getSubReportPage().getMargins().getTop(), this.getSubReportPage().getMargins().getBottom(), this.getSubReportPage().getMargins().getLeft(), this.getSubReportPage().getMargins().getRight()));
            }
            this.getSubReportPage().setWidth(this.getWidth());
        }
    }

    @StiDefaulValue(value="false")
    @Deprecated
    public final boolean getUseExternalReport() {
        return this.useExternalReport;
    }

    @Deprecated
    public final void setUseExternalReport(boolean value) {
        this.useExternalReport = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getKeepSubReportTogether() {
        return this.keepSubReportTogether;
    }

    public void setKeepSubReportTogether(boolean value) {
        this.keepSubReportTogether = value;
    }

    public static StiSubReport GetSubReportForPage(StiPage page) {
        StiComponentsCollection comps = page.getReport().getComponents();
        for (StiComponent comp : comps) {
            if (!(comp instanceof StiSubReport) || ((StiSubReport)comp).getSubReportPage() != page) continue;
            return (StiSubReport)(comp instanceof StiSubReport ? comp : null);
        }
        return null;
    }

    @StiSerializable(need=false)
    public final StiPage getSubReportPage() {
        if (this.getReport() == null) {
            return null;
        }
        for (StiPage page : this.getReport().getPages()) {
            if (this.getSubReportPageGuid() == null || !this.getSubReportPageGuid().equals(page.getGuid())) continue;
            return page;
        }
        return null;
    }

    public final void setSubReportPage(StiPage value) {
        if (value == null) {
            this.subReportPageGuid = null;
        } else {
            if (value.getGuid() == null) {
                value.setGuid(StiGuid.newGuidString());
            }
            this.subReportPageGuid = value.getGuid();
            this.UpdateSubReportPageWidth();
        }
    }

    @StiSerializable
    public final String getSubReportPageGuid() {
        return this.subReportPageGuid;
    }

    public final void setSubReportPageGuid(String value) {
        this.subReportPageGuid = value;
    }

    @StiSerializable
    public String getSubReportUrl() {
        return this.subReportUrl;
    }

    public void setSubReportUrl(String subReportUrl) {
        this.subReportUrl = subReportUrl;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("CanGrow");
        jObject.RemoveProperty("Conditions");
        jObject.RemoveProperty("GrowToHeight");
        jObject.AddPropertyBool("KeepSubReportTogether", this.getKeepSubReportTogether());
        jObject.AddPropertyStringNullOfEmpty("SubReportPageGuid", this.getSubReportPageGuid());
        jObject.AddPropertyStringNullOfEmpty("SubReportUrl", this.getSubReportUrl());
        if (mode == StiJsonSaveMode.Report) {
            jObject.AddPropertyJObject("Parameters", this.getParameters().SaveToJsonObject(mode));
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("FillParametersEvent")) continue;
            if (property.Name.equals("KeepSubReportTogether")) {
                this.keepSubReportTogether = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("SubReportPageGuid")) {
                this.subReportPageGuid = (String)property.Value;
                continue;
            }
            if (property.Name.equals("SubReportUrl")) {
                this.subReportUrl = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("Parameters")) continue;
            this.parameters.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public void invokeFillParameters(StiComponent sender, HashMap<String, Object> e) {
        try {
            if (this.getReport() != null && this.getParameters() != null && this.getParameters().size() > 0) {
                for (StiParameter param : this.getParameters()) {
                    if (StiValidationUtil.isNullOrEmpty((String)param.getName()) || param.getExpression() == null || StiValidationUtil.isNullOrEmpty((String)param.getExpression().getValue())) continue;
                    Object parserResult = StiParser.ParseTextValue("{" + param.getExpression().getValue() + "}", this);
                    e.put(param.getName(), parserResult);
                }
            }
        }
        catch (Exception ex) {
            if (this.getReport() != null) {
                this.getReport().WriteToReportRenderingMessages(String.format("Expression in parameters of '%s' can't be evaluated! %s", this.getName(), ex.getMessage()));
            }
            LOG.warning(String.format("Expression in parameters of '%s' can't be evaluated! %s", this.getName(), ex.getMessage()));
        }
    }

    @StiSerializable
    public StiParametersCollection getParameters() {
        return this.parameters;
    }

    public void setParameters(StiParametersCollection parameters) {
        this.parameters = parameters;
    }

    protected StiReport getSubReportFromUrl(String url) {
        try {
            if (!StiValidationUtil.isNullOrEmpty((String)url)) {
                URL website = new URL(url);
                if (url.toLowerCase().endsWith(".mdc")) {
                    return StiSerializeManager.deserializeDocument(website.openStream()).getReport();
                }
                return StiSerializeManager.deserializeReport(website.openStream());
            }
        }
        catch (Exception ex) {
            if (this.getReport() != null) {
                this.getReport().WriteToReportRenderingMessages(String.format("SubReport can't be loaded from URL '%s' in subreport component %s!", url, this.getName()));
            }
            LOG.warning(String.format("SubReport can't be loaded from URL '%s' in subreport component %s!", url, this.getName()));
        }
        return null;
    }

    protected StiReport getSubReportFromFile(String file) {
        if (StiValidationUtil.isNotNullOrEmpty((String)file) && file.startsWith("file://")) {
            file = file.substring("file://".length());
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)file) && new File(file).exists()) {
            try {
                if (file.toLowerCase().endsWith(".mdc")) {
                    return StiSerializeManager.deserializeDocument(new File(file)).getReport();
                }
                return StiSerializeManager.deserializeReport(new File(file));
            }
            catch (Exception ex) {
                if (this.getReport() != null) {
                    this.getReport().WriteToReportRenderingMessages(String.format("SubReport can't be loaded from file '%s' in subreport component %s!", file, this.getName()));
                }
                LOG.warning(String.format("SubReport can't be loaded from file '%s' in subreport component %s!", file, this.getName()));
            }
        } else if (StiValidationUtil.isNotNullOrEmpty((String)file)) {
            if (this.getReport() != null) {
                this.getReport().WriteToReportRenderingMessages(String.format("File '%s' does not exist in subreport component %s!", file, this.getName()));
            }
            LOG.warning(String.format("File '%s' does not exist in subreport component %s!", file, this.getName()));
        }
        return null;
    }

    public StiReport getExternalSubReport() {
        StiReport externalReport = this.getSubReportFromUrl(this.subReportUrl);
        if (externalReport == null) {
            externalReport = this.getSubReportFromFile(this.subReportUrl);
        }
        if (externalReport != null && externalReport.getReportUnit() != this.getReport().getReportUnit()) {
            if (externalReport.isDocument) {
                for (StiPage page : externalReport.getRenderedPages()) {
                    page.convert(externalReport.getUnit(), this.getReport().getUnit());
                }
            } else {
                externalReport.setReportUnit(this.getReport().getReportUnit());
            }
        }
        return externalReport;
    }
}

