/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiImageProcessingDuplicatesType;
import com.stimulsoft.report.components.enums.StiImageRotation;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.interfaces.IStiGlobalizedName;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiView;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.events.StiEvent;
import com.stimulsoft.report.events.StiGetImageDataEvent;
import com.stimulsoft.report.events.StiGetImageDataEventArgs;
import com.stimulsoft.report.events.StiGetImageURLEvent;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.expressions.StiImageDataExpression;
import com.stimulsoft.report.expressions.StiImageURLExpression;
import com.stimulsoft.report.expressions.StiUnifiedExpression;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;

public class StiImage
extends StiView
implements IStiBreakable,
IStiGlobalizedName {
    private String globalizedName = "";
    protected static Object PropertyCanBreak = new Object();
    private Object imageURLValue;
    private static final Object EventGetImageURL = new Object();
    private static final Object EventGetImageData = new Object();
    protected static Object PropertyProcessingDuplicates = new Object();
    private StiImageRotation imageRotation = StiImageRotation.None;
    private String imageBytes;
    private String file = "";
    private String dataColumn = "";

    public StiImage() {
        this(StiRectangle.empty());
    }

    public StiImage(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    public StiImage(String image) {
        this.imageBytes = image;
    }

    public StiImage(byte[] bytes) {
        this.imageBytes = new String(bytes);
    }

    @Override
    public BufferedImage getBufferedImage(StiRectangle rect) {
        if (this.bufferedImage == null && this.imageBytesToDraw != null) {
            super.getBufferedImage(rect);
            if (this.imageRotation != StiImageRotation.None) {
                this.bufferedImage = this.rotateImage(this.bufferedImage);
            }
        }
        return this.bufferedImage;
    }

    public BufferedImage rotateImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        BufferedImage newImage = null;
        AffineTransform at = new AffineTransform();
        if (this.imageRotation.equals((Object)StiImageRotation.Rotate180)) {
            newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            at.translate(image.getWidth(), image.getHeight());
            at.scale(-1.0, -1.0);
            ((Graphics2D)newImage.getGraphics()).drawImage(image, at, null);
        } else if (this.imageRotation.equals((Object)StiImageRotation.Rotate90CW)) {
            newImage = new BufferedImage(image.getHeight(), image.getWidth(), 2);
            at.translate(image.getHeight(), 0.0);
            at.rotate(Math.toRadians(90.0));
        } else if (this.imageRotation.equals((Object)StiImageRotation.Rotate90CCW)) {
            newImage = new BufferedImage(image.getHeight(), image.getWidth(), 2);
            at.translate(0.0, image.getWidth());
            at.rotate(Math.toRadians(-90.0));
        } else if (this.imageRotation.equals((Object)StiImageRotation.FlipHorizontal)) {
            newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            at.scale(-1.0, 1.0);
            at.translate(-image.getWidth(), 0.0);
        } else if (this.imageRotation.equals((Object)StiImageRotation.FlipVertical)) {
            newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            at.scale(1.0, -1.0);
            at.translate(0.0, -image.getHeight());
        }
        newImage.createGraphics().drawImage(image, at, null);
        return newImage;
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public final String getGlobalizedName() {
        return this.globalizedName;
    }

    @Override
    public final void setGlobalizedName(String value) {
        this.globalizedName = value;
    }

    protected String getImageFromUrl() {
        String url = this.getImageURLValue() instanceof String ? (String)this.getImageURLValue() : null;
        try {
            if (StiValidationUtil.isNotNullOrEmpty((String)url)) {
                BufferedImage bi = ImageIO.read(new URL(url));
                return StiImageHelper.imageToBase64(bi, StiImageFormat.Png);
            }
        }
        catch (Exception ex) {
            if (this.getReport() != null) {
                String.format(StiValidationUtil.isNotNullOrEmpty((String)ex.getMessage()) ? ex.getMessage() : ex.getStackTrace()[0].toString(), new Object[0]);
            }
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getCanBreak() {
        return this.properties.getBool(PropertyCanBreak, false);
    }

    @Override
    public void setCanBreak(boolean value) {
        this.properties.setBool(PropertyCanBreak, value, false);
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.Image.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Components");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiImage");
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 100L, 100L);
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final Object getImageURLValue() {
        return this.imageURLValue;
    }

    public final void setImageURLValue(Object value) {
        if (this.imageURLValue != value) {
            this.imageURLValue = value;
            if (StiValidationUtil.isNullOrEmpty((String)this.getImageBytes()) && this.getReport() != null && this.getReport().getIsRendering() && value != null) {
                this.setImageBytesToDraw(this.getImageFromUrl());
            }
        }
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiImageURLExpression getImageURL() {
        return new StiImageURLExpression(this, "ImageURL");
    }

    public void setImageURL(StiImageURLExpression value) {
        if (value != null) {
            value.Set(this, "ImageURL", value.getValue());
        }
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiImageDataExpression getImageData() {
        return new StiImageDataExpression(this, "ImageData");
    }

    public void setImageData(StiImageDataExpression value) {
        if (value != null) {
            value.Set(this, "ImageData", value.getValue());
        }
    }

    @Override
    public void invokeEvents() {
        try {
            super.invokeEvents();
            if (this.getImageURLValue() == null || this.getImageURLValue() instanceof String && StiValidationUtil.isNullOrEmpty((String)((String)this.getImageURLValue()))) {
                StiValueEventArgs e = new StiValueEventArgs();
                this.invokeGetImageURL(this, e);
                this.setImageURLValue(e.getValue());
            }
        }
        catch (Exception e1) {
            if (this.getReport() != null) {
                String.format(StiValidationUtil.isNotNullOrEmpty((String)e1.getMessage()) ? e1.getMessage() : e1.getStackTrace()[0].toString(), new Object[0]);
            }
            e1.printStackTrace();
        }
    }

    protected void OnGetImageURL(StiValueEventArgs e) {
    }

    public void invokeGetImageURL(Object sender, StiValueEventArgs e) {
        block3: {
            try {
                Object parserResult = StiParser.ParseTextValue(this.getImageURL().getValue(), this);
                if (parserResult != null) {
                    e.setValue(parserResult.toString());
                }
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e1.printStackTrace();
            }
        }
    }

    @StiSerializable
    public StiGetImageURLEvent getGetImageURLEvent() {
        return new StiGetImageURLEvent(this);
    }

    public void setGetImageURLEvent(StiGetImageURLEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnGetImageData(StiGetImageDataEventArgs e) {
    }

    @StiSerializable
    public StiGetImageDataEvent getGetImageDataEvent() {
        return new StiGetImageDataEvent(this);
    }

    public void setGetImageDataEvent(StiGetImageDataEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public StiImageProcessingDuplicatesType getProcessingDuplicates() {
        return (StiImageProcessingDuplicatesType)((Object)this.properties.get(PropertyProcessingDuplicates, (Object)StiImageProcessingDuplicatesType.None));
    }

    public void setProcessingDuplicates(StiImageProcessingDuplicatesType value) {
        this.properties.set(PropertyProcessingDuplicates, (Object)value, (Object)StiImageProcessingDuplicatesType.None);
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public final StiImageRotation getImageRotation() {
        return this.imageRotation;
    }

    public final void setImageRotation(StiImageRotation value) {
        this.imageRotation = value;
        this.bufferedImage = null;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public final String getImage() {
        return null;
    }

    public final void setImage(String value) {
        this.setImageBytes(value);
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public final String getImageBytes() {
        return this.imageBytes;
    }

    public final void setImageBytes(String value) {
        if (value != null && value.indexOf(44) > 0) {
            value = value.substring(value.indexOf(44) + 1);
        }
        this.imageBytes = value;
        this.setImageBytesToDraw(this.imageBytes);
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getFile() {
        return this.file;
    }

    @Override
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public String getImageBytesToDraw() {
        String img = super.getImageBytesToDraw();
        if (img == null && StiValidationUtil.isNotNullOrEmpty((String)this.file)) {
            this.setImageBytesToDraw(this.getImageFromFile());
            return super.getImageBytesToDraw();
        }
        return img;
    }

    public final void setFile(String value) {
        if (!this.file.equals(value)) {
            this.file = value;
        }
    }

    protected String getImageFromFile() {
        File tempFile;
        if (StiValidationUtil.isNotNullOrEmpty((String)this.file) && (tempFile = new File(this.file)).exists()) {
            try {
                BufferedImage bi = ImageIO.read(tempFile);
                return StiImageHelper.imageToBase64(bi, StiImageFormat.Png);
            }
            catch (Exception ex) {
                if (this.getReport() != null) {
                    String.format(String.format("Image can't be loaded from file '%s' in image component %s!", this.file, this.getName()), new Object[0]);
                }
                System.out.println(String.format("Image can't be loaded from file '%s' in image component %s!", this.file, this.getName()));
                ex.printStackTrace();
            }
        }
        return null;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getDataColumn() {
        return this.dataColumn;
    }

    public final void setDataColumn(String value) {
        this.dataColumn = value;
    }

    @Override
    public boolean Break(StiComponent dividedComponent, double devideFactor, StiRefObject<Double> divideLine) {
        divideLine.argvalue = 0.0;
        boolean result = true;
        if (this.getImageBytesToDraw() != null) {
            // empty if block
        }
        return result;
    }

    @Override
    public String GetImageFromSource() {
        if (StiValidationUtil.isNotEmpty((String)this.getDataColumn())) {
            return this.getImageFromDataColumn();
        }
        return this.imageBytes;
    }

    protected String getImageFromDataColumn() {
        Object imageObject = StiDataColumn.GetDataFromDataColumn(this.getReport().dictionary, this.getDataColumn());
        StiImage image = StiImageHelper.getImageFromObject(imageObject);
        return image != null ? image.getImageBytes() : null;
    }

    public void setImage(StiImage image) {
        if (image == null) {
            this.setImageBytesToDraw(null);
            this.imageBytes = null;
        } else {
            this.setImageBytesToDraw(image.getImageBytes());
            this.imageBytes = image.getImageBytes();
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("GlobalizedName", this.getGlobalizedName());
        jObject.AddPropertyBool("CanBreak", this.getCanBreak());
        jObject.AddPropertyJObject("GetImageURLEvent", this.getGetImageURLEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetImageDataEvent", this.getGetImageDataEvent().SaveToJsonObject(mode));
        jObject.AddPropertyEnum("ProcessingDuplicates", (Enum)this.getProcessingDuplicates(), (Enum)StiImageProcessingDuplicatesType.None);
        jObject.AddPropertyEnum("ImageRotation", (Enum)this.getImageRotation(), (Enum)StiImageRotation.None);
        jObject.AddPropertyStringNullOfEmpty("File", this.getFile());
        jObject.AddPropertyStringNullOfEmpty("DataColumn", this.getDataColumn());
        if (mode == StiJsonSaveMode.Document) {
            jObject.AddPropertyStringNullOfEmpty("ImageURLValue", (String)this.getImageURLValue());
        } else {
            jObject.AddPropertyJObject("ImageURL", this.getImageURL().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("ImageData", this.getImageData().SaveToJsonObject(mode));
            jObject.put("ImageBytes", (Object)this.getImageBytes());
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            StiEvent _event;
            StiUnifiedExpression _expression;
            if (property.Name.equals("GlobalizedName")) {
                this.globalizedName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("CanBreak")) {
                this.setCanBreak((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("ImageURLValue")) {
                this.imageURLValue = property.Value;
                continue;
            }
            if (property.Name.equals("ImageURL")) {
                _expression = new StiImageURLExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setImageURL((StiImageURLExpression)_expression);
                continue;
            }
            if (property.Name.equals("ImageData")) {
                _expression = new StiImageDataExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setImageData((StiImageDataExpression)_expression);
                continue;
            }
            if (property.Name.equals("GetImageURLEvent")) {
                _event = new StiGetImageURLEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetImageURLEvent((StiGetImageURLEvent)_event);
                continue;
            }
            if (property.Name.equals("GetImageDataEvent")) {
                _event = new StiGetImageDataEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetImageDataEvent((StiGetImageDataEvent)_event);
                continue;
            }
            if (property.Name.equals("ProcessingDuplicates")) {
                this.setProcessingDuplicates(StiImageProcessingDuplicatesType.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("ImageRotation")) {
                this.imageRotation = StiImageRotation.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Image")) {
                this.setImageBytes((String)property.Value);
                continue;
            }
            if (property.Name.equals("ImageBytes")) {
                this.setImageBytes((String)property.Value);
                continue;
            }
            if (property.Name.equals("File")) {
                this.file = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("DataColumn")) continue;
            this.dataColumn = (String)property.Value;
        }
    }
}

