/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiProcessingDuplicatesType;
import com.stimulsoft.report.components.interfaces.IStiBackColor;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.simplecomponents.StiSimpleText;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DBNull;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.globalization.IStiGlobalizationProvider;
import com.stimulsoft.report.options.EngineOptions;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JTextPane;

public class StiRichText
extends StiSimpleText
implements IStiExportImageExtended,
IStiBreakable,
IStiBorder,
IStiGlobalizationProvider,
IStiBackColor {
    protected static Object PropertyCanBreak = new Object();
    private StiBorder border = new StiBorder();
    private Image image = null;
    private StiMargins margins = new StiMargins(0.0, 0.0, 0.0, 0.0);
    private Font defaultFont = null;
    private StiColor defaultColor = StiColor.Empty;
    private boolean wordWrap = true;
    private boolean detectUrls = true;
    private StiColor backColor = StiColor.White;
    private String dataColumn = "";
    private boolean fullConvertExpression = false;
    private boolean wysiwyg = false;

    public StiRichText() {
        this(StiRectangle.empty(), "");
    }

    public StiRichText(StiRectangle rect) {
        this(rect, "");
    }

    public StiRichText(StiRectangle rect, String text) {
        super(rect, text);
        this.setPlaceOnToolbox(false);
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return format != StiExportFormat.Text && format != StiExportFormat.Rtf && format != StiExportFormat.RtfFrame && format != StiExportFormat.RtfTable && format != StiExportFormat.RtfWinWord;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getCanBreak() {
        return this.properties().getBool(PropertyCanBreak, false);
    }

    @Override
    public void setCanBreak(boolean value) {
        this.properties().setBool(PropertyCanBreak, value, false);
    }

    @Override
    public Object clone() {
        StiRichText text = (StiRichText)super.clone();
        text.border = this.border != null ? (StiBorder)this.border.clone() : null;
        return text;
    }

    @Override
    public void setString(String propertyName, String value) {
        if (propertyName.equals("Text")) {
            this.SetTextInternal(value);
        } else if (propertyName.equals("ToolTip")) {
            this.getToolTip().setValue(value);
        } else if (propertyName.equals("Tag")) {
            this.getTag().setValue(value);
        } else if (propertyName.equals("Hyperlink")) {
            this.getHyperlink().setValue(value);
        } else {
            throw new IllegalArgumentException(String.format("Property with name %1$s", propertyName));
        }
    }

    @Override
    public String getString(String propertyName) {
        if (propertyName.equals("Tag")) {
            return this.getTag().getValue();
        }
        if (propertyName.equals("ToolTip")) {
            return this.getToolTip().getValue();
        }
        if (propertyName.equals("Hyperlink")) {
            return this.getHyperlink().getValue();
        }
        throw new IllegalArgumentException(String.format("Property with name %1$s", propertyName));
    }

    @Override
    public String[] getAllStrings() {
        ArrayList<String> strs = new ArrayList<String>();
        if (EngineOptions.Globalization.getAllowUseText()) {
            strs.add("Text");
        }
        if (EngineOptions.Globalization.getAllowUseTag()) {
            strs.add("Tag");
        }
        if (EngineOptions.Globalization.getAllowUseToolTip()) {
            strs.add("ToolTip");
        }
        if (EngineOptions.Globalization.getAllowUseHyperlink()) {
            strs.add("Hyperlink");
        }
        return strs.toArray(new String[0]);
    }

    @Override
    @StiSerializable(shortName="br")
    public final StiBorder getBorder() {
        return this.border;
    }

    @Override
    public final void setBorder(StiBorder value) {
        this.border = value;
    }

    @Override
    public final String getGlobalizedName() {
        return super.getGlobalizedName();
    }

    @Override
    public final void setGlobalizedName(String value) {
        super.setGlobalizedName(value);
    }

    @Override
    @StiSerializable(need=false)
    public StiPenStyle getLinesOfUnderline() {
        return super.getLinesOfUnderline();
    }

    @Override
    public void setLinesOfUnderline(StiPenStyle value) {
    }

    @Override
    public boolean getHideZeros() {
        return false;
    }

    @Override
    public void setHideZeros(boolean value) {
    }

    @Override
    public StiProcessingDuplicatesType getProcessingDuplicates() {
        return StiProcessingDuplicatesType.None;
    }

    @Override
    public void setProcessingDuplicates(StiProcessingDuplicatesType value) {
    }

    @Override
    public int getMaxNumberOfLines() {
        return 0;
    }

    @Override
    public void setMaxNumberOfLines(int value) {
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.RichText.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.get((String)"Components", (String)"StiRichText");
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.get((String)"Report", (String)"Components");
    }

    public final StiRectangle convertTextMargins(StiRectangle rect, boolean convert) {
        if (this.margins.isEmpty()) {
            return rect;
        }
        double zoom = this.getPage().getZoom();
        double marginsLeft = this.margins.getLeft();
        double marginsRight = this.margins.getRight();
        double marginsTop = this.margins.getTop();
        double marginsBottom = this.margins.getBottom();
        if (!convert) {
            zoom = 1.0;
        }
        if (marginsLeft != 0.0) {
            rect.setX(rect.getX() + marginsLeft * zoom);
            rect.setWidth(rect.getWidth() - marginsLeft * zoom);
        }
        if (marginsTop != 0.0) {
            rect.setY(rect.getY() + marginsTop * zoom);
            rect.setHeight(rect.getHeight() - marginsTop * zoom);
        }
        if (marginsRight != 0.0) {
            rect.setWidth(rect.getWidth() - marginsRight * zoom);
        }
        if (marginsBottom != 0.0) {
            rect.setHeight(rect.getHeight() - marginsBottom * zoom);
        }
        return rect;
    }

    public final Image getImage() {
        return this.image;
    }

    public final void setImage(Image value) {
        this.image = value;
    }

    @StiSerializable
    public StiMargins getMargins() {
        return this.margins;
    }

    public void setMargins(StiMargins value) {
        this.margins = value;
    }

    public final Font getDefaultFont() {
        return this.defaultFont;
    }

    public final void setDefaultFont(Font value) {
        this.defaultFont = value;
    }

    public final StiColor getDefaultColor() {
        return this.defaultColor;
    }

    public final void setDefaultColor(StiColor value) {
        this.defaultColor = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getWordWrap() {
        return this.wordWrap;
    }

    public void setWordWrap(boolean value) {
        this.wordWrap = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getDetectUrls() {
        return this.detectUrls;
    }

    public void setDetectUrls(boolean value) {
        this.detectUrls = value;
    }

    @Override
    @StiSerializable
    public final StiColor getBackColor() {
        return this.backColor;
    }

    @Override
    public final void setBackColor(StiColor value) {
        this.backColor = value;
    }

    private boolean ShouldSerializeBackColor() {
        return this.backColor != StiColor.White;
    }

    @StiSerializable
    public final String getDataColumn() {
        return this.dataColumn;
    }

    public final void setDataColumn(String value) {
        this.dataColumn = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getFullConvertExpression() {
        return this.fullConvertExpression;
    }

    public final void setFullConvertExpression(boolean value) {
        this.fullConvertExpression = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getWysiwyg() {
        return this.wysiwyg;
    }

    public final void setWysiwyg(boolean value) {
        this.wysiwyg = value;
    }

    @Override
    public void setTextInternal(String value) {
    }

    @Override
    public String SaveState() {
        return null;
    }

    @Override
    public boolean Break(StiComponent dividedComponent, double devideFactor, StiRefObject<Double> divideLine) {
        return false;
    }

    @Override
    public StiSize getActualSize() {
        if ((this.canGrow || this.canShrink) && StiOptions.Engine.getFullTrust()) {
            return this.GetActualSizeWin();
        }
        return new StiSize(this.getWidth(), this.getHeight());
    }

    private StiSize GetActualSizeWin() {
        JTextPane rtfPane = new JTextPane();
        rtfPane.setContentType("text/rtf");
        String decodeName = StiXMLConvert.decodeName((String)this.unpackRTF());
        rtfPane.setText(decodeName);
        Dimension preferredSize = rtfPane.getPreferredSize();
        return new StiSize(this.width, this.getReport().getUnit().ConvertFromHInches(preferredSize.getHeight()));
    }

    private static JTextPane getRTFPane() {
        JTextPane rtfPane = new JTextPane();
        rtfPane.setContentType("text/rtf");
        rtfPane.setEditable(false);
        rtfPane.setOpaque(false);
        rtfPane.setMargin(new Insets(0, 0, 0, 0));
        return rtfPane;
    }

    @Override
    public void InvokeGetValue(StiComponent sender, StiGetValueEventArgs e) {
        String rtfData = "";
        if (this.getDataColumn() != null && this.getDataColumn().length() > 0) {
            Object rtfObject;
            Object tempVar = StiDataColumn.GetDataFromDataColumn(this.getReport().getDictionary(), this.getDataColumn());
            Object object = rtfObject = tempVar instanceof String ? tempVar : null;
            if (rtfObject == DBNull.Value) {
                rtfObject = null;
            }
            if (rtfObject instanceof String) {
                rtfData = StiRichText.PackRtf((String)(rtfObject instanceof String ? rtfObject : null));
            }
        }
        if (rtfData != null && rtfData.length() > 0) {
            e.setValue(rtfData);
        } else {
            super.InvokeGetValue(sender, e);
        }
    }

    public String unpackRTF() {
        return this.getTextInternal().replaceAll("\\{", "\\\\{").replaceAll("}", "\\}").replaceAll("__LP__", "{").replaceAll("__RP__", "}");
    }

    public static String PackRtf(String str) {
        StringBuilder sb = new StringBuilder(str);
        StringBuilder ns = new StringBuilder();
        for (int index = 0; index < sb.length(); ++index) {
            char c = sb.charAt(index);
            if (c == '{' && (index == 0 || sb.charAt(index - 1) != '\\')) {
                ns = ns.append("__LP__");
                continue;
            }
            if (c == '}' && (index == 0 || sb.charAt(index - 1) != '\\')) {
                ns = ns.append("__RP__");
                continue;
            }
            if (c == '\u0000') continue;
            ns = ns.append(c);
        }
        String result = ns.toString();
        result = result.replace("\\{", "{");
        result = result.replace("\\}", "}");
        return result;
    }

    public String getDecodeText() {
        return StiXMLConvert.decodeName((String)this.getTextInternal());
    }

    public String getRtfText() {
        return StiXMLConvert.decodeName((String)this.unpackRTF());
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("GlobalizedName");
        jObject.RemoveProperty("LinesOfUnderline");
        jObject.RemoveProperty("HideZeros");
        jObject.RemoveProperty("ProcessingDuplicates");
        jObject.RemoveProperty("MaxNumberOfLines");
        jObject.AddPropertyBool("CanBreak", this.getCanBreak(), false);
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.getBorder()));
        jObject.AddPropertyJObject("Margins", this.getMargins().SaveToJsonObject(mode, 0.0, 0.0, 0.0, 0.0));
        jObject.AddPropertyBool("WordWrap", this.getWordWrap(), true);
        jObject.AddPropertyBool("DetectUrls", this.getDetectUrls(), true);
        jObject.AddPropertyStringNullOfEmpty("BackColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getBackColor(), (StiColorEnum)StiColorEnum.White));
        jObject.AddPropertyStringNullOfEmpty("DataColumn", this.getDataColumn());
        jObject.AddPropertyBool("FullConvertExpression", this.getFullConvertExpression());
        jObject.AddPropertyBool("Wysiwyg", this.getWysiwyg());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("CanBreak")) {
                this.setCanBreak((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Border")) {
                this.setBorder(StiJsonReportObjectHelper.Deserialize.Border((JProperty)property));
                continue;
            }
            if (property.Name.equals("GetDataUrlEvent")) continue;
            if (property.Name.equals("Margins")) {
                this.margins.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("WordWrap")) {
                this.wordWrap = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("DetectUrls")) {
                this.detectUrls = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("BackColor")) {
                this.backColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("DataColumn")) {
                this.dataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("DataUrl")) continue;
            if (property.Name.equals("FullConvertExpression")) {
                this.fullConvertExpression = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Wysiwyg")) {
                this.wysiwyg = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("RightToLeft")) continue;
        }
    }
}

