/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiAdvancedBorder;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBreakText;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToAttributes;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentDivider;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.StiStandardTextRenderer;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiSystemTextType;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.indicators.StiIndicator;
import com.stimulsoft.report.components.interfaces.IStiAutoWidth;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiIndicator;
import com.stimulsoft.report.components.interfaces.IStiPrintOn;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.interfaces.IStiTextFormat;
import com.stimulsoft.report.components.interfaces.IStiTextHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.components.interfaces.IStiVertAlignment;
import com.stimulsoft.report.components.simplecomponents.StiSimpleText;
import com.stimulsoft.report.components.textFormats.StiCurrencyFormatService;
import com.stimulsoft.report.components.textFormats.StiDateFormatService;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.components.textFormats.StiGeneralFormatService;
import com.stimulsoft.report.components.textFormats.StiNumberFormatService;
import com.stimulsoft.report.components.textFormats.StiPercentageFormatService;
import com.stimulsoft.report.components.textFormats.StiTimeFormatService;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.events.StiGetExcelValueEvent;
import com.stimulsoft.report.events.StiGetExcelValueEventArgs;
import com.stimulsoft.report.expressions.StiExcelValueExpression;
import com.stimulsoft.report.expressions.StiExpression;
import com.stimulsoft.report.globalization.IStiGlobalizationProvider;
import com.stimulsoft.report.options.EngineOptions;
import com.stimulsoft.report.options.ExportOptions;
import com.stimulsoft.report.units.StiUnit;
import java.util.ArrayList;

public class StiText
extends StiSimpleText
implements IStiTextOptions,
IStiAutoWidth,
IStiTextHorAlignment,
IStiVertAlignment,
IStiBorder,
IStiFont,
IStiBrush,
IStiTextBrush,
IStiTextFormat,
IStiSerializable,
IStiSerializableToAttributes,
IStiBreakable,
IStiExportImageExtended,
IStiPrintOn,
IStiIndicator,
Cloneable,
IStiGlobalizationProvider {
    protected static Object PropertyCanBreak = new Object();
    protected static Object PropertyAutoWidth = new Object();
    protected static Object PropertyRenderTo = new Object();
    private StiIndicator indicator;
    private StiTextHorAlignment horAlignment = StiTextHorAlignment.Left;
    private StiVertAlignment vertAlignment = StiVertAlignment.Top;
    public StiFont font = new StiFont("Arial", 8.0);
    private StiBorder border = new StiBorder();
    private StiBrush brush = new StiSolidBrush(StiColor.Transparent);
    private StiBrush textBrush = new StiSolidBrush(StiColor.Black);
    private StiFormatService textFormat = StiGeneralFormatService.Default;
    private String format = "";
    private StiTextOptions textOptions = new StiTextOptions();
    private String excelDataValue;
    private static final Object EventGetExcelValue = new Object();
    protected static Object PropertyNullValue = new Object();
    protected static Object PropertyType = new Object();
    protected static Object PropertyExportAsImage = new Object();
    protected static Object PropertyTextQuality = new Object();
    protected static Object PropertyAllowHtmlTags = new Object();
    protected static Object PropertyMargins = new Object();
    protected static Object PropertyShrinkFontToFit = new Object();
    protected static Object PropertyShrinkFontToFitMinimumSize = new Object();

    @Override
    public boolean Break(StiComponent dividedComponent, double devideFactor, StiRefObject<Double> divideLine) {
        divideLine.argvalue = 0.0;
        boolean result = true;
        if (this.getTextInternal() != null && this.getTextInternal().length() > 0) {
            String breakValue = this.getTextInternal();
            StiRectangle rect = this.getReport().getUnit().ConvertToHInches(this.getClientRectangle());
            rect = this.convertTextMargins(rect, false);
            rect = this.convertTextBorders(rect, false);
            String str = "";
            if (rect.getHeight() >= 0.0) {
                StiBreakText breakText = StiComponentDivider.BreakText(this.getMeasureGraphics(), rect, breakValue, this.getFont(), this.getTextOptions(), this.getTextQuality(), this.getAllowHtmlTags(), this);
                str = breakText.getPlacedString();
                breakValue = breakText.getNotPlacedString();
            }
            this.SetTextInternal(str);
            if (!(this.getGrowToHeight() || this.getTextInternal() != null && this.getTextInternal().length() != 0)) {
                result = false;
            }
            ((StiText)dividedComponent).SetTextInternal(breakValue);
        }
        return result;
    }

    @StiSerializable(shortName="indicator")
    public StiIndicator getIndicator() {
        return this.indicator;
    }

    public void setIndicator(StiIndicator value) {
        this.indicator = value;
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        boolean nativeExport;
        if (this.indicator != null) {
            return true;
        }
        boolean result = super.isExportAsImage(format);
        if (result) {
            return result;
        }
        if (this.getAllowHtmlTags()) {
            boolean bl = nativeExport = format == StiExportFormat.Html || format == StiExportFormat.HtmlDiv || format == StiExportFormat.HtmlSpan || format == StiExportFormat.HtmlTable || format == StiExportFormat.Rtf || format == StiExportFormat.RtfTabbedText || format == StiExportFormat.RtfFrame || format == StiExportFormat.RtfWinWord || format == StiExportFormat.RtfTable || format == StiExportFormat.Text || format == StiExportFormat.Excel2007 || format == StiExportFormat.Word2007 && !ExportOptions.Word2007.getRenderHtmlTagsAsImage() || format == StiExportFormat.Excel2007 && !ExportOptions.Excel2007.isRenderHtmlTagsAsImage();
            if (!nativeExport) {
                return true;
            }
        }
        if (this.getLinesOfUnderlining()) {
            boolean bl = nativeExport = format == StiExportFormat.Dif || format == StiExportFormat.Pdf || format == StiExportFormat.Sylk || format == StiExportFormat.Text;
            if (!nativeExport) {
                return true;
            }
        }
        return this.getExportAsImage();
    }

    @Override
    public void setString(String propertyName, String value) {
        if (propertyName.equals("Text")) {
            this.SetTextInternal(value);
        } else if (propertyName.equals("ToolTip")) {
            this.getToolTip().setValue(value);
        } else if (propertyName.equals("Tag")) {
            this.getTag().setValue(value);
        } else if (propertyName.equals("Hyperlink")) {
            this.getHyperlink().setValue(value);
        } else {
            throw new IllegalArgumentException(String.format("Property with name %1$s", propertyName));
        }
    }

    @Override
    public String getString(String propertyName) {
        if (propertyName.equals("Text")) {
            return this.getTextInternal();
        }
        if (propertyName.equals("Tag")) {
            return this.getTag().getValue();
        }
        if (propertyName.equals("ToolTip")) {
            return this.getToolTip().getValue();
        }
        if (propertyName.equals("Hyperlink")) {
            return this.getHyperlink().getValue();
        }
        throw new IllegalArgumentException(String.format("Property with name %1$s", propertyName));
    }

    @Override
    public String[] getAllStrings() {
        ArrayList<String> strs = new ArrayList<String>();
        if (EngineOptions.Globalization.getAllowUseText()) {
            strs.add("Text");
        }
        if (EngineOptions.Globalization.getAllowUseTag()) {
            strs.add("Tag");
        }
        if (EngineOptions.Globalization.getAllowUseToolTip()) {
            strs.add("ToolTip");
        }
        if (EngineOptions.Globalization.getAllowUseHyperlink()) {
            strs.add("Hyperlink");
        }
        return strs.toArray(new String[0]);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getCanBreak() {
        return this.properties().getBool(PropertyCanBreak, false);
    }

    @Override
    public void setCanBreak(boolean value) {
        this.properties().setBool(PropertyCanBreak, value, false);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getAutoWidth() {
        return this.properties().getBool(PropertyAutoWidth, false);
    }

    @Override
    public void setAutoWidth(boolean value) {
        this.properties().setBool(PropertyAutoWidth, value, false);
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public String getRenderTo() {
        Object tempVar = this.properties().get(PropertyRenderTo, (Object)"");
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    public void setRenderTo(String value) {
        this.properties().set(PropertyRenderTo, (Object)value.intern(), (Object)"");
    }

    @Override
    public void InvokeRenderTo(StiSimpleText textFrom) {
        StiComponent findComponent;
        StiSimpleText textTo;
        if (!textFrom.isPropertyPresent(PropertyRenderTo)) {
            return;
        }
        String renderTo = ((StiText)textFrom).getRenderTo();
        if (renderTo.length() > 0 && (renderTo = renderTo.trim()).length() > 0 && (textTo = (StiSimpleText)((findComponent = textFrom.getParent().getComponents().get(renderTo)) instanceof StiSimpleText ? findComponent : null)) != null) {
            String visibleText;
            String textStr = textFrom.getTextInternal();
            if (textStr == null) {
                textStr = "";
            }
            if ((visibleText = this.GetVisibleTextForRenderTo(this.getMeasureGraphics(), textFrom.getPaintRectangle(true, false, true), textStr, (StiText)(textFrom instanceof StiText ? textFrom : null))) == null || visibleText.length() == 0) {
                visibleText = " ";
            }
            textFrom.setTextValue(visibleText);
            textFrom.SetTextInternal(visibleText);
            textTo.setTextValue(textStr);
            textTo.SetTextInternal(textStr);
            this.InvokeRenderTo(textTo);
        }
    }

    private String GetVisibleTextForRenderTo(StiGraphics g, StiRectangle rect, String text, StiText checkedText) {
        return null;
    }

    @StiDefaulValue(value="false")
    public boolean getWYSIWYG() {
        return this.getTextQuality() == StiTextQuality.Wysiwyg;
    }

    public void setWYSIWYG(boolean value) {
        if (value) {
            this.setTextQuality(StiTextQuality.Typographic);
        } else {
            this.setTextQuality(StiTextQuality.Standard);
        }
    }

    @Override
    @StiSerializable(shortName="ha")
    @StiDefaulValue(value="Left")
    public StiTextHorAlignment getHorAlignment() {
        return this.horAlignment;
    }

    @Override
    public void setHorAlignment(StiTextHorAlignment value) {
        this.horAlignment = value;
    }

    @Override
    @StiSerializable(shortName="va")
    @StiDefaulValue(value="Top")
    public StiVertAlignment getVertAlignment() {
        return this.vertAlignment;
    }

    @Override
    public void setVertAlignment(StiVertAlignment value) {
        this.vertAlignment = value;
    }

    @Override
    @StiSerializable(shortName="fn")
    public StiFont getFont() {
        return this.font;
    }

    @Override
    public void setFont(StiFont value) {
        this.font = value;
    }

    @Override
    @StiSerializable(shortName="br")
    public final StiBorder getBorder() {
        return this.border;
    }

    @Override
    public final void setBorder(StiBorder value) {
        this.border = value;
    }

    @Override
    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    @StiSerializable(shortName="tb")
    public StiBrush getTextBrush() {
        return this.textBrush;
    }

    @Override
    public void setTextBrush(StiBrush value) {
        this.textBrush = value;
    }

    @Override
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    @StiDefaulValue(value="")
    public StiFormatService getTextFormat() {
        if (this.textFormat == null) {
            return StiGeneralFormatService.Default;
        }
        return this.textFormat;
    }

    @Override
    public void setTextFormat(StiFormatService value) {
        if (value instanceof StiGeneralFormatService) {
            value = null;
        }
        if (this.textFormat != value) {
            this.textFormat = value;
            if (value == null) {
                this.format = "G";
            } else if (value instanceof StiPercentageFormatService) {
                StiPercentageFormatService percentageFormat = (StiPercentageFormatService)(value instanceof StiPercentageFormatService ? value : null);
                this.format = percentageFormat.getUseLocalSetting() ? "P" : "P" + percentageFormat.getDecimalDigits();
            } else if (value instanceof StiCurrencyFormatService) {
                StiCurrencyFormatService currencyFormat = (StiCurrencyFormatService)(value instanceof StiCurrencyFormatService ? value : null);
                if (currencyFormat.getUseLocalSetting()) {
                    this.format = "C";
                } else {
                    this.format = "C" + currencyFormat.getDecimalDigits();
                    if (currencyFormat.getUseGroupSeparator()) {
                        this.format = this.format + "G";
                    }
                    if (currencyFormat.getNegativePattern() == 0 || currencyFormat.getNegativePattern() == 4 || currencyFormat.getNegativePattern() == 14 || currencyFormat.getNegativePattern() == 15) {
                        this.format = this.format + "(";
                    }
                    this.format = currencyFormat.getPositivePattern() == 0 || currencyFormat.getPositivePattern() == 2 ? this.format + "+" : this.format + "-";
                    this.format = this.format + currencyFormat.getSymbol();
                }
            } else if (value instanceof StiDateFormatService) {
                this.format = "D";
            } else if (value instanceof StiNumberFormatService) {
                StiNumberFormatService numberFormat = (StiNumberFormatService)(value instanceof StiNumberFormatService ? value : null);
                if (numberFormat.getUseLocalSetting()) {
                    this.format = "N";
                } else {
                    this.format = "N" + numberFormat.getDecimalDigits();
                    if (numberFormat.getUseGroupSeparator()) {
                        this.format = this.format + "G";
                    }
                    if (numberFormat.getNegativePattern() == 0) {
                        this.format = this.format + "(";
                    }
                }
            } else {
                this.format = value instanceof StiTimeFormatService ? "T" : "";
            }
        }
    }

    @StiDefaulValue(value="")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument, shortName="format")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        if (!this.format.equals(value)) {
            this.format = value.intern();
        }
    }

    @Override
    @StiSerializable(shortName="to")
    public StiTextOptions getTextOptions() {
        return this.textOptions;
    }

    @Override
    public void setTextOptions(StiTextOptions value) {
        this.textOptions = value;
    }

    public final StiRectangle convertTextMargins(StiRectangle rect, boolean convert) {
        if (this.getMargins().isEmpty()) {
            return rect;
        }
        double zoom = this.getPage().getZoom();
        double marginsLeft = this.getMargins().getLeft();
        double marginsRight = this.getMargins().getRight();
        double marginsTop = this.getMargins().getTop();
        double marginsBottom = this.getMargins().getBottom();
        if (!convert) {
            zoom = 1.0;
        }
        if (marginsLeft != 0.0) {
            rect.setX(rect.getX() + marginsLeft * zoom);
            rect.setWidth(rect.getWidth() - marginsLeft * zoom);
        }
        if (marginsTop != 0.0) {
            rect.setY(rect.getY() + marginsTop * zoom);
            rect.setHeight(rect.getHeight() - marginsTop * zoom);
        }
        if (marginsRight != 0.0) {
            rect.setWidth(rect.getWidth() - marginsRight * zoom);
        }
        if (marginsBottom != 0.0) {
            rect.setHeight(rect.getHeight() - marginsBottom * zoom);
        }
        return rect;
    }

    public final StiRectangle convertTextBorders(StiRectangle rect, boolean convert) {
        double borderSizeLeft;
        double borderSizeRight = borderSizeLeft = this.getBorder().getSize() / 2.0;
        double borderSizeTop = borderSizeLeft;
        double borderSizeBottom = borderSizeLeft;
        StiBorder tempVar = this.getBorder();
        StiAdvancedBorder advBorder = (StiAdvancedBorder)(tempVar instanceof StiAdvancedBorder ? tempVar : null);
        if (advBorder != null) {
            borderSizeLeft = advBorder.getLeftSide().getSize() / 2.0;
            borderSizeRight = advBorder.getRightSide().getSize() / 2.0;
            borderSizeTop = advBorder.getTopSide().getSize() / 2.0;
            borderSizeBottom = advBorder.getBottomSide().getSize() / 2.0;
        }
        if (convert) {
            float zoom = (float)this.getPage().getZoom();
            borderSizeLeft *= (double)zoom;
            borderSizeRight *= (double)zoom;
            borderSizeTop *= (double)zoom;
            borderSizeBottom *= (double)zoom;
        }
        rect.setX(rect.getX() + borderSizeLeft);
        rect.setY(rect.getY() + borderSizeTop);
        rect.setWidth(rect.getWidth() - borderSizeLeft - borderSizeRight);
        rect.setHeight(rect.getHeight() - borderSizeTop - borderSizeBottom);
        return rect;
    }

    @Override
    public void packService() {
        super.packService();
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.Text.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.get((String)"Report", (String)"Components");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.get((String)"Components", (String)"StiText");
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument, shortName="excelvalue")
    public final String getExcelDataValue() {
        return this.excelDataValue;
    }

    public final void setExcelDataValue(String value) {
        this.excelDataValue = value;
    }

    @StiSerializable
    public StiExcelValueExpression getExcelValue() {
        return new StiExcelValueExpression(this, "ExcelValue");
    }

    public void setExcelValue(StiExcelValueExpression value) {
        if (value != null) {
            value.set(this, "ExcelValue", value.getValue());
        }
    }

    @Override
    public void invokeEvents() {
        super.invokeEvents();
    }

    protected void OnGetExcelValue(StiGetExcelValueEventArgs e) {
    }

    @StiSerializable
    public final StiGetExcelValueEvent getGetExcelValueEvent() {
        return new StiGetExcelValueEvent(this);
    }

    public final void setGetExcelValueEvent(StiGetExcelValueEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getNullValue() {
        Object tempVar = this.properties().get(PropertyNullValue, (Object)"");
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    public final void setNullValue(String value) {
        this.properties().set(PropertyNullValue, (Object)value, (Object)"");
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    @StiDefaulValue(value="None")
    public final StiSystemTextType getType() {
        return (StiSystemTextType)((Object)this.properties().get(PropertyType, (Object)StiSystemTextType.None));
    }

    public final void setType(StiSystemTextType value) {
        this.properties().set(PropertyType, (Object)value, (Object)StiSystemTextType.None);
    }

    @StiDefaulValue(value="false")
    public boolean getWordWrap() {
        return this.getTextOptions().getWordWrap();
    }

    public void setWordWrap(boolean value) {
        this.getTextOptions().setWordWrap(value);
    }

    @StiDefaulValue(value="0.0")
    public float getAngle() {
        return this.getTextOptions().getAngle();
    }

    public void setAngle(float value) {
        this.getTextOptions().setAngle(value);
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getExportAsImage() {
        return this.properties().getBool(PropertyExportAsImage, false);
    }

    public void setExportAsImage(boolean value) {
        this.properties().setBool(PropertyExportAsImage, value, false);
    }

    @StiSerializable(shortName="tq")
    @StiDefaulValue(value="Standard")
    public StiTextQuality getTextQuality() {
        return (StiTextQuality)((Object)this.properties().get(PropertyTextQuality, (Object)StiTextQuality.Standard));
    }

    public void setTextQuality(StiTextQuality value) {
        this.properties().set(PropertyTextQuality, (Object)value, (Object)StiTextQuality.Standard);
    }

    @StiSerializable(shortName="html")
    @StiDefaulValue(value="false")
    public boolean getAllowHtmlTags() {
        return this.properties().getBool(PropertyAllowHtmlTags, false);
    }

    public void setAllowHtmlTags(boolean value) {
        this.properties().setBool(PropertyAllowHtmlTags, value, false);
        if (value) {
            this.setTextQuality(StiTextQuality.Wysiwyg);
        }
    }

    @StiSerializable(shortName="mr")
    public StiMargins getMargins() {
        return (StiMargins)this.properties().get(PropertyMargins, (Object)StiMargins.Empty);
    }

    public void setMargins(StiMargins value) {
        this.properties().set(PropertyMargins, (Object)value, (Object)StiMargins.Empty);
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getShrinkFontToFit() {
        return this.properties().getBool(PropertyShrinkFontToFit, false);
    }

    public void setShrinkFontToFit(boolean value) {
        this.properties().setBool(PropertyShrinkFontToFit, value, false);
    }

    @StiSerializable
    @StiDefaulValue(value="1.0")
    public float getShrinkFontToFitMinimumSize() {
        return this.properties().getFloat(PropertyShrinkFontToFitMinimumSize, 1.0f);
    }

    public void setShrinkFontToFitMinimumSize(float value) {
        if (value >= 1.0f) {
            this.properties().setFloat(PropertyShrinkFontToFitMinimumSize, value, 1.0f);
        }
    }

    public final StiFont getActualFont(String text) {
        return null;
    }

    public final StiFont getActualFont(StiExpression text, float minFontSize) {
        return this.getActualFont(text.getValue(), minFontSize);
    }

    public final StiFont getActualFont(String text, float minFontSize) {
        boolean stop = false;
        StiFont font = this.getFont();
        StiRectangle rect = this.getPage().getUnit().ConvertToHInches(this.getClientRectangle());
        rect = this.convertTextMargins(rect, false);
        rect = this.convertTextBorders(rect, false);
        rect.width -= this.getBorder().getSize();
        double thisWidth = this.getPage().getUnit().ConvertToHInches(this.width) - this.getMargins().getLeft() - this.getMargins().getRight();
        double thisHeight = this.getPage().getUnit().ConvertToHInches(this.getHeight()) - this.getMargins().getTop() - this.getMargins().getBottom();
        while (!stop) {
            StiSize size = StiTextUtil.measureString((StiFont)font, (String)this.getTextInternal());
            if (size.width > thisWidth || size.height > thisHeight) {
                double fontSize = font.size;
                if (fontSize <= (double)minFontSize) break;
                font.setSize(fontSize - 0.5);
                continue;
            }
            stop = true;
        }
        return font;
    }

    public StiText() {
        this(StiRectangle.empty(), "");
    }

    public StiText(StiRectangle rect) {
        this(rect, "");
    }

    public StiText(StiRectangle rect, String text) {
        super(rect);
        this.SetTextInternal(text);
        this.setPlaceOnToolbox(true);
        this.setTextQuality(StiOptions.Engine.getDefaultTextQualityMode());
    }

    private String getColumnName() {
        String textValue = this.getText().getValue();
        int beginIndex = textValue.indexOf(46) + 1;
        int endIndex = textValue.length() - 1;
        return textValue.substring(beginIndex, endIndex);
    }

    @Override
    public Object clone() {
        StiText textBox = (StiText)super.clone();
        if (this.border != null) {
            textBox.border = (StiBorder)this.border.clone();
        }
        if (this.brush != null) {
            textBox.brush = (StiBrush)this.brush.clone();
        }
        if (this.textFormat != null) {
            textBox.textFormat = (StiFormatService)((Object)this.textFormat.clone());
        }
        if (this.textBrush != null) {
            textBox.textBrush = (StiBrush)this.textBrush.clone();
        }
        if (this.textOptions != null) {
            textBox.textOptions = (StiTextOptions)this.textOptions.clone();
        }
        textBox.horAlignment = this.horAlignment;
        textBox.vertAlignment = this.vertAlignment;
        return textBox;
    }

    @Override
    public StiSize getActualSize() {
        boolean autoWidth = this.getAutoWidth();
        if (this.getCanGrow() || this.getCanShrink() || autoWidth) {
            StiUnit unit = this.getPage().getUnit();
            StiRectangle rect = unit.ConvertToHInches(this.getClientRectangle());
            StiSize newSize = new StiSize(rect.getWidth(), rect.getHeight());
            rect = this.convertTextMargins(rect, false);
            rect = this.convertTextBorders(rect, false);
            StiSize actualSize = StiSize.EMPTY;
            actualSize = this.getAngle() == 90.0f || this.getAngle() == 270.0f ? StiStandardTextRenderer.MeasureString(rect.getHeight(), this.getFont(), this) : StiStandardTextRenderer.MeasureString(rect.getWidth(), this.getFont(), this);
            actualSize.width += this.getMargins().getLeft() + this.getMargins().getRight();
            actualSize.height += this.getMargins().getTop() + this.getMargins().getBottom();
            double borderSize = this.getBorder().getSize() / 2.0;
            actualSize.width += borderSize + borderSize;
            actualSize.height += borderSize + borderSize;
            if (autoWidth) {
                if (this.getAngle() == 90.0f || this.getAngle() == 270.0f) {
                    newSize.height = actualSize.height;
                } else {
                    newSize.width = actualSize.width;
                }
            }
            if (this.getCanGrow()) {
                if (this.getAngle() == 90.0f || this.getAngle() == 270.0f) {
                    if (actualSize.width > newSize.width) {
                        double fontHeight;
                        int line;
                        newSize.width = actualSize.width;
                        if (this.getMaxNumberOfLines() > 0 && (line = (int)(newSize.width / (fontHeight = this.getFont().getHeight()))) > this.getMaxNumberOfLines()) {
                            newSize.width = fontHeight * (double)this.getMaxNumberOfLines();
                            newSize.width *= EngineOptions.TextDrawingMeasurement.getMeasurementFactorStandard();
                        }
                    }
                } else if (actualSize.height > newSize.height) {
                    double fontHeight;
                    int line;
                    newSize.height = actualSize.height;
                    if (this.getMaxNumberOfLines() > 0 && (line = (int)(newSize.height / (fontHeight = this.getFont().getHeight()))) > this.getMaxNumberOfLines()) {
                        newSize.height = fontHeight * (double)this.getMaxNumberOfLines();
                        newSize.height *= EngineOptions.TextDrawingMeasurement.getMeasurementFactorStandard();
                    }
                }
            }
            if (this.getCanShrink()) {
                if (this.getAngle() == 90.0f || this.getAngle() == 270.0f) {
                    newSize.width = this.getTextInternal() == null || this.getTextInternal().trim().length() == 0 ? 0.0 : Math.min(actualSize.width, newSize.width);
                } else {
                    newSize.height = this.getTextInternal() == null || this.getTextInternal().trim().length() == 0 ? 0.0 : Math.min(actualSize.getHeight(), newSize.getHeight());
                }
            }
            return unit.ConvertFromHInches(newSize);
        }
        return new StiSize(this.getWidth(), this.getHeight());
    }

    @Override
    @StiSerializable(shortName="rc")
    public StiRectangle getClientRectangle() {
        return super.getClientRectangle();
    }

    @Override
    @StiSerializable(shortName="name")
    public String getName() {
        return super.getName();
    }

    @Override
    @StiSerializable(shortName="pl")
    @StiDefaulValue(value="")
    public String getComponentPlacement() {
        return super.getComponentPlacement();
    }

    @Override
    @StiSerializable(shortName="guid")
    public String getGuid() {
        return super.getGuid();
    }

    @Override
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument, shortName="tag")
    public String getTagValue() {
        return super.getTagValue();
    }

    @Override
    @StiSerializable(shortName="style")
    @StiDefaulValue(value="")
    public String getComponentStyle() {
        return super.getComponentStyle();
    }

    public StiSize measureString() {
        return StiTextUtil.measureString((StiFont)this.getFont(), (String)this.getText().getValue(), (float)this.getAngle());
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        if (this.getIndicator() != null) {
            jObject.AddPropertyJObject("Indicator", this.getIndicator().SaveToJsonObject(mode));
        }
        jObject.AddPropertyBool("CanBreak", this.getCanBreak());
        jObject.AddPropertyBool("AutoWidth", this.getAutoWidth());
        jObject.AddPropertyStringNullOfEmpty("RenderTo", this.getRenderTo());
        jObject.AddPropertyEnum("HorAlignment", (Enum)this.getHorAlignment(), (Enum)StiTextHorAlignment.Left);
        jObject.AddPropertyEnum("VertAlignment", (Enum)this.getVertAlignment(), (Enum)StiVertAlignment.Top);
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.fontDefault((StiFont)this.getFont()));
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.getBorder()));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        jObject.AddPropertyStringNullOfEmpty("TextBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getTextBrush()));
        jObject.AddPropertyJObject("TextOptions", this.getTextOptions().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ExcelValue", this.getExcelValue().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetExcelValueEvent", this.getGetExcelValueEvent().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("NullValue", this.getNullValue());
        jObject.AddPropertyEnum("Type", (Enum)this.getType(), (Enum)StiSystemTextType.None);
        jObject.AddPropertyBool("ExportAsImage", this.getExportAsImage());
        jObject.AddPropertyEnum("TextQuality", (Enum)this.getTextQuality(), (Enum)StiTextQuality.Standard);
        jObject.AddPropertyBool("AllowHtmlTags", this.getAllowHtmlTags(), false);
        jObject.AddPropertyJObject("Margins", this.getMargins().SaveToJsonObject(mode, 0.0, 0.0, 0.0, 0.0));
        jObject.AddPropertyBool("ShrinkFontToFit", this.getShrinkFontToFit(), false);
        jObject.AddPropertyFloat("ShrinkFontToFitMinimumSize", (double)this.getShrinkFontToFitMinimumSize(), 1.0);
        if (mode == StiJsonSaveMode.Report) {
            if (!(this.getTextFormat() instanceof StiGeneralFormatService)) {
                jObject.AddPropertyJObject("TextFormat", this.getTextFormat().SaveToJsonObject(mode));
            }
        } else {
            jObject.AddPropertyStringNullOfEmpty("Format", this.getFormat());
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Indicator")) {
                this.indicator = StiIndicator.LoadFromJsonObjectInternal((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("CanBreak")) {
                this.setCanBreak((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("AutoWidth")) {
                this.setAutoWidth((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("RenderTo")) {
                this.setRenderTo((String)property.Value);
                continue;
            }
            if (property.Name.equals("HorAlignment")) {
                this.horAlignment = StiTextHorAlignment.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("VertAlignment")) {
                this.vertAlignment = StiVertAlignment.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Font")) {
                this.font = StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.font);
                continue;
            }
            if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("TextBrush")) {
                this.textBrush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("TextFormat")) {
                this.setTextFormat(StiFormatService.LoadFromJsonObjectInternal((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("Format")) {
                this.format = (String)property.Value;
                continue;
            }
            if (property.Name.equals("TextOptions")) {
                this.textOptions.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("ExcelValue")) {
                StiExcelValueExpression _expression = new StiExcelValueExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setExcelValue(_expression);
                continue;
            }
            if (property.Name.equals("GetExcelValueEvent")) {
                StiGetExcelValueEvent _event = new StiGetExcelValueEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetExcelValueEvent(_event);
                continue;
            }
            if (property.Name.equals("NullValue")) {
                this.setNullValue((String)property.Value);
                continue;
            }
            if (property.Name.equals("Type")) {
                this.setType(StiSystemTextType.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("ExportAsImage")) {
                this.setExportAsImage((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("TextQuality")) {
                this.setTextQuality(StiTextQuality.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("AllowHtmlTags")) {
                this.setAllowHtmlTags((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Margins")) {
                StiMargins margins = new StiMargins();
                margins.LoadFromJsonObject((JSONObject)property.Value);
                this.setMargins(margins);
                continue;
            }
            if (property.Name.equals("ShrinkFontToFit")) {
                this.setShrinkFontToFit((Boolean)property.Value);
                continue;
            }
            if (!property.Name.equals("ShrinkFontToFitMinimumSize")) continue;
            this.setShrinkFontToFitMinimumSize(property.floatValue().floatValue());
        }
    }
}

