/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.textFormats;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.textFormats.StiNumberFormatService;
import com.stimulsoft.report.dictionary.data.DBNull;

public class StiCurrencyFormatService
extends StiNumberFormatService {
    private int positivePattern = 1;
    private String symbol = "$";

    public StiCurrencyFormatService() {
    }

    public StiCurrencyFormatService(int positivePattern, int negativePattern, String decimalSeparator, int decimalDigits, String groupSeparator, int groupSize, String symbol, boolean useGroupSeparator, boolean useLocalSetting, String nullDisplay) {
        this(positivePattern, negativePattern, 0, decimalSeparator, decimalDigits, groupSeparator, groupSize, symbol, useGroupSeparator, useLocalSetting, nullDisplay);
    }

    public StiCurrencyFormatService(int positivePattern, int negativePattern, int decimalPlaces, String decimalSeparator, int decimalDigits, String groupSeparator, int groupSize, String symbol, boolean useGroupSeparator, boolean useLocalSetting, String nullDisplay) {
        super(negativePattern, decimalSeparator, decimalDigits, groupSeparator, groupSize, useGroupSeparator, useLocalSetting, nullDisplay);
        this.setDecimalDigits(decimalDigits);
        this.setDecimalSeparator(decimalSeparator);
        this.setGroupSeparator(groupSeparator);
        this.setGroupSize(groupSize);
        this.setNegativePattern(negativePattern);
        this.setPositivePattern(positivePattern);
        this.setSymbol(symbol);
        this.setUseGroupSeparator(useGroupSeparator);
        this.setUseLocalSetting(useLocalSetting);
        this.setNullDisplay(nullDisplay);
    }

    @Override
    public String getServiceName() {
        return StiLocalization.getValue((String)"FormFormatEditor", (String)"Currency");
    }

    @Override
    public int getPosition() {
        return 3;
    }

    @StiDefaulValue(value="1")
    @StiSerializable
    public final int getPositivePattern() {
        return this.positivePattern;
    }

    public final void setPositivePattern(int value) {
        this.positivePattern = value;
    }

    @StiDefaulValue(value="$")
    @StiSerializable
    public final String getSymbol() {
        return this.symbol;
    }

    public final void setSymbol(String value) {
        this.symbol = value;
    }

    @Override
    public String getNativeFormatString() {
        return "{0:C2}";
    }

    @Override
    public Object getSample() {
        return -1234.12345679;
    }

    @Override
    public String getStringFormat() {
        return super.getStringFormat();
    }

    @Override
    public void setStringFormat(String value) {
        super.setStringFormat(value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.positivePattern;
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StiCurrencyFormatService other = (StiCurrencyFormatService)((Object)obj);
        if (this.positivePattern != other.positivePattern) {
            return false;
        }
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }

    @Override
    public String format(String stringFormat, Object arg) {
        if (StiValidationUtil.isEmpty((Object)arg) || arg instanceof DBNull) {
            return this.getNullDisplay();
        }
        if (StiValidationUtil.isNotNumber((Object)arg)) {
            return arg.toString();
        }
        Double val = StiTypeConverter.stringToDouble((String)arg.toString());
        String result = "";
        Double abs = Math.abs(val);
        Boolean sign = val < 0.0;
        Long integerPart = (long)Math.floor(abs);
        double decimalPower = Math.pow(10.0, this.getDecimalDigits());
        Long decimalPart = Math.round(StiMath.round((double)StiMath.round((double)(abs - (double)integerPart.longValue()), (int)(this.getDecimalDigits() + 1)), (int)this.getDecimalDigits()) * decimalPower);
        if ((double)decimalPart.longValue() >= decimalPower) {
            Long l = integerPart;
            Long l2 = integerPart = Long.valueOf(integerPart + 1L);
            decimalPart = 0L;
        }
        String integerStr = integerPart.toString();
        if (this.getGroupSize() > 0 && this.getUseGroupSeparator()) {
            int index;
            for (index = integerStr.length() - this.getGroupSize(); index >= 0; index -= this.getGroupSize()) {
                result = (index > 0 ? this.getGroupSeparator() : "") + integerStr.substring(index, index + this.getGroupSize()) + result;
            }
            if (index < 0) {
                result = integerStr.substring(0, index + this.getGroupSize()) + result;
            }
        } else {
            result = integerStr;
        }
        if (this.getDecimalDigits() > 0) {
            integerStr = decimalPart.toString();
            while (integerStr.length() < this.getDecimalDigits()) {
                integerStr = "0" + integerStr;
            }
            result = result + this.getDecimalSeparator() + integerStr;
        }
        if (!sign.booleanValue()) {
            switch (this.positivePattern) {
                case 0: {
                    result = this.symbol + result;
                    break;
                }
                case 2: {
                    result = this.symbol + " " + result;
                    break;
                }
                case 3: {
                    result = result + " " + this.symbol;
                    break;
                }
                default: {
                    result = result + this.symbol;
                    break;
                }
            }
        } else {
            switch (this.getNegativePattern()) {
                case 0: {
                    result = "(" + this.symbol + result + ")";
                    break;
                }
                case 1: {
                    result = "-" + this.symbol + result;
                    break;
                }
                case 2: {
                    result = this.symbol + "-" + result;
                    break;
                }
                case 3: {
                    result = this.symbol + result + "-";
                    break;
                }
                case 4: {
                    result = "(" + result + this.symbol + ")";
                    break;
                }
                case 6: {
                    result = result + "-" + this.symbol;
                    break;
                }
                case 7: {
                    result = result + this.symbol + "-";
                    break;
                }
                case 8: {
                    result = "-" + result + " " + this.symbol;
                    break;
                }
                case 9: {
                    result = "-" + this.symbol + " " + result;
                    break;
                }
                case 10: {
                    result = result + " " + this.symbol + "-";
                    break;
                }
                case 11: {
                    result = this.symbol + " " + result + "-";
                    break;
                }
                case 12: {
                    result = this.symbol + " -" + result;
                    break;
                }
                case 13: {
                    result = this.symbol + result + "-";
                    break;
                }
                case 14: {
                    result = result + "- " + this.symbol;
                    break;
                }
                case 15: {
                    result = "(" + this.symbol + " " + result + ")";
                    break;
                }
                case 16: {
                    result = "(" + result + " " + this.symbol + ")";
                    break;
                }
                default: {
                    result = "-" + result + this.symbol;
                }
            }
        }
        return result;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("StringFormat");
        jObject.AddPropertyIntNoDefaultValue("PositivePattern", Integer.valueOf(this.getPositivePattern()));
        jObject.AddPropertyString("Symbol", this.getSymbol(), "$");
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("PositivePattern")) {
                this.positivePattern = (Integer)property.Value;
                continue;
            }
            if (!property.Name.equals("Symbol")) continue;
            this.symbol = (String)property.Value;
        }
    }
}

