/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.crossTab.core;

import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiStandardTextRenderer;
import com.stimulsoft.report.crossTab.StiCrossField;
import java.math.BigDecimal;
import java.util.HashMap;

public class StiCell
implements Cloneable {
    private StiSize size = StiSize.EMPTY;
    private boolean isChangeWidthForRightToLeft;
    private boolean isNumeric;
    private boolean isImage;
    public StiCrossField field;
    private String text = "";
    private String hyperlinkValue;
    private String toolTipValue;
    private String tagValue;
    private StiCell parentCell;
    private Object val;
    private int width = 1;
    private int height = 1;
    private int summaryIndex = -1;
    private boolean isCrossSummary;
    private HashMap<String, Object> drillDownParameters = null;
    private int level = -1;

    public StiCell() {
        this("", new BigDecimal(0), null);
    }

    public StiCell(String text, BigDecimal value, StiCrossField field) {
        this(text, value, 1, 1, field);
        this.isNumeric = true;
    }

    public StiCell(String text, BigDecimal value, int width, int height, StiCrossField field) {
        this.text = text;
        this.val = value;
        this.width = width;
        this.height = height;
        this.field = field;
    }

    public final StiSize getSize() {
        return this.size;
    }

    public final void setSize(StiSize value) {
        this.size = value;
    }

    public final boolean getIsChangeWidthForRightToLeft() {
        return this.isChangeWidthForRightToLeft;
    }

    public final void setIsChangeWidthForRightToLeft(boolean value) {
        this.isChangeWidthForRightToLeft = value;
    }

    public final boolean getIsNumeric() {
        return this.isNumeric;
    }

    public final void setIsNumeric(boolean value) {
        this.isNumeric = value;
    }

    public final boolean getIsImage() {
        return this.isImage;
    }

    public final void setIsImage(boolean value) {
        this.isImage = value;
    }

    public final StiCrossField getField() {
        return this.field;
    }

    public final void setField(StiCrossField value) {
        this.field = value;
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String value) {
        this.text = value;
    }

    public final String getHyperlinkValue() {
        return this.hyperlinkValue;
    }

    public final void setHyperlinkValue(String value) {
        this.hyperlinkValue = value;
    }

    public final String getToolTipValue() {
        return this.toolTipValue;
    }

    public final void setToolTipValue(String value) {
        this.toolTipValue = value;
    }

    public final String getTagValue() {
        return this.tagValue;
    }

    public final void setTagValue(String value) {
        this.tagValue = value;
    }

    public final StiCell getParentCell() {
        return this.parentCell;
    }

    public final void setParentCell(StiCell value) {
        this.parentCell = value;
    }

    public final Object getValue() {
        return this.val;
    }

    public final void setValue(Object value) {
        this.val = value;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int value) {
        this.width = value;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int value) {
        this.height = value;
    }

    public final int getSummaryIndex() {
        return this.summaryIndex;
    }

    public final void setSummaryIndex(int value) {
        this.summaryIndex = value;
    }

    public final boolean getIsCrossSummary() {
        return this.isCrossSummary;
    }

    public final void setIsCrossSummary(boolean value) {
        this.isCrossSummary = value;
    }

    public final HashMap<String, Object> getDrillDownParameters() {
        return this.drillDownParameters;
    }

    public final void setDrillDownParameters(HashMap<String, Object> value) {
        if (this.drillDownParameters != value) {
            this.drillDownParameters = value;
        }
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String message = "%s [s:%s]";
        return String.format(message, this.text, this.getSize());
    }

    public StiSize doAutoSize() {
        if (this.isImage) {
            return StiSize.getEmpty();
        }
        double strMaxWidth = 10000.0;
        if (this.field.getMaxSize().width != 0.0) {
            strMaxWidth = this.getFieldWidth(this.field, this.field.getReport().getUnit().ConvertToHInches(this.field.getMaxSize().width));
        }
        if (this.field.getMaxSize().getHeight() != 0.0 && (this.field.getAngle() == 90.0f || this.field.getAngle() == 270.0f)) {
            strMaxWidth = this.getFieldHeight(this.field, this.field.getReport().getUnit().ConvertToHInches(this.field.getMaxSize().getHeight()));
        }
        String text = this.getField().getText().getValue();
        float angle = this.getField().getAngle();
        StiFont font = this.getField().getFont();
        return StiStandardTextRenderer.MeasureString(strMaxWidth, font, angle, text, this.field.getTextOptions().getWordWrap());
    }

    private double getFieldWidth(StiCrossField field, double value) {
        StiRectangle rect = new StiRectangle(0.0, 0.0, value, field.getHeight());
        rect = field.convertTextMargins(rect, false);
        rect = field.convertTextBorders(rect, false);
        return rect.getWidth();
    }

    private double getFieldHeight(StiCrossField field, double value) {
        StiRectangle rect = new StiRectangle(0.0, 0.0, field.getHeight(), value);
        rect = field.convertTextMargins(rect, false);
        rect = field.convertTextBorders(rect, false);
        return rect.getHeight();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

