/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRelationsCollection;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import java.util.Iterator;

public class StiDataBuilder {
    public static StiDataColumn getColumnFromPath(String path, StiDictionary dictionary) {
        String[] strs = path.split("\\.");
        String dataSourceStr = strs[0];
        Iterator i$ = dictionary.getDataSources().iterator();
        while (i$.hasNext()) {
            StiDataSource dataSource = (StiDataSource)i$.next();
            if (!StiNameValidator.CorrectName(dataSource.getName()).equals(dataSourceStr)) continue;
            String newPath = path.substring(dataSource.getName().length() + 1);
            return StiDataBuilder.getColumnFromPath(newPath, dataSource);
        }
        return null;
    }

    public static StiDataColumn getColumnFromPath(String path, StiDataSource dataSource) {
        String[] strs = path.split("\\.");
        int index = 0;
        String str = strs[index];
        while (true) {
            Iterator i$ = dataSource.getColumns().iterator();
            while (i$.hasNext()) {
                StiDataColumn dataColumn = (StiDataColumn)i$.next();
                if (!str.equals(StiNameValidator.CorrectName(dataColumn.getName())) || index != strs.length - 1) continue;
                return dataColumn;
            }
            StiDataRelationsCollection relations = dataSource.GetParentRelations();
            for (StiDataRelation relation : relations) {
                if (!str.equals(StiNameValidator.CorrectName(relation.getName()))) continue;
                String newPath = path.substring(relation.getName().length() + 1);
                return StiDataBuilder.getColumnFromPath(newPath, relation.getParentSource());
            }
            if (index == strs.length - 1) {
                return null;
            }
            str = str + "." + strs[++index];
        }
    }
}

