/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.type.StiSystemString;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.report.IStiInherited;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiCalcDataColumn;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRow;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class StiDataColumn
implements IStiSerializable,
IStiSerializableToString,
IStiName,
IStiInherited,
IStiJsonReportObject {
    private String name;
    private StiDataSource dataSource;
    private StiBusinessObject businessObject;
    private int index;
    private String nameInSource = "Column";
    private String alias;
    private String caption;
    private String key;
    private StiSystemType systemType;

    public void setSystemType(StiSystemType systemType) {
        this.systemType = systemType;
    }

    @StiSerializable
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public StiDataColumn() {
    }

    public StiDataColumn(String name, String alias, StiSystemType systemType) {
        this(name, name, alias, systemType);
    }

    public StiDataColumn(String nameInSource, String name, String alias, StiSystemType systemType) {
        this.nameInSource = nameInSource;
        this.name = StiNameValidator.CorrectName(name);
        this.alias = alias;
        this.systemType = systemType;
        this.index = -1;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        if (this.name != null && !this.name.equals(value)) {
            if (this.name.equals(this.nameInSource)) {
                this.nameInSource = value;
            }
            if (this.name.equals(this.alias)) {
                this.alias = value;
            }
        }
        this.name = StiNameValidator.CorrectName(value);
    }

    public final void setCorrectName(String value) {
        this.name = value;
    }

    @Override
    public final boolean getInherited() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getInherited();
        }
        return false;
    }

    @Override
    public final void setInherited(boolean value) {
    }

    public final StiDataSource getDataSource() {
        return this.dataSource;
    }

    public final void setDataSource(StiDataSource value) {
        this.dataSource = value;
    }

    public final StiBusinessObject getBusinessObject() {
        return this.businessObject;
    }

    public final void setBusinessObject(StiBusinessObject value) {
        this.businessObject = value;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int value) {
        this.index = value;
    }

    public final String getNameInSource() {
        return this.nameInSource;
    }

    public final void setNameInSource(String value) {
        if (!this.nameInSource.equals(value)) {
            this.nameInSource = value;
        }
    }

    public final String getAlias() {
        return this.alias;
    }

    public final void setAlias(String value) {
        this.alias = value;
    }

    public final StiSystemTypeEnum getType() {
        return this.systemType.getEnumType();
    }

    public static Object GetDataFromDataColumn(StiDictionary dictionary, String column) {
        return StiDataColumn.GetDataFromDataColumn(dictionary, column, true);
    }

    public static String GetRelationName(StiDictionary dictionary, StiDataSource dataSource, String relationName) {
        for (StiDataRelation relation : dictionary.getRelations()) {
            if (relation.getChildSource() != dataSource || !relationName.equals(relation.getName())) continue;
            return relation.getNameInSource();
        }
        return relationName;
    }

    public static Object GetDataFromBusinessObject(StiDictionary dictionary, String column) {
        String[] strs = column.split("[.]", -1);
        StiBusinessObject businessObject = dictionary.getBusinessObjects().get(strs[0]);
        if (businessObject == null) {
            return null;
        }
        for (int index = 1; index < strs.length; ++index) {
            if (index == strs.length - 1) {
                return businessObject.get(strs[index]);
            }
            businessObject = businessObject.getBusinessObjects().get(strs[index]);
        }
        return null;
    }

    public static StiBusinessObject GetBusinessObjectFromDataColumn(StiDictionary dictionary, String column) {
        String[] strs = column.split("[.]", -1);
        StiBusinessObject businessObject = dictionary.getBusinessObjects().get(strs[0]);
        if (businessObject == null) {
            return null;
        }
        for (int index = 1; index < strs.length; ++index) {
            if (index == strs.length - 1) {
                return businessObject;
            }
            businessObject = businessObject.getBusinessObjects().get(strs[index]);
        }
        return null;
    }

    public static Object GetDataFromDataColumn(StiDictionary dictionary, String column, boolean useRelationName) {
        block13: {
            try {
                String[] strs = column.split("[.]", -1);
                StiDataSource dataSource = dictionary.getDataSources().get(strs[0]);
                if (dataSource == null) {
                    return StiDataColumn.GetDataFromBusinessObject(dictionary, column);
                }
                StiDataRow row = null;
                int index = 1;
                for (int qnt = strs.length - 1; qnt > 0; --qnt) {
                    StiCalcDataColumn calcDataColumn;
                    if (qnt >= 2) {
                        String relationName = strs[index];
                        if (!useRelationName) {
                            relationName = StiDataColumn.GetRelationName(dictionary, dataSource, relationName);
                        }
                        row = row == null ? dataSource.GetParentData(relationName) : row.getParentData(relationName);
                        dataSource = dataSource.GetParentDataSource(relationName);
                        ++index;
                        continue;
                    }
                    if (dataSource != null && (calcDataColumn = (StiCalcDataColumn)(dataSource.getColumns().get(strs[index]) instanceof StiCalcDataColumn ? dataSource.getColumns().get(strs[index]) : null)) != null) {
                        if (dictionary != null && dictionary.getReport() != null && dictionary.getReport().getIsDesigning()) {
                            return null;
                        }
                        if (dictionary.getReport().getCalculationMode() == StiCalculationMode.Compilation) {
                            String name = String.format("Get%1$s_%2$s", StiNameValidator.CorrectName(calcDataColumn.getDataSource().getName()), StiNameValidator.CorrectName(calcDataColumn.getName()));
                            Method method = dictionary.getReport().getClass().getMethod(name, new Class[0]);
                            if (method != null) {
                                return method.invoke((Object)dictionary.getReport(), new Object[0]);
                            }
                        } else {
                            StiText textWrapper = new StiText();
                            textWrapper.setName("**calcDataColumn**");
                            textWrapper.setPage((StiPage)dictionary.getReport().getPages().get(0));
                            return StiParser.ParseTextValue("{" + calcDataColumn.getExpression() + "}", (StiComponent)textWrapper);
                        }
                    }
                    if (row != null) {
                        return row.get(strs[index]);
                    }
                    if (dataSource == null) {
                        return null;
                    }
                    return dataSource.GetData(strs[index]);
                }
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block13;
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getColumnPath() {
        return String.format("%s.%s", this.getDataSource().getName(), this.getName());
    }

    public static StiDataSource GetDataSourceFromDataColumn(StiDictionary dictionary, String column) {
        String[] strs = column.split("[.]", -1);
        try {
            return dictionary.getDataSources().get(strs[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Object> getDataListFromDataColumn(StiDictionary dictionary, String column, Integer maxRows) {
        ArrayList<Object> data = StiDataColumn.getDatasFromDataColumn(dictionary, column, maxRows);
        return data != null ? data : null;
    }

    public static ArrayList<Object> getDatasFromDataColumn(StiDictionary dictionary, String column, Integer maxRows) {
        try {
            ArrayList<Object> items = new ArrayList<Object>();
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(dictionary, column);
            if (dataSource != null) {
                int rowIndex = 0;
                while (!dataSource.getIsEof()) {
                    Object rowObject = StiDataColumn.GetDataFromDataColumn(dictionary, column);
                    if (rowObject != null) {
                        items.add(rowObject);
                    }
                    dataSource.Next();
                    if (maxRows == null || maxRows != ++rowIndex) continue;
                    break;
                }
                dataSource.First();
            }
            return items;
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return new ArrayList<Object>();
        }
    }

    public static String GetColumnNameFromDataColumn(StiDictionary dictionary, String column) {
        String[] strs = column.split("[.]", -1);
        return column.substring(strs[0].length() + 1);
    }

    public static Object[] GetDatasFromDataColumn(StiDictionary dictionary, String column) {
        try {
            StiBusinessObject businessObject;
            ArrayList<Object> items = new ArrayList<Object>();
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(dictionary, column);
            if (dataSource != null) {
                while (!dataSource.getIsEof()) {
                    Object rowObject = StiDataColumn.GetDataFromDataColumn(dictionary, column);
                    if (rowObject != null) {
                        items.add(rowObject);
                    }
                    dataSource.Next();
                }
                dataSource.First();
            }
            if ((businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(dictionary, column)) != null) {
                businessObject.SaveState("Totals");
                businessObject.CreateEnumerator();
                while (!businessObject.getIsEof()) {
                    Object rowObject = StiDataColumn.GetDataFromDataColumn(dictionary, column);
                    if (rowObject != null) {
                        items.add(rowObject);
                    }
                    businessObject.next();
                }
                businessObject.RestoreState("Totals");
            }
            Object[] objs = new Object[items.size()];
            objs = items.toArray(objs);
            return objs;
        }
        catch (Exception exception) {
            return new Object[0];
        }
    }

    public String toString() {
        return String.format("%s[%s] %s", this.getName(), this.getAlias(), this.getType());
    }

    public String serialize() {
        String data = this.systemType == null ? StiXMLConvert.encodeName((String)this.name) : (this.name.equals(this.alias) && this.name.equals(this.nameInSource) ? MessageFormat.format("{0},{1}", StiXMLConvert.encodeName((String)this.name), this.getTypeOrUserType()) : (this.name.equals(this.nameInSource) && !this.name.equals(this.alias) ? MessageFormat.format("{0},{1},{2}", StiXMLConvert.encodeName((String)this.name), StiXMLConvert.encodeName((String)this.alias), this.getTypeOrUserType()) : MessageFormat.format("ORIGINAL,{0},{1},{2},{3}", StiXMLConvert.encodeName((String)this.nameInSource), StiXMLConvert.encodeName((String)this.name), StiXMLConvert.encodeName((String)this.alias), this.getTypeOrUserType())));
        return data;
    }

    protected String getTypeOrUserType() {
        return this.systemType.getSerializeValue();
    }

    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        switch (values.length) {
            case 1: {
                this.nameInSource = StiXMLConvert.decodeName((String)values[0]);
                this.setName(this.nameInSource);
                this.alias = this.nameInSource;
                this.systemType = new StiSystemString();
                break;
            }
            case 2: {
                this.nameInSource = StiXMLConvert.decodeName((String)values[0]);
                this.setName(this.nameInSource);
                this.alias = this.nameInSource;
                this.setTypeOrUserType(values[1]);
                break;
            }
            case 3: {
                this.nameInSource = StiXMLConvert.decodeName((String)values[0]);
                this.setName(this.nameInSource);
                this.alias = StiXMLConvert.decodeName((String)values[1]);
                this.setTypeOrUserType(values[2]);
                break;
            }
            case 5: {
                this.nameInSource = StiXMLConvert.decodeName((String)values[1]);
                this.setName(StiXMLConvert.decodeName((String)values[2]));
                this.alias = StiXMLConvert.decodeName((String)values[3]);
                this.setTypeOrUserType(values[4]);
            }
        }
    }

    public void setTypeOrUserType(String systemTypeName) {
        this.systemType = StiSystemType.getSystemType((String)systemTypeName);
    }

    public StiSystemType getSystemType() {
        return this.systemType;
    }

    public static String getDataFromDataColumnStr(StiDictionary dictionary, String column) {
        Object value = StiDataColumn.GetDataFromDataColumn(dictionary, column);
        return value != null ? value.toString() : "";
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyStringNullOfEmpty("Name", this.getName());
        jObject.AddPropertyInt("Index", this.getIndex());
        jObject.AddPropertyStringNullOfEmpty("NameInSource", this.getNameInSource());
        jObject.AddPropertyStringNullOfEmpty("Alias", this.getAlias());
        jObject.AddPropertyStringNullOfEmpty("Type", this.getTypeOrUserType());
        jObject.AddPropertyStringNullOfEmpty("Key", this.getKey());
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Name")) {
                this.name = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Index")) {
                this.index = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("NameInSource")) {
                this.nameInSource = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Alias")) {
                this.alias = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Type")) {
                this.setTypeOrUserType((String)property.Value);
                continue;
            }
            if (!property.Name.equals("Key")) continue;
            this.key = (String)property.Value;
        }
    }
}

