/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.report.IStiInherited;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.expressions.StiExpression;
import java.sql.Date;
import java.util.HashMap;

public class StiDataParameter
extends StiExpression
implements IStiName,
IStiInherited {
    private String name;
    private Object parameterValue;
    private StiDataSource dataSource;
    private int type;
    private int size;

    public StiDataParameter() {
        this("Parameter", 0, 0);
    }

    public StiDataParameter(String name, int type, int size) {
        this(name, "", type, size);
    }

    public StiDataParameter(String name, String value, int type, int size) {
        this.type = type;
        this.name = name;
        this.setValue(value);
        this.size = size;
    }

    @Override
    public final boolean getInherited() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getInherited();
        }
        return false;
    }

    @Override
    public final void setInherited(boolean value) {
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        this.name = value;
    }

    @Override
    public boolean getApplyFormat() {
        return false;
    }

    @Override
    public String getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
    }

    public final String getExpression() {
        return this.getValue();
    }

    public final void setExpression(String value) {
        this.setValue(value);
    }

    public final Object GetParameterValue() {
        HashMap variables = null;
        if (this.getDataSource() != null && this.getDataSource().getDictionary() != null && this.getDataSource().getDictionary().getReport() != null) {
            variables = this.getDataSource().getDictionary().getReport().getVariables();
        }
        Object value = null;
        if (variables != null && variables.containsKey(this.getName())) {
            value = variables.get(this.getName());
            if (value instanceof String && ((String)value).equals("#null#")) {
                value = null;
            }
        } else {
            value = this.getParameterValue();
        }
        return value;
    }

    public final Object getParameterValueByDatabace() {
        Object result = this.getParameterValue();
        if (result instanceof StiDateTime) {
            result = new Date(((StiDateTime)result).getTimeInMillis());
        }
        return result;
    }

    public final Object getParameterValue() {
        return this.parameterValue;
    }

    public final void setParameterValue(Object value) {
        this.parameterValue = value;
    }

    public final StiDataSource getDataSource() {
        return this.dataSource;
    }

    public final void setDataSource(StiDataSource value) {
        this.dataSource = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int value) {
        this.type = value;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int value) {
        this.size = value;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String serialize() {
        String data = StiSerializerUtil.serializFormat((String)"{0},{1},{2},{3}", (Object[])new Object[]{StiXMLConvert.encodeName((String)this.name), StiXMLConvert.encodeName((String)this.getExpression()), this.type, this.size});
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.name = StiXMLConvert.decodeName((String)values[0]);
        this.setExpression(StiXMLConvert.decodeName((String)values[1]));
        this.type = StiSerializTypeConverter.stringToInteger((String)values[2]);
        this.size = StiSerializTypeConverter.stringToInteger((String)values[3]);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("Value");
        jObject.AddPropertyString("Name", this.getName());
        jObject.AddPropertyStringNullOfEmpty("Expression", this.getExpression());
        jObject.AddPropertyInt("Type", this.getType());
        jObject.AddPropertyInt("Size", this.getSize());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Name")) {
                this.name = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Expression")) {
                this.setExpression((String)property.Value);
                continue;
            }
            if (property.Name.equals("Type")) {
                this.type = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("Size")) {
                this.size = (Integer)property.Value;
                continue;
            }
            if (!property.Name.equals("Key")) continue;
        }
    }
}

