/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDictionary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class StiDataRelationsCollection
extends ArrayList<StiDataRelation>
implements IStiJsonReportObject {
    private static final long serialVersionUID = 3423269930008427699L;
    private static final Comparator<StiDataRelation> BY_NAME_IN_SOURCE = new Comparator<StiDataRelation>(){

        @Override
        public int compare(StiDataRelation value1, StiDataRelation value2) {
            return value1.getNameInSource().compareTo(value2.getNameInSource());
        }
    };
    private StiDictionary dictionary;

    public StiDataRelationsCollection() {
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiDataRelation relation : this) {
            jObject.AddPropertyJObject(index.toString(), relation.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            StiDataRelation relation = new StiDataRelation();
            relation.setDictionary(this.dictionary);
            relation.LoadFromJsonObject((JSONObject)property.Value);
            this.add(relation);
        }
    }

    @Override
    public boolean add(StiDataRelation e) {
        if (this.dictionary != null) {
            e.setDictionary(this.dictionary);
        }
        return super.add(e);
    }

    public StiDataRelationsCollection(StiDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public StiDataRelation get(String dataRelationName) {
        int index = this.getIndex(dataRelationName);
        return index >= 0 ? (StiDataRelation)this.get(index) : null;
    }

    private int getIndex(String dataRelationName) {
        String correctName = StiNameValidator.CorrectName(dataRelationName);
        Collections.sort(this, BY_NAME_IN_SOURCE);
        StiDataRelation keyInstance = new StiDataRelation();
        keyInstance.setNameInSource(correctName);
        int index = Collections.binarySearch(this, keyInstance, BY_NAME_IN_SOURCE);
        return index;
    }

    public boolean exist(String dataRelationName) {
        int index = this.getIndex(dataRelationName);
        return index >= 0;
    }
}

