/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;

public class StiDataRow {
    private DataRow row;
    private final StiDataSource dataSource;

    public StiDataRow(StiDataRow dataRow) {
        this(dataRow != null ? dataRow.dataSource : null, dataRow != null ? dataRow.getRow() : null);
    }

    public StiDataRow(StiDataSource dataSource, DataRow dataRow) {
        this.dataSource = dataSource;
        this.row = dataRow;
    }

    public Object get(String columnName) {
        return this.getItem(columnName);
    }

    public Object getValueAsObject(String columnName) {
        return this.row.getValueAsObject(columnName);
    }

    public final DataRow getRow() {
        return this.row;
    }

    public final void setRow(DataRow value) {
        this.row = value;
    }

    protected final StiDictionary getDictionary() {
        return this.dataSource.getDictionary();
    }

    public final Object getItem(String columnName) {
        if (this.row == null) {
            return null;
        }
        return this.row.getValue(columnName);
    }

    public StiDataRow GetParentData(String relationName) {
        StiDataRelation relations = this.dataSource.getRelations(relationName);
        DataRow firstParentRows = relations.getFirstParentRows(this.getRow());
        return new StiDataRow(this.dataSource.GetParentDataSource(relationName), firstParentRows);
    }

    public StiDataRow getParentData(String relation) {
        return this.GetParentData(relation);
    }
}

