/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.math.BigDecimal;

public class StiFunctionsStrings {
    public static String roman(int value) {
        return Func.Convert.toRoman(value);
    }

    public static String arabic(int value) {
        return Func.Convert.toArabic(value, (Boolean)false);
    }

    public static String arabic(String value) {
        return Func.Convert.toArabic(value, (Boolean)false);
    }

    public static String toWordsRu(BigDecimal value) {
        return Func.Ru.numToStr(value, 0);
    }

    public static String toWordsRu(BigDecimal value, Boolean upperCase) {
        return Func.Ru.numToStr(value, upperCase, 0);
    }

    public static String toWordsUa(BigDecimal value) {
        return Func.Ua.numToStr(value, 0);
    }

    public static String toWordsUa(BigDecimal value, Boolean upperCase) {
        return Func.Ua.numToStr(value, upperCase, 0);
    }

    public static String persian(int value) {
        return Func.Convert.toArabic(value, (Boolean)true);
    }

    public static String persian(String value) {
        return Func.Convert.toArabic(value, (Boolean)true);
    }

    @Deprecated
    public static String toProperCase(String value) {
        return StiValidationUtil.isNotNullOrEmpty((String)value) ? StiStringUtil.toTitleCase((String)value.toLowerCase()) : "";
    }

    public static String substring(Object str, int startIndex, int length) {
        if (str == null || DBNull.Value.equals(str)) {
            return "";
        }
        String st = str.toString();
        if (startIndex + length >= st.length()) {
            return st.substring(startIndex);
        }
        return st.substring(startIndex, startIndex + length);
    }

    public static String left(Object str, int length) {
        if (str == null || DBNull.Value.equals(str)) {
            return "";
        }
        String st = str.toString();
        if (length >= st.length()) {
            return st;
        }
        return st.substring(0, length);
    }

    public static String right(Object str, int length) {
        if (str == null || DBNull.Value.equals(str)) {
            return "";
        }
        String st = str.toString();
        if (length >= st.length()) {
            return st;
        }
        return st.substring(st.length() - length, st.length());
    }

    public static String mid(Object str, int startIndex, int length) {
        return StiFunctionsStrings.substring(str, startIndex, length);
    }

    public static String toOrdinal(Long value) {
        String s = value.toString();
        if (value < 1L) {
            return s;
        }
        if ((value = Long.valueOf(value % 100L)) >= 11L && value <= 13L) {
            return s + "th";
        }
        switch ((int)(value % 10L)) {
            case 1: {
                return s + "st";
            }
            case 2: {
                return s + "nd";
            }
            case 3: {
                return s + "rd";
            }
        }
        return s + "th";
    }
}

