/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.adapters;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiParsedParameters;
import com.stimulsoft.base.utils.StiParserParametersUtil;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.adapters.StiJDBCParameters;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class StiAbstractAdapter {
    private static final Logger LOG = Logger.getLogger("com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter");
    private static final String NOT_FOUND_OPTIONS = "In connection options ''{0}'' not found ''{1}'' ";
    private static final List<String> DATABASE_KEY = Arrays.asList("database", "database name", "databaseName", "data source");
    private static final List<String> PORT_KEY = Arrays.asList("port");
    private static final List<String> HOST_KEY = Arrays.asList("host", "server", "location");
    private static final List<String> USERS_KEYS = Arrays.asList("jdbc.username", "username", "uid", "user", "user id", "userId", "connection.username");
    private static final List<String> PASSWORD_KEYS = Arrays.asList("jdbc.password", "pwd", "password", "connection.password");
    protected static final List<String> URL_KEYS = Arrays.asList("jdbc.url", "connectionurl", "url", "connection.url");
    private static final List<String> DRIVER_KEYS = Arrays.asList("jdbc.driverclassname", "jdbc.driverclass", "jdbc.drivername", "jdbc.driver", "driverclassname", "driverclass", "drivername", "driver", "connection.driver", "connection.driver_class");
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_HOST = "localhost";
    public static final String OVERRIDE_CONNECTION_STRING = "OverrideConnectionString";
    private final Map<String, String> params;
    protected StiParsedParameters parsedParameters;

    public StiAbstractAdapter(String connectionString) {
        this.parsedParameters = StiParserParametersUtil.parsConectionString((String)connectionString);
        this.params = (Map)this.parsedParameters.getLowerKeyValue().clone();
    }

    public StiDataSource create(StiDictionary dictionary, Boolean addToDictionary) {
        StiDataSource dataSource = null;
        try {
            dataSource = this.getDataSourceClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dataSource != null && addToDictionary.booleanValue()) {
            dataSource.setName(StiNameCreation.createName(dictionary.getReport(), StiLocalization.getValue((String)"PropertyMain", (String)"DataSource")));
            dataSource.setAlias(dataSource.getName());
            dictionary.getDataSources().add(dataSource);
        }
        return dataSource;
    }

    public abstract Class<? extends StiDataSource> getDataSourceClass();

    public StiDataSource create(StiDictionary dictionary) {
        return this.create(dictionary, true);
    }

    public StiJDBCParameters getJdbcParameters() {
        String driverName = this.validation(this.getDriverName(), "driver name");
        String connectionURL = this.validation(this.getConnectionURL(), "connection URL");
        String user = this.getUser();
        String password = this.getPassword();
        Map<String, String> otherParams = this.getOtherParams();
        return new StiJDBCParameters(driverName, connectionURL, user, password, otherParams);
    }

    private Map<String, String> getOtherParams() {
        return this.parsedParameters.getOriginalKeyValue(this.params);
    }

    public StiParsedParameters getParsedParameters() {
        return this.parsedParameters;
    }

    protected String validation(String value, String name) {
        if (value == null) {
            try {
                throw new IllegalArgumentException(MessageFormat.format(NOT_FOUND_OPTIONS, this.parsedParameters.getOriginalKeyValue(), name));
            }
            catch (IllegalArgumentException e) {
                boolean isSerializing = false;
                ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>(Arrays.asList(e.getStackTrace()));
                for (StackTraceElement el : elements) {
                    if (el.getClassName().indexOf("com.stimulsoft.base.serializing") < 0) continue;
                    isSerializing = true;
                }
                if (!isSerializing) {
                    throw e;
                }
                return null;
            }
        }
        return value;
    }

    public abstract String getDriverName();

    protected abstract String getConnectionURL();

    protected abstract String getDefaultPort();

    protected String getUser() {
        return this.getUserForKey();
    }

    protected String getPassword() {
        return this.getPasswordForKey();
    }

    protected String getHost() {
        String host = this.getLeastOne(this.getHostKey());
        return host != null ? host : DEFAULT_HOST;
    }

    protected String getPort() {
        String port = this.getLeastOne(this.getPortKey());
        return port != null ? port : this.getDefaultPort();
    }

    public String getDataBase() {
        return this.getLeastOne(this.getDatabaseName());
    }

    private String getUserForKey() {
        return this.getLeastOne(USERS_KEYS);
    }

    private String getPasswordForKey() {
        String foundPassword = this.getLeastOne(PASSWORD_KEYS);
        return foundPassword != null ? foundPassword : DEFAULT_PASSWORD;
    }

    public String getLeastOne(List<String> keys) {
        return this.getLeastOne(keys, this.params);
    }

    public boolean hasLeastOne(List<String> keys) {
        return this.hasLeastOne(keys, this.params);
    }

    public String getLeastOne(List<String> keys, Map<String, String> params) {
        for (String key : keys) {
            String value = params.get(key);
            if (value == null) continue;
            params.remove(key);
            return value;
        }
        return null;
    }

    public boolean hasLeastOne(List<String> keys, Map<String, String> params) {
        for (String key : keys) {
            String value = params.get(key);
            if (value == null) continue;
            return true;
        }
        return false;
    }

    public List<String> getUrlKeys() {
        return URL_KEYS;
    }

    public List<String> getPortKey() {
        return PORT_KEY;
    }

    public List<String> getHostKey() {
        return HOST_KEY;
    }

    public List<String> getDatabaseName() {
        return DATABASE_KEY;
    }

    public List<String> getDriverKeys() {
        return DRIVER_KEYS;
    }

    protected Map<String, String> getParams() {
        return this.params;
    }
}

