/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.util.ArrayList;

public class StiMedianDecimalFunctionService
extends StiAggregateFunctionService {
    private ArrayList<Long> values;

    public StiMedianDecimalFunctionService() {
    }

    public StiMedianDecimalFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        long val = StiObjectConverter.ConvertToInt64((Object)value);
        this.values.add(val);
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return Long.class;
    }

    public String getServiceName() {
        return "Median";
    }

    @Override
    public Object GetValue() {
        if (this.values == null || this.values.size() < 2) {
            return null;
        }
        int middlePosition = this.values.size() / 2;
        if (this.values.size() % 2 == 1) {
            return this.values.get(middlePosition);
        }
        long value1 = this.values.get(middlePosition - 1);
        long value2 = this.values.get(middlePosition);
        return (value1 + value2) / 2L;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.values = new ArrayList();
        }
    }

    @Override
    public void SetValue(Object value) {
        throw new IllegalArgumentException("You can't set calculation result to Median function!");
    }
}

