/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.util.ArrayList;

public class StiMedianDoubleFunctionService
extends StiAggregateFunctionService {
    private ArrayList<Double> values;

    public StiMedianDoubleFunctionService() {
    }

    public StiMedianDoubleFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        double val = StiObjectConverter.ConvertToDouble((Object)value);
        this.values.add(val);
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return Double.class;
    }

    public String getServiceName() {
        return "MedianD";
    }

    @Override
    public Object GetValue() {
        if (this.values == null || this.values.size() < 2) {
            return null;
        }
        int middlePosition = this.values.size() / 2;
        if (this.values.size() % 2 == 1) {
            return (double)this.values.get(middlePosition);
        }
        double value1 = this.values.get(middlePosition - 1);
        double value2 = this.values.get(middlePosition);
        return (value1 + value2) / 2.0;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.values = new ArrayList();
        }
    }

    @Override
    public void SetValue(Object value) {
        throw new IllegalArgumentException("You can't set calculation result to MedianD function!");
    }
}

