/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import java.util.Date;

public class StiMinTimeFunctionService
extends StiAggregateFunctionService {
    private Date minimum = new Date();
    private boolean valueProcessed = false;

    public StiMinTimeFunctionService() {
    }

    public StiMinTimeFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value instanceof Date) {
            Date timeValue = (Date)value;
            if (this.valueProcessed) {
                if (this.minimum.before(timeValue)) {
                    this.minimum = timeValue;
                }
            } else {
                this.minimum = timeValue;
                this.valueProcessed = true;
            }
        }
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return Date.class;
    }

    public String getServiceName() {
        return "MinTime";
    }

    @Override
    public Object GetValue() {
        return this.minimum;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.valueProcessed = false;
        }
    }

    @Override
    public void SetValue(Object value) {
        this.minimum = (Date)value;
    }
}

