/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.util.Hashtable;

public class StiModeDoubleFunctionService
extends StiAggregateFunctionService {
    private Hashtable<Double, Integer> values;

    public StiModeDoubleFunctionService() {
    }

    public StiModeDoubleFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        double val = StiObjectConverter.ConvertToDouble((Object)value);
        Integer count = this.values.get(val);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.values.put(val, count);
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return Double.class;
    }

    public String getServiceName() {
        return "ModeD";
    }

    @Override
    public Object GetValue() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        double freqValue = 0.0;
        int freqCount = 0;
        for (Double value : this.values.keySet()) {
            int count = this.values.get(value);
            if (count <= freqCount) continue;
            freqCount = count;
            freqValue = value;
        }
        return freqValue;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.values = new Hashtable();
        }
    }

    @Override
    public void SetValue(Object value) {
        throw new IllegalArgumentException("You can't set calculation result to Mode function!");
    }
}

