/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.math.BigDecimal;
import java.util.Hashtable;

public class StiSumDistinctDecimalFunctionService
extends StiAggregateFunctionService {
    private long summary;
    private Hashtable<Object, Object> values;

    public StiSumDistinctDecimalFunctionService() {
    }

    public StiSumDistinctDecimalFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (this.values == null) {
            this.values = new Hashtable();
        }
        if (value == null || value == DBNull.Value) {
            return;
        }
        if (this.values.get(value) == null) {
            this.values.put(value, value);
            this.summary += StiObjectConverter.ConvertToInt64((Object)value);
        }
    }

    public void CalcItem(Object value, Object valueToSum) {
        if (this.values == null) {
            this.values = new Hashtable();
        }
        if (value == null || value == DBNull.Value) {
            return;
        }
        if (!this.values.containsKey(value)) {
            this.values.put(value, value);
            this.summary = (long)((double)this.summary + StiObjectConverter.ConvertToDecimal((Object)valueToSum).doubleValue());
        }
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class<?> GetResultType() {
        return BigDecimal.class;
    }

    public String getServiceName() {
        return "SumDistinct";
    }

    @Override
    public Object GetValue() {
        return this.summary;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.summary = 0L;
            this.values = new Hashtable();
        }
    }

    @Override
    public void SetValue(Object value) {
        this.summary = (Long)value;
    }
}

