/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.data;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DataCell;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class StiDateDataCell
extends DataCell {
    private static final String DATE_STRING_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private StiDateTime value;

    public StiDateDataCell(StiDataColumn column, Object value) {
        super(column, value != null ? value.toString() : "");
        try {
            if (value instanceof Calendar) {
                this.value = new StiDateTime((Calendar)value);
            } else if (value instanceof Date) {
                this.value = new StiDateTime((Date)value);
            } else if (value != null && StiValidationUtil.isNotNullOrEmpty((String)value.toString())) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat(DATE_STRING_FORMAT, Locale.ENGLISH);
                    this.value = new StiDateTime(formatter.parse(value.toString()));
                }
                catch (Exception e) {
                    SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
                    this.value = new StiDateTime(formatter.parse(value.toString()));
                }
            } else {
                this.value = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public StiDateTime getValue() {
        return this.value;
    }
}

